/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.StringCompressor;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public class StringCompressorTest
extends AbstractOMTest {
    private static long SLEEP_WRITER = 1L;
    private static long SLEEP_READER = 0L;
    private static final String[] strings = StringCompressorTest.createStrings(50, 837456L);
    private static final int[] indices = StringCompressorTest.createIndices(100, 50, 9087346L);
    private StringCompressor.Counting client;
    private StringCompressor.Counting server;

    public void testSingleStreamToServer() throws Exception {
        this.run(1, 0);
    }

    public void testSingleStreamToClient() throws Exception {
        this.run(0, 1);
    }

    public void testBidi1() throws Exception {
        this.run(1, 1);
    }

    public void testBidi10() throws Exception {
        this.run(10, 10);
    }

    public void testBidi1Plus10() throws Exception {
        this.run(1, 1);
        this.run(10, 10);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client = new StringCompressor.Counting(true);
        this.server = new StringCompressor.Counting(false);
    }

    protected void doTearDown() throws Exception {
        System.out.println("Strings read by client compressor: " + this.client.getStringsRead());
        System.out.println("Strings read by server compressor: " + this.server.getStringsRead());
        System.out.println("Strings written by client compressor: " + this.client.getStringsWritten());
        System.out.println("Strings written by server compressor: " + this.server.getStringsWritten());
        super.doTearDown();
    }

    private void run(int toServer, int toClient) throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(toServer + toClient);
        while (toServer > 0 || toClient > 0) {
            if (toServer > 0) {
                --toServer;
                new Stream(latch, (StringCompressor)this.client, (StringCompressor)this.server).start();
            }
            if (toClient <= 0) continue;
            --toClient;
            new Stream(latch, (StringCompressor)this.server, (StringCompressor)this.client).start();
        }
        latch.await(300L, TimeUnit.SECONDS);
    }

    private static String[] createStrings(int count, long seed) {
        Random random = new Random(seed);
        String[] result = new String[count];
        int i = 0;
        while (i < result.length) {
            String str = "";
            int length = StringCompressorTest.next(random) % 13;
            int j = 0;
            while (j < length + 1) {
                int val = StringCompressorTest.next(random);
                str = String.valueOf(str) + Integer.toString(val, 36);
                ++j;
            }
            result[i] = str;
            ++i;
        }
        return result;
    }

    private static int[] createIndices(int count, int range, long seed) {
        Random random = new Random(seed);
        int[] result = new int[count];
        int i = 0;
        while (i < result.length) {
            result[i] = StringCompressorTest.next(random) % range;
            ++i;
        }
        return result;
    }

    private static int next(Random random) {
        int val;
        while ((val = random.nextInt()) <= 0) {
        }
        return val;
    }

    public static class Reader
    extends Thread {
        private StringCompressor compressor;
        private PipedInputStream pipe;
        private Exception exception;

        public Reader(StringCompressor compressor, Writer writer) throws IOException {
            this.compressor = compressor;
            this.pipe = new PipedInputStream(writer.getPipe());
        }

        public Exception getException() {
            return this.exception;
        }

        public void run() {
            try {
                ExtendedDataInputStream in = new ExtendedDataInputStream((InputStream)this.pipe);
                int i = 0;
                while (i < indices.length) {
                    int index = indices[i];
                    StringCompressorTest.msg(String.valueOf(this.getName()) + " --> " + i);
                    String toBeRead = strings[index];
                    String read = this.compressor.read((ExtendedDataInput)in);
                    StringCompressorTest.assertEquals((String)toBeRead, (String)read);
                    if (SLEEP_READER > 0L) {
                        Thread.sleep(SLEEP_READER);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                this.exception = ex;
                ex.printStackTrace();
            }
        }
    }

    public static class Stream
    extends Thread {
        private CountDownLatch latch;
        private Writer writer;
        private Reader reader;

        public Stream(CountDownLatch latch, StringCompressor writer, StringCompressor reader) throws IOException {
            this.latch = latch;
            this.writer = new Writer(writer);
            this.reader = new Reader(reader, this.writer);
        }

        public void run() {
            try {
                this.reader.start();
                this.writer.start();
                this.reader.join();
                this.writer.join();
                this.latch.countDown();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static class Writer
    extends Thread {
        private StringCompressor compressor;
        private PipedOutputStream pipe;
        private Exception exception;

        public Writer(StringCompressor compressor) {
            this.compressor = compressor;
            this.pipe = new PipedOutputStream();
        }

        public PipedOutputStream getPipe() {
            return this.pipe;
        }

        public Exception getException() {
            return this.exception;
        }

        public void run() {
            try {
                ExtendedDataOutputStream out = new ExtendedDataOutputStream((OutputStream)this.pipe);
                int i = 0;
                while (i < indices.length) {
                    int index = indices[i];
                    StringCompressorTest.msg(String.valueOf(this.getName()) + " --> " + i);
                    this.compressor.write((ExtendedDataOutput)out, strings[index]);
                    if (SLEEP_WRITER > 0L) {
                        Thread.sleep(SLEEP_WRITER);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                this.exception = ex;
                ex.printStackTrace();
            }
        }
    }
}

