/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db.offline;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.tests.config.impl.RepositoryConfig;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;

public abstract class DBOfflineConfig
extends RepositoryConfig.OfflineConfig {
    private static final long serialVersionUID = 1L;
    private boolean withRanges;
    private boolean copyOnBranch;

    public DBOfflineConfig(String name) {
        super(name);
    }

    public DBOfflineConfig supportingAudits(boolean supportingAudits) {
        return (DBOfflineConfig)super.supportingAudits(supportingAudits);
    }

    public DBOfflineConfig supportingBranches(boolean supportingBranches) {
        return (DBOfflineConfig)super.supportingBranches(supportingBranches);
    }

    public DBOfflineConfig supportingChunks(boolean supportingChunks) {
        return (DBOfflineConfig)super.supportingChunks(supportingChunks);
    }

    public DBOfflineConfig supportingExtRefs(boolean supportingExtRefs) {
        return (DBOfflineConfig)super.supportingExtRefs(supportingExtRefs);
    }

    public DBOfflineConfig idGenerationLocation(CDOCommonRepository.IDGenerationLocation idGenerationLocation) {
        return (DBOfflineConfig)super.idGenerationLocation(idGenerationLocation);
    }

    public boolean withRanges() {
        return this.withRanges;
    }

    public DBOfflineConfig withRanges(boolean withRanges) {
        this.withRanges = withRanges;
        return this;
    }

    public boolean copyOnBranch() {
        return this.copyOnBranch;
    }

    public DBOfflineConfig copyOnBranch(boolean copyOnBranch) {
        this.copyOnBranch = copyOnBranch;
        return this;
    }

    protected String getStoreName() {
        return "MEM";
    }

    public void initCapabilities(Set<String> capabilities) {
        super.initCapabilities(capabilities);
        if (this.withRanges()) {
            capabilities.add("DB.ranges");
        }
        if (this.copyOnBranch()) {
            capabilities.add("DB.copy.on.branch");
        }
    }

    public IStore createStore(String repoName) {
        IMappingStrategy mappingStrategy = this.createMappingStrategy();
        mappingStrategy.setProperties(this.createMappingStrategyProperties());
        IDBAdapter dbAdapter = this.createDBAdapter();
        DataSource dataSource = this.createDataSource(repoName);
        IDBConnectionProvider connectionProvider = dbAdapter.createConnectionProvider(dataSource);
        return CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)connectionProvider);
    }

    public void setUp() throws Exception {
        CDODBUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
        super.setUp();
    }

    protected Map<String, String> createMappingStrategyProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("qualifiedNames", "true");
        props.put("copyOnBranch", Boolean.toString(this.copyOnBranch));
        return props;
    }

    protected IMappingStrategy createMappingStrategy() {
        return CDODBUtil.createHorizontalMappingStrategy((boolean)this.supportingAudits(), (boolean)this.supportingBranches(), (boolean)this.withRanges);
    }

    protected String getMappingStrategySpecialization() {
        return String.valueOf(this.withRanges ? "-ranges" : "") + (this.copyOnBranch ? "-copy" : "");
    }

    protected abstract DataSource createDataSource(String var1);

    protected abstract IDBAdapter createDBAdapter();
}

