/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db.mysql;

import com.mysql.jdbc.ConnectionProperties;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.spi.db.DBAdapter;

public class MYSQLAdapter
extends DBAdapter {
    public static final String NAME = "mysql";
    public static final String VERSION = "5.1.5";
    private static final String[] RESERVED_WORDS = new String[]{"ACCESSIBLE", "ACTION", "ADD", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ASENSITIVE", "BEFORE", "BETWEEN", "BIGINT", "BINARY", "BIT", "BLOB", "BOTH", "BY", "CALL", "CASCADE", "CASE", "CHANGE", "CHAR", "CHARACTER", "CHECK", "COLLATE", "COLUMN", "COLUMNS", "CONDITION", "CONNECTION", "CONSTRAINT", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DATABASES", "DATE", "DAY_HOUR", "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELAYED", "DELETE", "DESC", "DESCRIBE", "DETERMINISTIC", "DISTINCT", "DISTINCTROW", "DIV", "DOUBLE", "DROP", "DUAL", "EACH", "ELSE", "ELSEIF", "ENCLOSED", "ENUM", "ESCAPED", "EXISTS", "EXIT", "EXPLAIN", "FALSE", "FETCH", "FIELDS", "FLOAT", "FLOAT4", "FLOAT8", "FOR", "FORCE", "FOREIGN", "FROM", "FULLTEXT", "GENERAL", "GOTO", "GRANT", "GROUP", "HAVING", "HIGH_PRIORITY", "HOUR_MICROSECOND", "HOUR_MINUTE", "HOUR_SECOND", "IF", "IGNORE", "IGNORE_SERVER_IDS", "IN", "INDEX", "INFILE", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INT1", "INT2", "INT3", "INT4", "INT8", "INTEGER", "INTERVAL", "INTO", "IS", "ITERATE", "JOIN", "KEY", "KEYS", "KILL", "LABEL", "LEADING", "LEAVE", "LEFT", "LIKE", "LIMIT", "LINEAR", "LINES", "LOAD", "LOCALTIME", "LOCALTIMESTAMP", "LOCK", "LONG", "LONGBLOB", "LONGTEXT", "LOOP", "LOW_PRIORITY", "MASTER_HEARTBEAT_PERIOD", "MASTER_SSL_VERIFY_SERVER_CERT", "MATCH", "MAXVALUE", "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MIDDLEINT", "MINUTE_MICROSECOND", "MINUTE_SECOND", "MOD", "MODIFIES", "NATURAL", "NO", "NOT", "NO_WRITE_TO_BINLOG", "NULL", "NUMERIC", "ON", "OPTIMIZE", "OPTION", "OPTIONALLY", "OR", "ORDER", "OUT", "OUTER", "OUTFILE", "PRECISION", "PRIMARY", "PRIVILEGES", "PROCEDURE", "PURGE", "RAID0", "RANGE", "READ", "READS", "READ_WRITE", "REAL", "REFERENCES", "REGEXP", "RELEASE", "RENAME", "REPEAT", "REPLACE", "REQUIRE", "RESIGNAL", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "RLIKE", "SCHEMA", "SCHEMAS", "SECOND_MICROSECOND", "SELECT", "SENSITIVE", "SEPARATOR", "SET", "SHOW", "SIGNAL", "SLOW", "SMALLINT", "SONAME", "SPATIAL", "SPECIFIC", "SQL", "SQL_BIG_RESULT", "SQL_CALC_FOUND_ROWS", "SQLEXCEPTION", "SQL_SMALL_RESULT", "SQLSTATE", "SQLWARNING", "SSL", "STARTING", "STRAIGHT_JOIN", "TABLE", "TABLES", "TERMINATED", "TEXT", "THEN", "TIME", "TIMESTAMP", "TINYBLOB", "TINYINT", "TINYTEXT", "TO", "TRAILING", "TRIGGER", "TRUE", "UNDO", "UNION", "UNIQUE", "UNLOCK", "UNSIGNED", "UPDATE", "UPGRADE", "USAGE", "USE", "USING", "UTC_DATE", "UTC_TIME", "UTC_TIMESTAMP", "VALUES", "VARBINARY", "VARCHAR", "VARCHARACTER", "VARYING", "WHEN", "WHERE", "WHILE", "WITH", "WRITE", "X509", "XOR", "YEAR_MONTH", "ZEROFILL"};

    public MYSQLAdapter() {
        super(NAME, VERSION);
    }

    public int getMaxTableNameLength() {
        return 64;
    }

    public int getMaxFieldNameLength() {
        return 64;
    }

    protected String getTypeName(IDBField field) {
        DBType type = field.getType();
        switch (type) {
            case VARCHAR: 
            case CLOB: {
                return "LONGTEXT";
            }
            case BLOB: {
                return "LONGBLOB";
            }
        }
        return super.getTypeName(field);
    }

    protected void dropPrimaryKey(IDBIndex index, StringBuilder builder) {
        builder.append("ALTER TABLE ");
        builder.append(index.getTable());
        builder.append(" DROP PRIMARY KEY");
    }

    protected void addIndexField(StringBuilder builder, IDBField field) {
        super.addIndexField(builder, field);
        if (field.getType() == DBType.VARCHAR) {
            builder.append("(");
            builder.append(field.getPrecision());
            builder.append(")");
        }
    }

    public String[] getReservedWords() {
        return RESERVED_WORDS;
    }

    public boolean isTypeIndexable(DBType type) {
        switch (type) {
            case VARCHAR: {
                return false;
            }
        }
        return super.isTypeIndexable(type);
    }

    public boolean isDuplicateKeyException(SQLException ex) {
        return "23000".equals(ex.getSQLState());
    }

    public String sqlRenameField(IDBField field, String oldName) {
        return "ALTER TABLE " + field.getTable() + " CHANGE COLUMN " + oldName + " " + field + " " + this.createFieldDefinition(field);
    }

    protected String sqlModifyField(String tableName, String fieldName, String definition) {
        return "ALTER TABLE " + tableName + " MODIFY " + fieldName + " " + definition;
    }

    public Connection modifyConnection(Connection connection) {
        if (connection instanceof ConnectionProperties) {
            ConnectionProperties connectionProperties = (ConnectionProperties)connection;
            connectionProperties.setUseLocalSessionState(true);
        }
        return super.modifyConnection(connection);
    }
}

