/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.net4j.ITransportConfigAware;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.tests.AbstractProtocolTest;
import org.eclipse.net4j.tests.data.HugeData;
import org.eclipse.net4j.tests.data.TinyData;
import org.eclipse.net4j.tests.signal.ArrayRequest;
import org.eclipse.net4j.tests.signal.TestSignalProtocol;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.MonitoredThread;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.tests.AbstractOMTest;
import org.eclipse.spi.net4j.InternalConnector;

public abstract class ChannelTest
extends AbstractProtocolTest {
    private static final long TIMEOUT = 20000L;
    private static final int THREADS = 40;
    private List<TestSignalProtocol> protocols;

    public void testAllBufferSizes() throws Exception {
        this.disableConsole();
        TestSignalProtocol protocol = this.openTestSignalProtocol();
        ChannelTest.assertActive((Object)protocol);
        byte[] data = HugeData.getBytes();
        ChannelTest.assertEquals((boolean)true, (data.length > 2 * ((ITransportConfigAware)this.getConnector()).getConfig().getBufferProvider().getBufferCapacity() ? 1 : 0) != 0);
        int i = 1;
        while (i < data.length) {
            byte[] dataToSend = new byte[i];
            System.arraycopy(data, 0, dataToSend, 0, i);
            byte[] result = (byte[])new ArrayRequest(protocol, dataToSend).send();
            ChannelTest.assertEquals((boolean)true, (boolean)Arrays.equals(dataToSend, result));
            ++i;
        }
        protocol.close();
        ChannelTest.assertInactive((Object)protocol);
        this.enableConsole();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleThreadNoData() throws Exception {
        final AbstractOMTest.LatchTimeOuter timeOuter = new AbstractOMTest.LatchTimeOuter(4);
        DeactivationListener deactivationListener = new DeactivationListener(){

            @Override
            protected void onDeactivated(ILifecycle lifecycle) {
                super.onDeactivated(lifecycle);
                timeOuter.countDown();
            }
        };
        TestSignalProtocol protocol = this.openTestSignalProtocol();
        protocol.addListener((IListener)deactivationListener);
        ChannelTest.assertActive((Object)protocol);
        IChannel channel = protocol.getChannel();
        channel.addListener((IListener)deactivationListener);
        ChannelTest.assertActive(channel);
        InternalConnector serverConnector = (InternalConnector)this.getAcceptor().getAcceptedConnectors()[0];
        Collection serverChannels = serverConnector.getChannels();
        ChannelTest.assertEquals((int)1, (int)serverChannels.size());
        IChannel serverChannel = (IChannel)serverChannels.iterator().next();
        serverChannel.addListener((IListener)deactivationListener);
        ChannelTest.assertActive(serverChannel);
        TestSignalProtocol serverProtocol = (TestSignalProtocol)serverChannel.getReceiveHandler();
        serverProtocol.addListener((IListener)deactivationListener);
        ChannelTest.assertActive((Object)serverProtocol);
        protocol.close();
        ChannelTest.assertInactive((Object)protocol);
        ChannelTest.assertInactive(channel);
        ChannelTest.assertInactive(serverChannel);
        ChannelTest.assertInactive((Object)serverProtocol);
        ChannelTest.assertEquals((int)0, (int)serverConnector.getChannels().size());
        timeOuter.assertNoTimeOut();
        Set<ILifecycle> deactivatedSet = deactivationListener.getDeactivatedSet();
        ChannelTest.assertEquals((boolean)true, (boolean)deactivatedSet.contains(channel));
        ChannelTest.assertEquals((boolean)true, (boolean)deactivatedSet.contains((Object)protocol));
        ChannelTest.assertEquals((boolean)true, (boolean)deactivatedSet.contains(serverChannel));
        ChannelTest.assertEquals((boolean)true, (boolean)deactivatedSet.contains((Object)serverProtocol));
        List<TestSignalProtocol> list = this.protocols;
        synchronized (list) {
            ChannelTest.assertEquals((int)0, (int)this.protocols.size());
        }
    }

    public void testSingleThreadNoData100() throws Exception {
        this.disableConsole();
        int i = 0;
        while (i < 100) {
            IOUtil.OUT().println(String.valueOf(Thread.currentThread().getName()) + ": " + i);
            this.testSingleThreadNoData();
            ++i;
        }
    }

    public void testSingleThreadTinyData() throws Exception {
        TestSignalProtocol protocol = this.openTestSignalProtocol();
        ChannelTest.assertActive((Object)protocol);
        byte[] data = TinyData.getBytes();
        byte[] result = (byte[])new ArrayRequest(protocol, data).send();
        ChannelTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, result));
        protocol.close();
        ChannelTest.assertInactive((Object)protocol);
    }

    public void testSingleThreadTinyData100() throws Exception {
        this.disableConsole();
        int i = 0;
        while (i < 100) {
            IOUtil.OUT().println(String.valueOf(Thread.currentThread().getName()) + ": " + i);
            this.testSingleThreadTinyData();
            ++i;
        }
    }

    public void testMultiThreadNoData() throws Exception {
        MonitoredThread.MultiThreadMonitor threadMonitor = new MonitoredThread.MultiThreadMonitor(20000L);
        int i = 0;
        while (i < 40) {
            threadMonitor.addThread(new MonitoredThread("TEST-THREAD-" + i, (MonitoredThread.ThreadMonitor)threadMonitor){

                protected void doRun() throws Exception {
                    int i = 0;
                    while (i < 100) {
                        IOUtil.OUT().println(String.valueOf(Thread.currentThread().getName()) + ": " + i);
                        TestSignalProtocol protocol = ChannelTest.this.openTestSignalProtocol();
                        ChannelTest.assertActive((Object)protocol);
                        protocol.close();
                        ChannelTest.assertInactive((Object)protocol);
                        this.heartBeat();
                        ++i;
                    }
                }
            });
            ++i;
        }
        this.disableConsole();
        threadMonitor.run();
        this.enableConsole();
    }

    public void testMultiThreadTinyData() throws Exception {
        MonitoredThread.MultiThreadMonitor threadMonitor = new MonitoredThread.MultiThreadMonitor(20000L);
        int i = 0;
        while (i < 40) {
            threadMonitor.addThread(new MonitoredThread("TEST-THREAD-" + i, (MonitoredThread.ThreadMonitor)threadMonitor){

                protected void doRun() throws Exception {
                    int i = 0;
                    while (i < 100) {
                        IOUtil.OUT().println(String.valueOf(Thread.currentThread().getName()) + ": " + i);
                        TestSignalProtocol protocol = ChannelTest.this.openTestSignalProtocol();
                        ChannelTest.assertActive((Object)protocol);
                        this.heartBeat();
                        byte[] data = TinyData.getBytes();
                        byte[] result = (byte[])new ArrayRequest(protocol, data).send();
                        ChannelTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, result));
                        this.heartBeat();
                        protocol.close();
                        ChannelTest.assertInactive((Object)protocol);
                        this.heartBeat();
                        ++i;
                    }
                }
            });
            ++i;
        }
        this.disableConsole();
        threadMonitor.run();
        this.enableConsole();
    }

    public void testMultiThreadDataLoop() throws Exception {
        MonitoredThread.MultiThreadMonitor threadMonitor = new MonitoredThread.MultiThreadMonitor(20000L, 10L);
        int i = 0;
        while (i < 40) {
            threadMonitor.addThread(new MonitoredThread("TEST-THREAD-" + i, (MonitoredThread.ThreadMonitor)threadMonitor){

                protected void doRun() throws Exception {
                    int i = 0;
                    while (i < 10) {
                        long start = System.currentTimeMillis();
                        TestSignalProtocol protocol = ChannelTest.this.openTestSignalProtocol();
                        ChannelTest.assertActive((Object)protocol);
                        int j = 0;
                        while (j < 50) {
                            byte[] data = TinyData.getBytes();
                            byte[] result = (byte[])new ArrayRequest(protocol, data).send();
                            ChannelTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, result));
                            this.heartBeat();
                            ConcurrencyUtil.sleep((long)10L);
                            ++j;
                        }
                        protocol.close();
                        ChannelTest.assertInactive((Object)protocol);
                        long stop = System.currentTimeMillis();
                        IOUtil.OUT().println(String.valueOf(Thread.currentThread().getName()) + ": " + i + " (" + (stop - start) + ")");
                        ++i;
                    }
                }
            });
            ++i;
        }
        this.disableConsole();
        threadMonitor.run();
        this.enableConsole();
    }

    @Override
    protected abstract boolean useJVMTransport();

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.startTransport();
        this.getConnector().setOpenChannelTimeout(20000L);
        this.protocols = new ArrayList<TestSignalProtocol>();
    }

    @Override
    protected void doTearDown() throws Exception {
        for (TestSignalProtocol protocol : this.protocols) {
            protocol.close();
        }
        this.protocols = null;
        this.getConnector().close();
        super.doTearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestSignalProtocol openTestSignalProtocol() {
        final TestSignalProtocol protocol = new TestSignalProtocol(this.getConnector());
        List<TestSignalProtocol> list = this.protocols;
        synchronized (list) {
            this.protocols.add(protocol);
            protocol.getChannel().addListener((IListener)new LifecycleEventAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void onDeactivated(ILifecycle lifecycle) {
                    List list = ChannelTest.this.protocols;
                    synchronized (list) {
                        protocol.getChannel().removeListener((IListener)this);
                        boolean removed = ChannelTest.this.protocols.remove((Object)protocol);
                        ChannelTest.assertEquals((boolean)true, (boolean)removed);
                    }
                }
            });
        }
        return protocol;
    }

    private static class DeactivationListener
    extends LifecycleEventAdapter {
        private Set<ILifecycle> deactivatedSet = new HashSet<ILifecycle>();

        public Set<ILifecycle> getDeactivatedSet() {
            return this.deactivatedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onDeactivated(ILifecycle lifecycle) {
            Set<ILifecycle> set = this.deactivatedSet;
            synchronized (set) {
                this.deactivatedSet.add(lifecycle);
                this.deactivatedSet.notifyAll();
            }
        }
    }

    public static final class JVM
    extends ChannelTest {
        @Override
        protected boolean useJVMTransport() {
            return true;
        }

        @Override
        protected boolean useSSLTransport() {
            return false;
        }
    }

    public static final class SSL
    extends ChannelTest {
        @Override
        protected boolean useJVMTransport() {
            return false;
        }

        @Override
        protected boolean useSSLTransport() {
            return true;
        }
    }

    public static final class TCP
    extends ChannelTest {
        @Override
        protected boolean useJVMTransport() {
            return false;
        }

        @Override
        protected boolean useSSLTransport() {
            return false;
        }
    }
}

