/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.repositories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.cdo.explorer.CDOExplorerManager;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.repositories.CDORepositoryManager;
import org.eclipse.emf.cdo.explorer.ui.ViewerUtil;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.repositories.CDORepositoriesView;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class CDORepositoryItemProvider
extends ContainerItemProvider<IContainer<Object>>
implements ITableLabelProvider {
    public static final Image REPOSITORY_IMAGE = SharedIcons.getImage((String)"obj16/repo.gif");
    public static final Image BRANCH_IMAGE = SharedIcons.getImage((String)"obj16/branch.gif");
    private final Image imageRepoDisconnected = new Image((Device)UIUtil.getDisplay(), REPOSITORY_IMAGE, 2);
    private final Map<CDORepository, CDORepository> connectingRepositories = new ConcurrentHashMap<CDORepository, CDORepository>();
    private final IListener repositoryManagerListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof CDORepositoryManager.RepositoryConnectionEvent) {
                ContainerItemProvider.Node node;
                CDORepositoryManager.RepositoryConnectionEvent e = (CDORepositoryManager.RepositoryConnectionEvent)event;
                StructuredViewer viewer = CDORepositoryItemProvider.this.getViewer();
                CDORepository repository = e.getRepository();
                if (!e.isConnected() && (node = CDORepositoryItemProvider.this.getNode(repository)) != null) {
                    node.disposeChildren();
                    if (viewer instanceof TreeViewer) {
                        ViewerUtil.expand((TreeViewer)viewer, repository, false);
                    }
                }
                ViewerUtil.refresh(viewer, repository);
                this.updatePropertySheetPage(repository);
            } else if (event instanceof CDOExplorerManager.ElementsChangedEvent) {
                CDOExplorerManager.ElementsChangedEvent e = (CDOExplorerManager.ElementsChangedEvent)event;
                StructuredViewer viewer = CDORepositoryItemProvider.this.getViewer();
                Object[] changedElements = e.getChangedElements();
                ViewerUtil.update(viewer, changedElements);
                this.updatePropertySheetPage(changedElements);
            }
        }

        private void updatePropertySheetPage(final Object element) {
            if (CDORepositoryItemProvider.this.repositoriesView != null) {
                CDORepositoryItemProvider.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IStructuredSelection selection = (IStructuredSelection)CDORepositoryItemProvider.this.repositoriesView.getSelection();
                        Object[] objectArray = selection.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            if (object == element) {
                                CDORepositoryItemProvider.this.repositoriesView.refreshPropertySheetPage();
                                return;
                            }
                            ++n2;
                        }
                    }
                });
            }
        }
    };
    private final CDORepositoriesView repositoriesView;
    private boolean grayOutDisconnectedRepositories = true;

    public CDORepositoryItemProvider() {
        this(null);
        this.grayOutDisconnectedRepositories = false;
    }

    public CDORepositoryItemProvider(CDORepositoriesView repositoriesView) {
        this.repositoriesView = repositoriesView;
    }

    public void dispose() {
        this.imageRepoDisconnected.dispose();
        super.dispose();
    }

    public void connectRepository(CDORepository repository) {
        this.connectingRepositories.put(repository, repository);
        StructuredViewer viewer = this.getViewer();
        ViewerUtil.refresh(viewer, repository);
        if (viewer instanceof TreeViewer) {
            ViewerUtil.expand((TreeViewer)viewer, repository, true);
        }
    }

    public boolean hasChildren(Object element) {
        CDORepository repository;
        if (element instanceof CDORepository && !(repository = (CDORepository)element).isConnected()) {
            return this.connectingRepositories.containsKey(repository);
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object element) {
        Object[] children;
        if (element instanceof CDORepository) {
            CDORepository repository = (CDORepository)element;
            if (!repository.isConnected() && !this.connectingRepositories.containsKey(repository)) {
                return ViewerUtil.NO_CHILDREN;
            }
        } else if (element instanceof CDORepositoryManager) {
            Object[] children2;
            ArrayList<CDORepository> repositories = new ArrayList<CDORepository>();
            Object[] objectArray = children2 = super.getChildren(element);
            int n = children2.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof CDORepository) {
                    repositories.add((CDORepository)child);
                }
                ++n2;
            }
            Collections.sort(repositories);
            return repositories.toArray();
        }
        ArrayList<CDOTimeProvider> timeProviders = new ArrayList<CDOTimeProvider>();
        ArrayList<Object> otherObjects = new ArrayList<Object>();
        Object[] objectArray = children = super.getChildren(element);
        int n = children.length;
        int n3 = 0;
        while (n3 < n) {
            Object child = objectArray[n3];
            if (child instanceof CDOTimeProvider) {
                timeProviders.add((CDOTimeProvider)child);
            } else {
                otherObjects.add(child);
            }
            ++n3;
        }
        Collections.sort(timeProviders, CDOCommonUtil.TIME_COMPARATOR);
        otherObjects.addAll(0, timeProviders);
        return otherObjects.toArray();
    }

    protected Object[] getContainerChildren(ContainerItemProvider.AbstractContainerNode containerNode, IContainer<?> container) {
        CDORepository repository;
        if (container instanceof CDORepository && this.connectingRepositories.remove(repository = (CDORepository)container) != null) {
            try {
                repository.connect();
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                containerNode.disposeChildren();
                repository.disconnect();
                UIUtil.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MessageDialog.openError((Shell)CDORepositoryItemProvider.this.getViewer().getControl().getShell(), (String)"Connection Error", (String)ex.getMessage());
                        }
                        catch (Exception ex2) {
                            OM.LOG.error((Throwable)ex2);
                        }
                    }
                });
            }
        }
        return super.getContainerChildren(containerNode, container);
    }

    public String getText(Object element) {
        if (element instanceof CDORepository) {
            CDORepository repository = (CDORepository)element;
            return repository.getLabel();
        }
        if (element instanceof CDOBranch) {
            CDOBranch branch = (CDOBranch)element;
            return branch.getName();
        }
        return super.getText(element);
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getText(element);
            }
            case 1: {
                if (!(element instanceof CDORepository)) break;
                CDORepository repository = (CDORepository)element;
                CDORepository.VersioningMode versioningMode = repository.getVersioningMode();
                return versioningMode == null ? "Unknown" : versioningMode.toString();
            }
            case 2: {
                if (!(element instanceof CDORepository)) break;
                CDORepository repository = (CDORepository)element;
                CDORepository.IDGeneration idGeneration = repository.getIDGeneration();
                return idGeneration == null ? "Unknown" : idGeneration.toString();
            }
        }
        return "";
    }

    public Image getImage(Object obj) {
        if (obj instanceof CDORepository) {
            CDORepository repository = (CDORepository)obj;
            if (!repository.isConnected() && this.grayOutDisconnectedRepositories) {
                return this.imageRepoDisconnected;
            }
            return REPOSITORY_IMAGE;
        }
        if (obj instanceof CDOBranch) {
            return BRANCH_IMAGE;
        }
        return super.getImage(obj);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    protected boolean isSlow(IContainer<Object> container) {
        return true;
    }

    protected String getSlowText(IContainer<Object> container) {
        if (container instanceof CDORepository) {
            return "Connecting...";
        }
        return "Loading...";
    }

    protected void connectInput(IContainer<Object> input) {
        super.connectInput(input);
        input.addListener(this.repositoryManagerListener);
    }

    protected void disconnectInput(IContainer<Object> input) {
        input.removeListener(this.repositoryManagerListener);
        super.disconnectInput(input);
    }
}

