/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.tests.AbstractCDOTest;
import org.eclipse.emf.cdo.tests.config.impl.ConfigTest;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.spi.db.DBAdapter;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.ExtendedIOUtil;
import org.eclipse.net4j.util.io.IOUtil;

public class Net4jDBTest
extends AbstractCDOTest {
    private static final String FIELD_NAME = "testField";
    private transient ArrayList<Pair<DBType, Object>> columns = new ArrayList();

    protected void doTearDown() throws Exception {
        this.columns.clear();
        super.doTearDown();
    }

    public void testBigInt() throws Exception {
        this.registerColumn(DBType.BIGINT, Long.MAX_VALUE);
        this.registerColumn(DBType.BIGINT, Long.MIN_VALUE);
        this.registerColumn(DBType.BIGINT, 0L);
        this.registerColumn(DBType.BIGINT, 42L);
        this.doTest(this.getName());
    }

    public void testBinary() throws Exception {
        if (!this.isDB("oracle", "mysql")) {
            this.registerColumn(DBType.BINARY, new byte[0]);
        }
        if (!this.isDB("mysql")) {
            byte[] data = new byte[100];
            int i = 0;
            while (i < data.length) {
                data[i] = (byte)(Math.random() * 255.0 + -128.0);
                ++i;
            }
            this.registerColumn(DBType.BINARY, data);
        }
        this.doTest(this.getName());
    }

    public void testVarBinary() throws Exception {
        if (!this.isDB("oracle")) {
            this.registerColumn(DBType.VARBINARY, new byte[0]);
        }
        byte[] data = new byte[100];
        int i = 0;
        while (i < data.length) {
            data[i] = (byte)(Math.random() * 255.0 + -128.0);
            ++i;
        }
        this.registerColumn(DBType.VARBINARY, data);
        this.doTest(this.getName());
    }

    public void testLongVarBinary() throws Exception {
        if (!this.isDB("oracle")) {
            this.registerColumn(DBType.LONGVARBINARY, new byte[0]);
        }
        byte[] data = new byte[100];
        int i = 0;
        while (i < data.length) {
            data[i] = (byte)(Math.random() * 255.0 + -128.0);
            ++i;
        }
        this.registerColumn(DBType.LONGVARBINARY, data);
        this.doTest(this.getName());
    }

    public void testBit() throws Exception {
        this.registerColumn(DBType.BIT, true);
        this.registerColumn(DBType.BIT, false);
        this.doTest(this.getName());
    }

    public void testBlob() throws Exception {
        byte[] data = new byte[1000000];
        int i = 0;
        while (i < data.length) {
            data[i] = (byte)(Math.random() * 255.0 + -128.0);
            ++i;
        }
        this.registerColumn(DBType.BLOB, data);
        this.doTest(this.getName());
    }

    @ConfigTest.Skips(value={"oracle"})
    public void testBlobLength0() throws Exception {
        this.registerColumn(DBType.BLOB, new byte[0]);
        this.doTest(this.getName());
    }

    public void testBoolean() throws Exception {
        this.registerColumn(DBType.BOOLEAN, true);
        this.registerColumn(DBType.BOOLEAN, false);
        this.doTest(this.getName());
    }

    public void testChar() throws Exception {
        this.registerColumn(DBType.CHAR, "0");
        this.registerColumn(DBType.CHAR, "a");
        if (!this.isDB("db2")) {
            this.registerColumn(DBType.CHAR, "\u00ff");
        }
        if (!this.isDB("db2", "mysql")) {
            this.registerColumn(DBType.CHAR, "\u1234");
        }
        this.doTest(this.getName());
    }

    public void testClob() throws Exception {
        this.registerColumn(DBType.CLOB, "Test");
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < 1000000) {
            b.append("x");
            ++i;
        }
        this.registerColumn(DBType.CLOB, b.toString());
        this.doTest(this.getName());
    }

    public void testClobLength0() throws Exception {
        this.registerColumn(DBType.CLOB, "");
        this.doTest(this.getName());
    }

    public void testTinyInt() throws Exception {
        this.registerColumn(DBType.TINYINT, (byte)127);
        this.registerColumn(DBType.TINYINT, (byte)-128);
        this.registerColumn(DBType.TINYINT, new Byte("0"));
        this.registerColumn(DBType.TINYINT, new Integer(42).byteValue());
        this.doTest(this.getName());
    }

    public void testSmallInt() throws Exception {
        this.registerColumn(DBType.SMALLINT, (short)Short.MAX_VALUE);
        this.registerColumn(DBType.SMALLINT, (short)Short.MIN_VALUE);
        this.registerColumn(DBType.SMALLINT, (short)-1);
        this.registerColumn(DBType.SMALLINT, (short)5);
        this.doTest(this.getName());
    }

    public void testInteger() throws Exception {
        this.registerColumn(DBType.INTEGER, Integer.MAX_VALUE);
        this.registerColumn(DBType.INTEGER, Integer.MIN_VALUE);
        this.registerColumn(DBType.INTEGER, -1);
        this.registerColumn(DBType.INTEGER, 5);
        this.doTest(this.getName());
    }

    public void testFloat() throws Exception {
        if (!this.isDB("mysql")) {
            this.registerColumn(DBType.FLOAT, Float.valueOf(Float.MAX_VALUE));
        }
        if (!this.isDB("db2")) {
            this.registerColumn(DBType.FLOAT, Float.valueOf(Float.MIN_VALUE));
        }
        this.registerColumn(DBType.FLOAT, Float.valueOf(-0.1f));
        this.registerColumn(DBType.FLOAT, Float.valueOf(3.33333f));
        this.doTest(this.getName());
    }

    public void testReal() throws Exception {
        this.registerColumn(DBType.REAL, Float.valueOf(Float.MAX_VALUE));
        if (!this.isDB("db2")) {
            this.registerColumn(DBType.REAL, Float.valueOf(Float.MIN_VALUE));
        }
        this.registerColumn(DBType.REAL, Float.valueOf(-0.1f));
        this.registerColumn(DBType.REAL, Float.valueOf(3.33333f));
        this.doTest(this.getName());
    }

    public void testDouble() throws Exception {
        if (!this.isDB("oracle")) {
            this.registerColumn(DBType.DOUBLE, new Double(Double.MAX_VALUE));
        }
        this.registerColumn(DBType.DOUBLE, -0.1);
        this.registerColumn(DBType.DOUBLE, 3.33333);
        this.doTest(this.getName());
    }

    public void _testNumeric() throws Exception {
        String numberLiteral1 = "12345678901234567890123456789012";
        String numberLiteral2 = "10000000000000000000000000000000";
        int precision = 1;
        while (precision < 32) {
            BigInteger numberInteger1 = new BigInteger(numberLiteral1.substring(0, precision));
            BigInteger numberInteger2 = new BigInteger(numberLiteral2.substring(0, precision));
            int scale = 0;
            while (scale <= precision) {
                BigDecimal numberDecimal1 = new BigDecimal(numberInteger1, scale);
                BigDecimal numberDecimal2 = new BigDecimal(numberInteger2, scale);
                this.registerColumn(DBType.NUMERIC, numberDecimal1);
                this.registerColumn(DBType.NUMERIC, numberDecimal2);
                this.doTest(String.valueOf(this.getName()) + precision + "_" + scale);
                this.columns.clear();
                ++scale;
            }
            ++precision;
        }
    }

    public void _testDecimal() throws Exception {
        String numberLiteral1 = "12345678901234567890123456789012";
        String numberLiteral2 = "10000000000000000000000000000000";
        int precision = 1;
        while (precision < 32) {
            BigInteger numberInteger1 = new BigInteger(numberLiteral1.substring(0, precision));
            BigInteger numberInteger2 = new BigInteger(numberLiteral2.substring(0, precision));
            int scale = 0;
            while (scale <= precision) {
                BigDecimal numberDecimal1 = new BigDecimal(numberInteger1, scale);
                BigDecimal numberDecimal2 = new BigDecimal(numberInteger2, scale);
                this.registerColumn(DBType.DECIMAL, numberDecimal1);
                this.registerColumn(DBType.DECIMAL, numberDecimal2);
                this.doTest(String.valueOf(this.getName()) + precision + "_" + scale);
                this.columns.clear();
                ++scale;
            }
            ++precision;
        }
    }

    public void testVarChar() throws Exception {
        this.registerColumn(DBType.VARCHAR, "");
        this.doTest(this.getName());
    }

    public void testLongVarChar() throws Exception {
        this.registerColumn(DBType.LONGVARCHAR, "");
        if (!this.isDB("oracle")) {
            this.registerColumn(DBType.LONGVARCHAR, "\n");
            this.registerColumn(DBType.LONGVARCHAR, "\t");
            this.registerColumn(DBType.LONGVARCHAR, "\r");
            if (!this.isDB("mysql")) {
                this.registerColumn(DBType.LONGVARCHAR, "\u1234");
            }
            this.registerColumn(DBType.LONGVARCHAR, "The quick brown fox jumps over the lazy dog.");
            this.registerColumn(DBType.LONGVARCHAR, "\\,:\",'");
        }
        this.doTest(this.getName());
    }

    public void testDate() throws Exception {
        this.registerColumn(DBType.DATE, new GregorianCalendar(2010, 4, 21).getTimeInMillis());
        this.registerColumn(DBType.DATE, new GregorianCalendar(1950, 4, 21).getTimeInMillis());
        this.registerColumn(DBType.DATE, new GregorianCalendar(2030, 12, 31).getTimeInMillis());
        if (!this.isDB("oracle", "db2", "mysql")) {
            this.registerColumn(DBType.DATE, new GregorianCalendar(0, 0, 0).getTimeInMillis());
        }
        this.doTest(this.getName());
    }

    public void testTime() throws Exception {
        this.registerColumn(DBType.TIME, this.HOURS_toMillis(10));
        this.registerColumn(DBType.TIME, 0L);
        this.registerColumn(DBType.TIME, this.HOURS_toMillis(11) + this.MINUTES_toMillis(59) + TimeUnit.SECONDS.toMillis(59L));
        this.registerColumn(DBType.TIME, this.HOURS_toMillis(24));
        this.doTest(this.getName());
    }

    public void testTimestamp() throws Exception {
        this.registerColumn(DBType.TIME, this.HOURS_toMillis(10));
        this.registerColumn(DBType.TIME, 0L);
        this.registerColumn(DBType.TIME, this.HOURS_toMillis(11) + this.MINUTES_toMillis(59) + TimeUnit.SECONDS.toMillis(59L));
        this.registerColumn(DBType.TIME, this.HOURS_toMillis(24));
        this.doTest(this.getName());
    }

    private void registerColumn(DBType type, Object value) throws IOException {
        this.testIOSymmetry(type, value);
        Pair column = Pair.create((Object)type, (Object)value);
        this.columns.add((Pair<DBType, Object>)column);
    }

    private void testIOSymmetry(DBType type, Object value) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExtendedDataOutputStream outs = new ExtendedDataOutputStream((OutputStream)output);
        this.writeTypeValue(outs, type, value);
        outs.close();
        output.flush();
        byte[] buffer = output.toByteArray();
        output.close();
        ByteArrayInputStream input = new ByteArrayInputStream(buffer);
        ExtendedDataInputStream ins = new ExtendedDataInputStream((InputStream)input);
        Object actualValue = this.readTypeValue(ins, type);
        this.assertEquals(value, actualValue, type, -1);
    }

    private void prepareTable(DBStore store, final String tableName) {
        IDBDatabase database = store.getDatabase();
        database.updateSchema(new IDBDatabase.RunnableWithSchema(){

            public void run(IDBSchema schema) {
                IDBTable table = schema.addTable(tableName);
                int c = 0;
                for (Pair column : Net4jDBTest.this.columns) {
                    switch ((DBType)column.getElement1()) {
                        case NUMERIC: 
                        case DECIMAL: {
                            BigDecimal value = (BigDecimal)column.getElement2();
                            table.addField(Net4jDBTest.FIELD_NAME + c++, (DBType)column.getElement1(), value.precision(), value.scale());
                            break;
                        }
                        case BINARY: {
                            table.addField(Net4jDBTest.FIELD_NAME + c++, (DBType)column.getElement1(), 200);
                            break;
                        }
                        default: {
                            table.addField(Net4jDBTest.FIELD_NAME + c++, (DBType)column.getElement1());
                        }
                    }
                }
            }
        });
    }

    private void writeValues(Connection connection, String tableName) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExtendedDataOutputStream outs = new ExtendedDataOutputStream((OutputStream)output);
        boolean first = true;
        StringBuilder builder = new StringBuilder("INSERT INTO " + tableName + " VALUES (");
        for (Pair<DBType, Object> column : this.columns) {
            Object value = column.getElement2();
            if (value instanceof String) {
                String str = (String)value;
                DBStore store = (DBStore)this.getRepository().getStore();
                IDBDatabase database = store.getDatabase();
                DBAdapter adapter = (DBAdapter)database.getAdapter();
                value = adapter.convertString(null, 0, str);
            }
            this.writeTypeValue(outs, (DBType)column.getElement1(), value);
            if (first) {
                builder.append("?");
                first = false;
                continue;
            }
            builder.append(", ?");
        }
        builder.append(")");
        String sql = builder.toString();
        outs.close();
        output.flush();
        byte[] buffer = output.toByteArray();
        output.close();
        ByteArrayInputStream input = new ByteArrayInputStream(buffer);
        ExtendedDataInputStream ins = new ExtendedDataInputStream((InputStream)input);
        PreparedStatement stmt = connection.prepareStatement(sql);
        int c = 1;
        for (Pair<DBType, Object> column : this.columns) {
            ((DBType)column.getElement1()).readValueWithResult((ExtendedDataInput)ins, stmt, c++, false);
        }
        stmt.executeUpdate();
        stmt.close();
        ins.close();
        input.close();
    }

    private void checkValues(Connection connection, String tableName) throws Exception {
        Statement stmt = connection.createStatement();
        ResultSet resultSet = stmt.executeQuery("SELECT * FROM " + tableName);
        Net4jDBTest.assertEquals((boolean)true, (boolean)resultSet.next());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExtendedDataOutputStream outs = new ExtendedDataOutputStream((OutputStream)output);
        int c = 1;
        for (Pair<DBType, Object> column : this.columns) {
            DBType dbType = (DBType)column.getElement1();
            dbType.writeValue((ExtendedDataOutput)outs, resultSet, c++, false);
        }
        resultSet.close();
        stmt.close();
        outs.close();
        output.flush();
        byte[] buffer = output.toByteArray();
        output.close();
        ByteArrayInputStream input = new ByteArrayInputStream(buffer);
        ExtendedDataInputStream ins = new ExtendedDataInputStream((InputStream)input);
        c = 1;
        for (Pair<DBType, Object> column : this.columns) {
            DBType dbType = (DBType)column.getElement1();
            Object expected = column.getElement2();
            Object actual = this.readTypeValue(ins, dbType);
            this.assertEquals(expected, actual, dbType, c++);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assertEquals(Object expected, Object actual, DBType dbType, int c) {
        if (expected == null || actual == null) {
            Net4jDBTest.assertEquals((String)("Error in column " + c + " with type " + dbType), (Object)expected, (Object)actual);
            return;
        }
        Class<?> type = expected.getClass();
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (componentType == Byte.TYPE) {
                Net4jDBTest.assertEquals((String)("Error in column " + c + " of type " + dbType), (boolean)true, (boolean)Arrays.equals((byte[])expected, (byte[])actual));
                return;
            } else {
                if (componentType != Character.TYPE) throw new IllegalStateException("Unexpected component type: " + componentType);
                Net4jDBTest.assertEquals((String)("Error in column " + c + " with type " + dbType), (boolean)true, (boolean)Arrays.equals((char[])expected, (char[])actual));
            }
            return;
        } else {
            if (dbType == DBType.TIME) {
                actual = (Long)actual % 86400000L;
                expected = (Long)expected % 86400000L;
            }
            Net4jDBTest.assertEquals((String)("Error in column " + c + " with type " + dbType), (Object)expected, (Object)actual);
        }
    }

    private void doTest(String tableName) throws Exception {
        if (this.columns.isEmpty()) {
            return;
        }
        DBStore store = (DBStore)this.getRepository().getStore();
        Connection connection = store.getConnection();
        try {
            this.prepareTable(store, tableName);
            this.writeValues(connection, tableName);
            this.checkValues(connection, tableName);
        }
        finally {
            try {
                connection.commit();
            }
            finally {
                DBUtil.close((Connection)connection);
                connection = null;
                store = null;
            }
        }
    }

    private void writeTypeValue(ExtendedDataOutputStream outs, DBType type, Object value) throws IOException {
        switch (type) {
            case BOOLEAN: 
            case BIT: {
                outs.writeBoolean(((Boolean)value).booleanValue());
                return;
            }
            case TINYINT: {
                outs.writeByte((int)((Byte)value).byteValue());
                return;
            }
            case CHAR: {
                outs.writeString((String)value);
                return;
            }
            case SMALLINT: {
                outs.writeShort((int)((Short)value).shortValue());
                return;
            }
            case INTEGER: {
                outs.writeInt(((Integer)value).intValue());
                return;
            }
            case FLOAT: {
                outs.writeFloat(((Float)value).floatValue());
                return;
            }
            case REAL: {
                outs.writeFloat(((Float)value).floatValue());
                return;
            }
            case DOUBLE: {
                outs.writeDouble(((Double)value).doubleValue());
                return;
            }
            case NUMERIC: 
            case DECIMAL: {
                BigDecimal bigDecimal = (BigDecimal)value;
                outs.writeByteArray(bigDecimal.unscaledValue().toByteArray());
                outs.writeInt(bigDecimal.scale());
                return;
            }
            case VARCHAR: 
            case LONGVARCHAR: {
                outs.writeString((String)value);
                return;
            }
            case CLOB: {
                ExtendedIOUtil.writeCharacterStream((DataOutput)outs, (Reader)new StringReader((String)value));
                return;
            }
            case BIGINT: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                outs.writeLong(((Long)value).longValue());
                return;
            }
            case BINARY: 
            case VARBINARY: 
            case LONGVARBINARY: {
                outs.writeByteArray((byte[])value);
                return;
            }
            case BLOB: {
                ExtendedIOUtil.writeBinaryStream((DataOutput)outs, (InputStream)new ByteArrayInputStream((byte[])value));
                return;
            }
        }
        throw new UnsupportedOperationException("not implemented");
    }

    private Object readTypeValue(ExtendedDataInputStream ins, DBType type) throws IOException {
        switch (type) {
            case BOOLEAN: 
            case BIT: {
                return ins.readBoolean();
            }
            case CHAR: {
                return ins.readString();
            }
            case TINYINT: {
                return ins.readByte();
            }
            case SMALLINT: {
                return ins.readShort();
            }
            case INTEGER: {
                return ins.readInt();
            }
            case FLOAT: 
            case REAL: {
                return Float.valueOf(ins.readFloat());
            }
            case DOUBLE: {
                return ins.readDouble();
            }
            case NUMERIC: 
            case DECIMAL: {
                byte[] array = ins.readByteArray();
                if (array == null) {
                    return null;
                }
                BigInteger unscaled = new BigInteger(array);
                int scale = ins.readInt();
                return new BigDecimal(unscaled, scale);
            }
            case VARCHAR: 
            case LONGVARCHAR: {
                DBStore store = (DBStore)this.getRepository().getStore();
                IDBDatabase database = store.getDatabase();
                DBAdapter adapter = (DBAdapter)database.getAdapter();
                return adapter.convertString(null, 0, ins.readString());
            }
            case CLOB: {
                StringWriter result = new StringWriter();
                try {
                    ExtendedIOUtil.readCharacterStream((DataInput)ins, (Writer)result);
                }
                finally {
                    IOUtil.close((Closeable)result);
                }
                return result.toString();
            }
            case BIGINT: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return ins.readLong();
            }
            case BINARY: 
            case VARBINARY: 
            case LONGVARBINARY: {
                return ins.readByteArray();
            }
            case BLOB: {
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                try {
                    ExtendedIOUtil.readBinaryStream((DataInput)ins, (OutputStream)result);
                }
                finally {
                    IOUtil.close((Closeable)result);
                }
                return result.toByteArray();
            }
        }
        throw new UnsupportedOperationException("not implemented");
    }

    private long HOURS_toMillis(int hours) {
        return this.MINUTES_toMillis(60 * hours);
    }

    private long MINUTES_toMillis(int minutes) {
        return 60000L * (long)minutes;
    }

    private boolean isDB(String ... dbs) {
        String[] stringArray = dbs;
        int n = dbs.length;
        int n2 = 0;
        while (n2 < n) {
            String db = stringArray[n2];
            if (db.equalsIgnoreCase(((IDBStore)this.getRepository().getStore()).getDBAdapter().getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

