/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.common;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.ICollaboration;
import org.eclipse.net4j.buddies.common.IMembership;
import org.eclipse.net4j.buddies.common.IMembershipContainer;
import org.eclipse.net4j.buddies.common.IMembershipKey;
import org.eclipse.net4j.buddies.internal.common.MembershipKey;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public class MembershipContainer
extends Lifecycle
implements IMembershipContainer,
IListener {
    private ConcurrentMap<IMembershipKey, IMembership> memberships = new ConcurrentHashMap<IMembershipKey, IMembership>();

    public void addMembership(IMembership membership) {
        if (this.memberships.putIfAbsent(membership, membership) == null) {
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent((IEvent)new SingleDeltaContainerEvent((IContainer)this, (Object)membership, IContainerDelta.Kind.ADDED), listeners);
            }
            membership.addListener(this);
        }
    }

    public IMembership removeMembership(IBuddy buddy, ICollaboration collaboration) {
        return this.removeMembership(new MembershipKey(buddy, collaboration));
    }

    public IMembership removeMembership(IMembershipKey key) {
        IMembership membership = (IMembership)this.memberships.remove(key);
        if (membership != null) {
            membership.removeListener(this);
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent((IEvent)new SingleDeltaContainerEvent((IContainer)this, (Object)membership, IContainerDelta.Kind.REMOVED), listeners);
            }
        }
        return membership;
    }

    @Override
    public IMembership[] getMemberships() {
        return this.memberships.values().toArray(new IMembership[this.memberships.size()]);
    }

    @Override
    public IMembership getMembership(IBuddy buddy, ICollaboration collaboration) {
        return (IMembership)this.memberships.get(new MembershipKey(buddy, collaboration));
    }

    public IMembership[] getElements() {
        return this.getMemberships();
    }

    public boolean isEmpty() {
        return this.memberships.isEmpty();
    }

    public void notifyEvent(IEvent event) {
        if (event.getSource() instanceof IMembership) {
            ILifecycleEvent e;
            IMembership membership = (IMembership)event.getSource();
            this.notifyMembershipEvent(event);
            if (event instanceof ILifecycleEvent && (e = (ILifecycleEvent)event).getKind() == ILifecycleEvent.Kind.DEACTIVATED) {
                this.removeMembership(membership);
            }
        }
    }

    protected void notifyMembershipEvent(IEvent event) {
    }

    protected void doDeactivate() throws Exception {
        IMembership[] iMembershipArray = this.getMemberships();
        int n = iMembershipArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMembership membership = iMembershipArray[n2];
            membership.removeListener(this);
            ++n2;
        }
        super.doDeactivate();
    }
}

