/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.http.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.http.HTTPUtil;
import org.eclipse.net4j.internal.http.HTTPClientConnector;
import org.eclipse.net4j.tests.config.AbstractConfigTest;
import org.eclipse.net4j.tests.signal.IntRequest;
import org.eclipse.net4j.tests.signal.TestSignalProtocol;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;

public class HTTPTest
extends AbstractConfigTest {
    protected IManagedContainer createContainer() {
        IManagedContainer container = super.createContainer();
        HTTPUtil.prepareContainer((IManagedContainer)container);
        return container;
    }

    public void _testRequestFlush() throws Exception {
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod("http://eike@localhost:8080/net4j/echotest");
        method.setRequestEntity(new RequestEntity(){

            public long getContentLength() {
                return -1L;
            }

            public String getContentType() {
                return "application/octet-stream";
            }

            public boolean isRepeatable() {
                return false;
            }

            public void writeRequest(OutputStream out) throws IOException {
                int count = 10;
                out.write(count);
                int i = 0;
                while (i < count) {
                    this.send(out, i);
                    ++i;
                }
            }

            private void send(OutputStream out, int b) throws IOException {
                try {
                    HTTPTest.msg((Object)("Writing " + b));
                    out.write(b);
                    out.flush();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
        });
        client.executeMethod((HttpMethod)method);
        InputStream responseBody = method.getResponseBodyAsStream();
        ExtendedDataInputStream in = new ExtendedDataInputStream(responseBody);
        int count = in.readInt();
        int i = 0;
        while (i < count) {
            byte b = in.readByte();
            HTTPTest.assertEquals((int)i, (int)b);
            long gap = in.readLong();
            HTTPTest.msg((Object)("Gap: " + gap));
            ++i;
        }
        method.releaseConnection();
    }

    public void test1() throws Exception {
        HTTPClientConnector connector = this.getHTTPConnector();
        TestSignalProtocol protocol = new TestSignalProtocol((IConnector)connector);
        IntRequest request = new IntRequest(protocol, 305419896);
        int result = (Integer)request.send();
        HTTPTest.assertEquals((int)305419896, (int)result);
        HTTPTest.sleep((long)500L);
        protocol.close();
        HTTPTest.sleep((long)500L);
        connector.deactivate();
    }

    private HTTPClientConnector getHTTPConnector() {
        return (HTTPClientConnector)Net4jUtil.getConnector((IManagedContainer)this.acceptorContainer, (String)"http", (String)"http://localhost:8080/net4j");
    }
}

