/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.server;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.examples.internal.server.OM;
import org.eclipse.emf.cdo.examples.server.DemoConfiguration;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.EclipseLoggingBridge;
import org.eclipse.net4j.util.om.log.OMLogHandler;

public class DemoServer
extends Lifecycle {
    public static final String PROP_BROWSER_PORT = "org.eclipse.emf.cdo.examples.server.browser.port";
    public static final int PORT = 3003;
    public static final int MAX_IDLE_MINUTES = 15;
    public static final long MAX_IDLE_MILLIS = 900000L;
    public static final DemoServer INSTANCE = new DemoServer();
    private IAcceptor acceptor;
    private Map<String, DemoConfiguration> configs = new HashMap<String, DemoConfiguration>();
    private Cleaner cleaner = new Cleaner();

    private DemoServer() {
    }

    public IAcceptor getAcceptor() {
        return this.acceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DemoConfiguration[] getConfigs() {
        Map<String, DemoConfiguration> map = this.configs;
        synchronized (map) {
            return this.configs.values().toArray(new DemoConfiguration[this.configs.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DemoConfiguration getConfig(String name) {
        Map<String, DemoConfiguration> map = this.configs;
        synchronized (map) {
            return this.configs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DemoConfiguration addConfig(DemoConfiguration.Mode mode) {
        DemoConfiguration config = new DemoConfiguration(mode, null);
        config.activate();
        Map<String, DemoConfiguration> map = this.configs;
        synchronized (map) {
            this.configs.put(config.getName(), config);
        }
        return config;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        OMPlatform.INSTANCE.removeLogHandler((OMLogHandler)EclipseLoggingBridge.INSTANCE);
        OM.LOG.info("Demo server starting");
        IPluginContainer container = IPluginContainer.INSTANCE;
        this.acceptor = TCPUtil.getAcceptor((IManagedContainer)container, (String)"0.0.0.0:3003");
        String port = OMPlatform.INSTANCE.getProperty(PROP_BROWSER_PORT);
        if (port != null) {
            container.getElement("org.eclipse.emf.cdo.server.db.browsers", "default", port);
        }
        this.cleaner.activate();
        OM.LOG.info("Demo server started");
    }

    protected void doDeactivate() throws Exception {
        OM.LOG.info("Demo server stopping");
        this.cleaner.deactivate();
        DemoConfiguration[] demoConfigurationArray = this.getConfigs();
        int n = demoConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            DemoConfiguration config = demoConfigurationArray[n2];
            config.deactivate();
            ++n2;
        }
        this.configs.clear();
        if (this.acceptor != null) {
            LifecycleUtil.deactivate((Object)this.acceptor);
            this.acceptor = null;
        }
        OM.LOG.info("Demo server stopped");
        super.doDeactivate();
    }

    private final class Cleaner
    extends Worker {
        private Cleaner() {
        }

        protected String getThreadName() {
            return "DemoServerCleaner";
        }

        protected void work(Worker.WorkContext context) throws Exception {
            DemoConfiguration[] demoConfigurationArray = DemoServer.this.getConfigs();
            int n = demoConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                DemoConfiguration config = demoConfigurationArray[n2];
                this.cleanIfNeeded(config);
                ++n2;
            }
            context.nextWork(2000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cleanIfNeeded(DemoConfiguration config) {
            if (config.getTimeoutMillis() == 0L) {
                Map map = DemoServer.this.configs;
                synchronized (map) {
                    DemoServer.this.configs.remove(config.getName());
                }
                config.deactivate();
            }
        }
    }
}

