/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.bundle;

import java.io.File;
import java.util.Map;
import org.eclipse.emf.cdo.internal.explorer.CDOExplorerURIHandler;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutManagerImpl;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryManagerImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.OSGiActivator;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.OMTracer;

public abstract class OM {
    public static final String BUNDLE_ID = "org.eclipse.emf.cdo.explorer";
    public static final OMBundle BUNDLE = OMPlatform.INSTANCE.bundle("org.eclipse.emf.cdo.explorer", OM.class);
    public static final OMTracer DEBUG = BUNDLE.tracer("debug");
    public static final OMLogger LOG = BUNDLE.logger();
    private static final String STATE_LOCATION = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.explorer.stateLocation");
    private static final boolean OMIT_CHECKOUT_FILE_URI_HANDLERS = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.explorer.omitCheckoutFileURIHandlers");
    private static String stateLocation;
    private static CDORepositoryManagerImpl repositoryManager;
    private static CDOCheckoutManagerImpl checkoutManager;

    public static String getStateLocation() {
        return stateLocation;
    }

    public static void initializeManagers(File stateLocation) {
        Exception exception;
        OM.disposeManagers();
        if (repositoryManager == null && (exception = LifecycleUtil.activateSilent((Object)(repositoryManager = new CDORepositoryManagerImpl(new File(stateLocation, "rp"))))) != null) {
            LOG.error((Throwable)exception);
        }
        if (checkoutManager == null && (exception = LifecycleUtil.activateSilent((Object)(checkoutManager = new CDOCheckoutManagerImpl(new File(stateLocation, "co"))))) != null) {
            LOG.error((Throwable)exception);
        }
    }

    public static void disposeManagers() {
        Exception exception;
        if (checkoutManager != null) {
            exception = LifecycleUtil.deactivate((Object)checkoutManager);
            if (exception != null) {
                LOG.error((Throwable)exception);
            }
            checkoutManager = null;
        }
        if (repositoryManager != null) {
            exception = LifecycleUtil.deactivate((Object)repositoryManager);
            if (exception != null) {
                LOG.error((Throwable)exception);
            }
            repositoryManager = null;
        }
    }

    public static CDORepositoryManagerImpl getRepositoryManager() {
        return repositoryManager;
    }

    public static CDOCheckoutManagerImpl getCheckoutManager() {
        return checkoutManager;
    }

    public static final class Activator
    extends OSGiActivator {
        private static final Resource.Factory TEXT_RESOURCE_FACTORY = new XMIResourceFactoryImpl(){

            public Resource createResource(URI uri) {
                return new XMIResourceImpl(uri){
                    private URIConverter uriConverter;

                    protected URIConverter getURIConverter() {
                        if (this.uriConverter == null) {
                            this.uriConverter = super.getURIConverter();
                            this.uriConverter.getURIHandlers().add(0, CDOExplorerURIHandler.TEXT);
                        }
                        return this.uriConverter;
                    }
                };
            }
        };
        private static final Resource.Factory BINARY_RESOURCE_FACTORY = new ResourceFactoryImpl(){

            public Resource createResource(URI uri) {
                return new BinaryResourceImpl(uri){
                    private URIConverter uriConverter;

                    protected URIConverter getURIConverter() {
                        if (this.uriConverter == null) {
                            this.uriConverter = super.getURIConverter();
                            this.uriConverter.getURIHandlers().add(0, CDOExplorerURIHandler.TEXT);
                        }
                        return this.uriConverter;
                    }
                };
            }
        };

        public Activator() {
            super(BUNDLE);
        }

        protected void doStart() throws Exception {
            super.doStart();
            if (!OMIT_CHECKOUT_FILE_URI_HANDLERS) {
                Map factoryMap = Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap();
                factoryMap.put(CDOExplorerURIHandler.TEXT.getScheme(), TEXT_RESOURCE_FACTORY);
                factoryMap.put(CDOExplorerURIHandler.BINARY.getScheme(), BINARY_RESOURCE_FACTORY);
            }
            stateLocation = STATE_LOCATION != null ? STATE_LOCATION : BUNDLE.getStateLocation();
            OM.initializeManagers(new File(stateLocation));
        }

        protected void doStop() throws Exception {
            OM.disposeManagers();
            super.doStop();
        }
    }
}

