/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db;

import java.sql.Connection;
import java.util.GregorianCalendar;
import java.util.List;
import oracle.jdbc.pool.OracleDataSource;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.tests.AbstractCDOTest;
import org.eclipse.emf.cdo.tests.config.impl.Config;
import org.eclipse.emf.cdo.tests.db.OracleConfig;
import org.eclipse.emf.cdo.tests.model1.Company;
import org.eclipse.emf.cdo.tests.model1.Model1Factory;
import org.eclipse.emf.cdo.tests.model1.PurchaseOrder;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.jdbc.DelegatingConnection;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.security.IUserAware;

public class DBStoreTest
extends AbstractCDOTest {
    public static void main(String[] args) throws Exception {
        class UserConnection
        extends DelegatingConnection.Default
        implements IUserAware {
            public UserConnection(Connection delegate) {
                super(delegate);
            }

            public String getUserID() {
                return "test_repo1";
            }
        }
        UserConnection connection = null;
        try {
            String userName = "test_repo1";
            OracleDataSource dataSource = OracleConfig.createDataSourceForUser("test_repo1");
            connection = new UserConnection(dataSource.getConnection());
            List names = DBUtil.getAllTableNames((Connection)((Object)connection), null);
            System.out.println(names);
        }
        catch (Throwable throwable) {
            DBUtil.close(connection);
            throw throwable;
        }
        DBUtil.close((Connection)((Object)connection));
    }

    public void testInsertNull() throws Exception {
        CDOSession s = this.openSession();
        CDOTransaction t = s.openTransaction();
        CDOResource r = t.createResource(this.getResourcePath("/dbStoreTest"));
        Company c = Model1Factory.eINSTANCE.createCompany();
        c.setName(null);
        r.getContents().add((Object)c);
        t.commit();
    }

    public void testStoreStringTrailingBackslash() {
        this.storeRetrieve("foobar\\");
    }

    public void testStoreStringContainingBackslash() {
        this.storeRetrieve("foo\\bar");
    }

    public void testStoreStringTrailingSingleQuote() {
        this.storeRetrieve("foobar'");
    }

    public void testStoreStringContainingSingleQuote() {
        this.storeRetrieve("foo'bar");
    }

    public void testStoreStringTrailingDoubleQuote() {
        this.storeRetrieve("foobar\"");
    }

    public void testStoreStringContainingDoubleQuote() {
        this.storeRetrieve("foo\"bar");
    }

    public void testStoreStringTrailingTwoSingleQuote() {
        this.storeRetrieve("foobar''");
    }

    public void testStoreStringContainingTwoSingleQuote() {
        this.storeRetrieve("foo''bar");
    }

    public void testStoreDate() throws CommitException {
        CDOSession session = this.openSession();
        CDOTransaction transaction = session.openTransaction();
        CDOResource resource = transaction.getOrCreateResource(this.getResourcePath("/test"));
        PurchaseOrder o = Model1Factory.eINSTANCE.createPurchaseOrder();
        o.setDate(new GregorianCalendar(2008, 11, 24, 12, 34, 56).getTime());
        resource.getContents().add((Object)o);
        transaction.commit();
        transaction.close();
        session.close();
        this.clearCache((CDORevisionManager)this.getRepository().getRevisionManager());
        session = this.openSession();
        CDOView view = session.openView();
        resource = view.getResource(this.getResourcePath("/test"));
        DBStoreTest.assertEquals((int)1, (int)resource.getContents().size());
        o = (PurchaseOrder)resource.getContents().get(0);
        DBStoreTest.assertEquals((Object)new GregorianCalendar(2008, 11, 24, 12, 34, 56).getTime(), (Object)o.getDate());
    }

    public void testStoreCustom() throws CommitException {
        EPackage pkg = this.createUniquePackage();
        EDataType dt = EcoreFactory.eINSTANCE.createEDataType();
        dt.setName("custom");
        dt.setInstanceClass(Custom.class);
        pkg.getEClassifiers().add((Object)dt);
        EClass clz = EMFUtil.createEClass((EPackage)pkg, (String)"customClass", (boolean)false, (boolean)false);
        EAttribute att = EMFUtil.createEAttribute((EClass)clz, (String)"customAtt", (EClassifier)dt);
        Custom cust1 = new Custom(2, 5);
        Custom cust1ref = new Custom(2, 5);
        Custom cust2 = new Custom(5, 2);
        Custom cust2ref = new Custom(5, 2);
        DBStoreTest.assertEquals((Object)cust1ref, (Object)cust1);
        DBStoreTest.assertEquals((Object)cust2ref, (Object)cust2);
        if (!this.isConfig((Config)LEGACY)) {
            CDOUtil.prepareDynamicEPackage((EPackage)pkg);
        }
        EObject obj1 = EcoreUtil.create((EClass)clz);
        EObject obj2 = EcoreUtil.create((EClass)clz);
        obj1.eSet((EStructuralFeature)att, (Object)cust1);
        obj2.eSet((EStructuralFeature)att, (Object)cust2);
        CDOSession session = this.openSession();
        session.getPackageRegistry().putEPackage(pkg);
        CDOTransaction transaction = session.openTransaction();
        CDOResource resource = transaction.createResource(this.getResourcePath("/test"));
        resource.getContents().add((Object)obj1);
        resource.getContents().add((Object)obj2);
        transaction.commit();
        transaction.close();
        session.close();
        this.clearCache((CDORevisionManager)this.getRepository().getRevisionManager());
        CDOSession session2 = this.openSession();
        session2.getPackageRegistry().putEPackage(pkg);
        CDOView view = session2.openView();
        CDOResource resource2 = view.getResource(this.getResourcePath("/test"));
        DBStoreTest.assertEquals((int)2, (int)resource2.getContents().size());
        EObject obj12 = (EObject)resource2.getContents().get(0);
        EObject obj22 = (EObject)resource2.getContents().get(1);
        DBStoreTest.assertEquals((Object)cust1ref, (Object)obj12.eGet((EStructuralFeature)att));
        DBStoreTest.assertEquals((Object)cust2ref, (Object)obj22.eGet((EStructuralFeature)att));
        view.close();
        session2.close();
    }

    private void storeRetrieve(String s) {
        CDOSession session = this.openSession();
        CDOTransaction transaction = session.openTransaction();
        CDOResource resource = transaction.getOrCreateResource(this.getResourcePath("/test"));
        Company e = Model1Factory.eINSTANCE.createCompany();
        e.setName(s);
        resource.getContents().add((Object)e);
        try {
            transaction.commit();
        }
        catch (CommitException ex) {
            throw WrappedException.wrap((Exception)((Object)ex));
        }
        transaction.close();
        session.close();
        this.clearCache((CDORevisionManager)this.getRepository().getRevisionManager());
        session = this.openSession();
        CDOView view = session.openView();
        resource = view.getResource(this.getResourcePath("/test"));
        DBStoreTest.assertEquals((int)1, (int)resource.getContents().size());
        e = (Company)resource.getContents().get(0);
        DBStoreTest.assertEquals((String)s, (String)e.getName());
    }

    public void testUnderscoreFeature() throws Exception {
        EPackage pkg = this.createUniquePackage();
        EClass cls = EMFUtil.createEClass((EPackage)pkg, (String)"foo", (boolean)false, (boolean)false);
        EAttribute att = EMFUtil.createEAttribute((EClass)cls, (String)"_bar", (EClassifier)EcorePackage.eINSTANCE.getEString());
        if (!this.isConfig((Config)LEGACY)) {
            CDOUtil.prepareDynamicEPackage((EPackage)pkg);
        }
        CDOSession session = this.openSession();
        CDOTransaction transaction = session.openTransaction();
        CDOResource resource = transaction.createResource(this.getResourcePath("/test"));
        EObject foo = EcoreUtil.create((EClass)cls);
        foo.eSet((EStructuralFeature)att, (Object)"foobar");
        resource.getContents().add((Object)foo);
        transaction.commit();
        session.close();
    }

    public void testUnderscoreClass() throws Exception {
        EPackage pkg = this.createUniquePackage();
        EClass cls = EMFUtil.createEClass((EPackage)pkg, (String)"foo", (boolean)false, (boolean)false);
        EAttribute att = EMFUtil.createEAttribute((EClass)cls, (String)"_bar", (EClassifier)EcorePackage.eINSTANCE.getEString());
        if (!this.isConfig((Config)LEGACY)) {
            CDOUtil.prepareDynamicEPackage((EPackage)pkg);
        }
        CDOSession session = this.openSession();
        CDOTransaction transaction = session.openTransaction();
        CDOResource resource = transaction.createResource(this.getResourcePath("/test"));
        EObject foo = EcoreUtil.create((EClass)cls);
        foo.eSet((EStructuralFeature)att, (Object)"foobar");
        resource.getContents().add((Object)foo);
        transaction.commit();
        session.close();
    }

    public static class Custom {
        private int first;
        private int second;

        public Custom(String emfString) {
            int sep = emfString.indexOf(33);
            this.first = Integer.parseInt(emfString.substring(0, sep));
            this.second = Integer.parseInt(emfString.substring(sep + 1));
        }

        public Custom(int first, int second) {
            this.first = first;
            this.second = second;
        }

        public int getFirst() {
            return this.first;
        }

        public int getSecond() {
            return this.second;
        }

        public boolean equals(Object other) {
            if (other instanceof Custom) {
                return this.first == ((Custom)other).first && this.second == ((Custom)other).second;
            }
            return false;
        }

        public int hashCode() {
            return (this.first + 3 * this.second) % 65536;
        }

        public String toString() {
            return Integer.valueOf(this.first) + "!" + Integer.valueOf(this.second);
        }

        public static Custom valueOf(String s) {
            return new Custom(s);
        }
    }
}

