/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests.config;

import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.connector.IServerConnector;
import org.eclipse.net4j.tests.config.TestConfig;
import org.eclipse.net4j.tests.signal.TestSignalProtocol;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.tests.AbstractOMTest;
import org.eclipse.spi.net4j.InternalAcceptor;
import org.eclipse.spi.net4j.InternalConnector;

public abstract class AbstractConfigTest
extends AbstractOMTest {
    protected TestConfig config;
    protected IManagedContainer acceptorContainer;
    protected IManagedContainer connectorContainer;
    protected InternalAcceptor acceptor;
    protected InternalConnector connector;

    protected AbstractConfigTest() {
    }

    protected TestConfig.Factory getDefaultFactory() {
        return new TestConfig.TCP();
    }

    public TestConfig getConfig() {
        return this.config;
    }

    public void setConfig(TestConfig config) {
        this.config = config;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " [" + (this.config == null ? this.getDefaultFactory().getClass().getSimpleName() : this.config) + "]";
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        if (this.config == null) {
            this.config = this.getDefaultFactory().createConfig();
        }
        this.config.setUp();
        this.initContainers();
    }

    @Override
    protected void doTearDown() throws Exception {
        try {
            AbstractConfigTest.sleep(20L);
            LifecycleUtil.deactivate((Object)this.connectorContainer);
            LifecycleUtil.deactivate((Object)this.acceptorContainer);
        }
        finally {
            this.connector = null;
            this.acceptor = null;
            this.acceptorContainer = null;
            this.connectorContainer = null;
            try {
                this.config.tearDown();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            super.doTearDown();
        }
    }

    private void initContainers() {
        this.acceptorContainer = this.createContainer();
        LifecycleUtil.activate((Object)this.acceptorContainer);
        if (this.config.needsSeparateContainers()) {
            this.connectorContainer = this.createContainer();
            LifecycleUtil.activate((Object)this.connectorContainer);
        } else {
            this.connectorContainer = this.acceptorContainer;
        }
    }

    protected IManagedContainer createContainer() {
        IManagedContainer container = ContainerUtil.createContainer();
        container.registerFactory((IFactory)new TestSignalProtocol.Factory());
        Net4jUtil.prepareContainer((IManagedContainer)container);
        this.config.prepareContainer(container);
        return container;
    }

    protected IAcceptor getAcceptor() {
        return this.getAcceptor(true);
    }

    protected IAcceptor getAcceptor(boolean activate) {
        if (this.acceptor == null) {
            this.acceptor = (InternalAcceptor)this.config.getAcceptor(this.acceptorContainer, activate);
        }
        return this.acceptor;
    }

    protected IConnector getConnector() {
        return this.getConnector(true);
    }

    protected IConnector getConnector(boolean activate) {
        if (this.connector == null) {
            this.connector = (InternalConnector)this.config.getConnector(this.connectorContainer, activate);
        }
        return this.connector;
    }

    protected IServerConnector getServerConnector() {
        if (this.acceptor != null) {
            IConnector[] serverConnectors = this.acceptor.getAcceptedConnectors();
            if (serverConnectors.length > 1) {
                throw new IllegalStateException("More than one server connector!");
            }
            if (this.connector == null) {
                if (serverConnectors.length != 0) {
                    throw new IllegalStateException("More is an unexpected server connector!");
                }
                return null;
            }
            return (IServerConnector)serverConnectors[0];
        }
        return null;
    }

    protected void startTransport() throws Exception {
        if (this.acceptorContainer != null) {
            IAcceptor acceptor = this.getAcceptor();
            LifecycleUtil.activate((Object)acceptor);
            if (this.connectorContainer != null) {
                IConnector connector = this.getConnector();
                LifecycleUtil.activate((Object)connector);
            }
        }
    }

    protected void stopTransport() throws Exception {
        if (this.connector != null) {
            this.connector.close();
            this.connector = null;
        }
        if (this.acceptor != null) {
            this.acceptor.close();
            this.acceptor = null;
        }
    }

    protected void restartContainer() throws Exception {
        AbstractConfigTest.msg("RESTARTING CONTAINER");
        this.stopTransport();
        LifecycleUtil.deactivate((Object)this.connectorContainer);
        LifecycleUtil.deactivate((Object)this.acceptorContainer);
        this.initContainers();
        this.startTransport();
        AbstractConfigTest.msg("RESTARTING CONTAINER - FINISHED");
    }
}

