/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.embedded;

import java.io.File;
import org.eclipse.emf.cdo.examples.embedded.EmbeddedH2Repository;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.server.CDOServerBrowser;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public final class CDOFacade
extends EmbeddedH2Repository {
    public static final CDOFacade INSTANCE = new CDOFacade();
    private static final String NAME = "repo";
    private static final boolean AUDITING = false;
    private static final boolean BRANCHING = false;
    private static final File DB_FOLDER = new File("./database");
    private CDOServerBrowser serverBrowser;
    private CDONet4jSession session;
    private CDOTransaction transaction;
    private ResourceSet resourceSet;

    private CDOFacade() {
        super(NAME, false, false, DB_FOLDER);
    }

    public synchronized CDONet4jSession getSession(boolean openOnDemand) {
        this.checkActive();
        if (this.session == null && openOnDemand) {
            this.session = this.openClientSession();
            this.session.addListener((IListener)new LifecycleEventAdapter(){

                protected void onDeactivated(ILifecycle lifecycle) {
                    if (lifecycle == CDOFacade.this.session) {
                        CDOFacade.this.session = null;
                    }
                }
            });
        }
        return this.session;
    }

    public synchronized CDOTransaction getTransaction() {
        this.checkActive();
        if (this.transaction == null) {
            this.resourceSet = new ResourceSetImpl();
            CDONet4jSession session = this.getSession(true);
            this.transaction = session.openTransaction(this.resourceSet);
            this.transaction.addListener((IListener)new LifecycleEventAdapter(){

                protected void onDeactivated(ILifecycle lifecycle) {
                    if (lifecycle == CDOFacade.this.transaction) {
                        CDOFacade.this.transaction = null;
                        CDOFacade.this.resourceSet = null;
                    }
                }
            });
        }
        return this.transaction;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public boolean isInitialPackage(IRepository repository, String nsURI) {
        return nsURI.equals("http://www.eclipse.org/emf/CDO/examples/company/1.0.0");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.serverBrowser = new CDOServerBrowser.ContainerBased((IContainer)this.getContainer());
        LifecycleUtil.activate((Object)this.serverBrowser);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.serverBrowser);
        this.serverBrowser = null;
        super.doDeactivate();
    }
}

