/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.views;

import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.DropType;
import org.eclipse.emf.cdo.lm.FixedBaseline;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.ModuleElement;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.internal.client.SystemManager;
import org.eclipse.emf.cdo.lm.ui.actions.CheckoutAction;
import org.eclipse.emf.cdo.lm.ui.actions.DeleteChangeAction;
import org.eclipse.emf.cdo.lm.ui.actions.DeleteModuleAction;
import org.eclipse.emf.cdo.lm.ui.actions.NewChangeAction;
import org.eclipse.emf.cdo.lm.ui.actions.NewDeliveryAction;
import org.eclipse.emf.cdo.lm.ui.actions.NewDropAction;
import org.eclipse.emf.cdo.lm.ui.actions.NewModuleAction;
import org.eclipse.emf.cdo.lm.ui.actions.NewStreamAction;
import org.eclipse.emf.cdo.lm.ui.actions.RenameChangeAction;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.emf.cdo.lm.ui.providers.SystemContentProvider;
import org.eclipse.emf.cdo.lm.ui.providers.SystemLabelProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.ui.shared.SharedIcons;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.net4j.util.ui.views.MultiViewersView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;

public class SystemsView
extends MultiViewersView {
    public static final String ID = "org.eclipse.emf.cdo.lm.SystemsView";
    protected final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final IListener systemManagerListener = new ContainerEventAdapter<ISystemDescriptor>(){

        protected void onAdded(IContainer<ISystemDescriptor> container, ISystemDescriptor descriptor) {
            this.refreshViewer(ISystemManager.INSTANCE);
        }

        protected void onRemoved(IContainer<ISystemDescriptor> container, ISystemDescriptor descriptor) {
            this.refreshViewer(ISystemManager.INSTANCE);
        }

        protected void notifyOtherEvent(IEvent event) {
            this.refreshViewer(ISystemManager.INSTANCE);
        }

        private void refreshViewer(Object element) {
            if (SystemsView.this.treeViewer != null) {
                UIUtil.refreshElement((StructuredViewer)SystemsView.this.treeViewer, (Object)element, (boolean)true);
            }
        }
    };
    private TreeViewer treeViewer;

    public void dispose() {
        ISystemManager.INSTANCE.removeListener(this.systemManagerListener);
        this.adapterFactory.dispose();
        super.dispose();
    }

    protected Control createUI(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 0);
        this.treeViewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.treeViewer.setInput((Object)ISystemManager.INSTANCE);
        ISystemManager.INSTANCE.addListener(this.systemManagerListener);
        this.setCurrentViewer((StructuredViewer)this.treeViewer);
        return this.treeViewer.getTree();
    }

    protected ITreeContentProvider createContentProvider() {
        return new SystemContentProvider((AdapterFactory)this.adapterFactory);
    }

    protected ILabelProvider createLabelProvider() {
        return new SystemLabelProvider((AdapterFactory)this.adapterFactory);
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        ShowModuleHistoryAction showModuleHistoryAction = new ShowModuleHistoryAction();
        showModuleHistoryAction.setChecked((Boolean)OM.PREF_SHOW_MODULE_HISTORY.getValue());
        manager.add((IAction)showModuleHistoryAction);
        manager.add((IAction)new RefreshAction());
        super.fillLocalPullDown(manager);
    }

    protected void fillContextMenu(IMenuManager manager, StructuredViewer viewer, IStructuredSelection selection) {
        super.fillContextMenu(manager, viewer, selection);
        IWorkbenchPage page = this.getSite().getPage();
        Object element = selection.getFirstElement();
        if (element instanceof ISystemDescriptor) {
            final ISystemDescriptor descriptor = (ISystemDescriptor)element;
            if (descriptor.getState() == ISystemDescriptor.State.Closed) {
                manager.add((IAction)new Action("Open"){

                    public void run() {
                        descriptor.open();
                    }
                });
            }
        } else if (element instanceof System) {
            final System system = (System)element;
            manager.add((IAction)new NewModuleAction(page, system));
            manager.add((IAction)new Action("Close"){

                public void run() {
                    ISystemDescriptor descriptor = ISystemManager.INSTANCE.getDescriptor((EObject)system);
                    descriptor.close();
                }
            });
        } else if (element instanceof Module) {
            Module module = (Module)element;
            manager.add((IAction)new NewStreamAction(page, (AdapterFactory)this.adapterFactory, module));
            manager.add((IAction)new DeleteModuleAction(page, module));
        } else if (element instanceof Baseline) {
            Baseline baseline = (Baseline)element;
            manager.add((IAction)new CheckoutAction(page, baseline));
            manager.add((IContributionItem)new Separator());
            if (baseline instanceof FixedBaseline) {
                FixedBaseline fixedBaseline = (FixedBaseline)baseline;
                Stream stream = fixedBaseline.getStream();
                manager.add((IAction)new NewChangeAction(page, stream, fixedBaseline));
                manager.add((IContributionItem)new Separator());
            } else if (baseline instanceof Stream) {
                Stream stream = (Stream)baseline;
                manager.add((IAction)new NewChangeAction(page, stream, null));
                manager.add((IAction)new NewDeliveryAction(page, stream, null));
                manager.add((IContributionItem)new Separator());
                EList possibleDropTypes = stream.getSystem().getProcess().getDropTypes();
                for (DropType dropType : possibleDropTypes) {
                    manager.add((IAction)new NewDropAction(page, stream, dropType));
                }
            } else if (baseline instanceof Change) {
                Change change = (Change)baseline;
                if (change.getDeliveries().isEmpty()) {
                    manager.add((IAction)new RenameChangeAction(page, change));
                    manager.add((IAction)new DeleteChangeAction(page, change));
                }
                for (Stream s : change.getModule().getStreams()) {
                    if (change.getDeliveryPoint(s) != null) continue;
                    manager.add((IAction)new NewDeliveryAction(page, s, change));
                }
            }
        }
        manager.add((IContributionItem)new Separator());
    }

    protected void doubleClicked(Object object) {
        ISystemDescriptor descriptor;
        super.doubleClicked(object);
        if (object instanceof ISystemDescriptor && (descriptor = (ISystemDescriptor)object).getState() == ISystemDescriptor.State.Closed) {
            SystemManager.INSTANCE.scheduleOpenSystem(descriptor);
        }
    }

    private final class RefreshAction
    extends SafeAction {
        public RefreshAction() {
            super("Refresh", "Refresh the list of recognized systems", SharedIcons.getDescriptor((String)"etool16/refresh"));
        }

        protected void safeRun() throws Exception {
            ISystemManager.INSTANCE.refresh();
        }
    }

    private final class ShowModuleHistoryAction
    extends Action {
        public ShowModuleHistoryAction() {
            super("Show Module History", 2);
        }

        public void run() {
            boolean newValue = (Boolean)OM.PREF_SHOW_MODULE_HISTORY.getValue() == false;
            OM.PREF_SHOW_MODULE_HISTORY.setValue((Object)newValue);
            this.setChecked(newValue);
            StructuredViewer viewer = SystemsView.this.getCurrentViewer();
            IStructuredSelection oldSelection = viewer.getStructuredSelection();
            boolean selectionChanged = false;
            try {
                ISystemDescriptor systemDescriptor;
                Object element = oldSelection.getFirstElement();
                if ((element instanceof ModuleElement || element instanceof Module) && (systemDescriptor = ISystemManager.INSTANCE.getDescriptor((EObject)element)) != null) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)systemDescriptor.getSystem()));
                    selectionChanged = true;
                }
            }
            finally {
                if (selectionChanged) {
                    viewer.setSelection((ISelection)oldSelection);
                }
            }
        }
    }
}

