/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db.bugzilla;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.CountDownLatch;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalNonAuditMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.NonAuditListTableMapping;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.tests.AbstractCDOTest;
import org.eclipse.emf.cdo.tests.config.impl.ConfigTest;
import org.eclipse.emf.cdo.tests.model1.Company;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.IDBPreparedStatement;

@ConfigTest.Skips(value={"repository.auditing"})
@ConfigTest.CleanRepositoriesBefore(reason="TEST_MAPPING_STRATEGY")
@ConfigTest.CleanRepositoriesAfter(reason="TEST_MAPPING_STRATEGY")
public class Bugzilla_396743_Test
extends AbstractCDOTest {
    private CountDownLatch readValueLatch;
    private CountDownLatch commitLatch;

    private void awaitReadValues() {
        if (this.readValueLatch == null) {
            return;
        }
        if (StoreThreadLocal.getCommitContext() != null) {
            return;
        }
        Bugzilla_396743_Test.await((CountDownLatch)this.readValueLatch);
    }

    public void testWrongListSizeAdditions() throws Exception {
        this.getTestProperties().put("test.repository.MappingStrategy", new HorizontalNonAuditMappingStrategy(){

            public IListMapping doCreateListMapping(EClass containingClass, EStructuralFeature feature) {
                if (feature == Bugzilla_396743_Test.this.getModel1Package().getCompany_Categories()) {
                    Bugzilla_396743_Test.msg((Object)("Instrumenting " + feature));
                    return new NonAuditListTableMapping((IMappingStrategy)this, containingClass, feature){

                        protected void setKeyFields(PreparedStatement stmt, CDORevision revision) throws SQLException {
                            if (((IDBPreparedStatement)stmt).getSQL().toUpperCase().startsWith("SELECT") && revision.getEClass() == Bugzilla_396743_Test.this.getModel1Package().getCompany()) {
                                (this).Bugzilla_396743_Test.this.commitLatch.countDown();
                                Bugzilla_396743_Test.this.awaitReadValues();
                            }
                            super.setKeyFields(stmt, revision);
                        }
                    };
                }
                return super.doCreateListMapping(containingClass, feature);
            }
        });
        Company company1 = this.getModel1Factory().createCompany();
        company1.getCategories().add((Object)this.getModel1Factory().createCategory());
        CDOSession session1 = this.openSession();
        CDOTransaction transaction1 = session1.openTransaction();
        CDOResource resource1 = transaction1.createResource(this.getResourcePath("res"));
        resource1.getContents().add((Object)company1);
        transaction1.commit();
        CDORevision revision = CDOUtil.getCDOObject((EObject)company1).cdoRevision();
        this.getRepository().getRevisionManager().getCache().removeRevision(revision.getID(), (CDOBranchVersion)revision);
        this.readValueLatch = new CountDownLatch(1);
        this.commitLatch = new CountDownLatch(1);
        final boolean[] exceptionOccured = new boolean[1];
        Thread readerClient = new Thread("Test Reader Client"){

            @Override
            public void run() {
                CDOSession session2 = Bugzilla_396743_Test.this.openSession();
                CDOTransaction transaction2 = session2.openTransaction();
                CDOResource resource2 = transaction2.getResource(Bugzilla_396743_Test.this.getResourcePath("res"));
                try {
                    resource2.getContents().get(0);
                }
                catch (Exception ex) {
                    exceptionOccured[0] = ex.getMessage().contains("IndexOutOfBoundsException");
                }
                session2.close();
            }
        };
        readerClient.start();
        Bugzilla_396743_Test.await((CountDownLatch)this.commitLatch);
        company1.getCategories().add((Object)this.getModel1Factory().createCategory());
        try {
            try {
                transaction1.commit();
            }
            catch (Exception ex) {
                if (ex.getMessage().contains("TimeoutRuntimeException")) {
                    this.readValueLatch.countDown();
                    readerClient.join(15000L);
                    return;
                }
                throw ex;
            }
        }
        finally {
            this.readValueLatch.countDown();
            readerClient.join(15000L);
        }
        Bugzilla_396743_Test.assertEquals((String)"In the reader thread an IndexOutOfBoundsException occured", (boolean)false, (boolean)exceptionOccured[0]);
    }
}

