/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.lm.LMFactory;
import org.eclipse.emf.cdo.lm.LMPackage;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.Process;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.modules.ModuleDefinition;
import org.eclipse.emf.cdo.lm.modules.ModulesFactory;
import org.eclipse.emf.cdo.lm.server.bundle.OM;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.security.SecurityManagerUtil;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.IJVMAcceptor;
import org.eclipse.net4j.jvm.IJVMConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.RunnableWithException;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.eclipse.net4j.util.security.PasswordCredentialsProvider;
import org.eclipse.net4j.util.security.SecurityUtil;

public abstract class AbstractLifecycleManager
extends Lifecycle
implements LMPackage.Literals {
    private static final String ACCEPTOR_NAME = "org.eclipse.emf.cdo.lm.server";
    private static final boolean SECURITY_AVAILABLE;
    private IManagedContainer container;
    private IJVMAcceptor acceptor;
    private IJVMConnector connector;
    private String systemName;
    private InternalRepository systemRepository;
    private CDOSession systemSession;
    private String moduleDefinitionPath;
    private final Map<String, InternalRepository> moduleRepositories = new HashMap<String, InternalRepository>();
    private final Map<String, CDOSession> moduleSessions = new HashMap<String, CDOSession>();
    private final IRepository.WriteAccessHandler writeAccessHandler = new IRepository.WriteAccessHandler(){

        public void handleTransactionBeforeCommitting(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws RuntimeException {
            AbstractLifecycleManager.this.handleCommit(commitContext);
        }

        public void handleTransactionAfterCommitted(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) {
        }
    };
    private Consumer<Process> processInitializer;
    private SecuritySupport securitySupport = SecuritySupport.UNAVAILABLE;

    static {
        boolean securityAvailable;
        try {
            securityAvailable = CommonPlugin.loadClass((String)"org.eclipse.emf.cdo.server.security", (String)"org.eclipse.emf.cdo.server.security.ISecurityManager") != null;
        }
        catch (Throwable ex) {
            securityAvailable = false;
        }
        SECURITY_AVAILABLE = securityAvailable;
    }

    public IManagedContainer getContainer() {
        return this.container;
    }

    public final IJVMConnector getConnector() {
        return this.connector;
    }

    public InternalRepository getSystemRepository() {
        return this.systemRepository;
    }

    public void setSystemRepository(InternalRepository repository) {
        this.checkInactive();
        this.container = repository.getContainer();
        this.systemRepository = repository;
        if (SECURITY_AVAILABLE) {
            this.securitySupport = new SecuritySupport.Available(this.systemRepository);
        }
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.checkInactive();
        this.systemName = systemName;
    }

    public Consumer<Process> getProcessInitializer() {
        return this.processInitializer;
    }

    public void setProcessInitializer(Consumer<Process> processInitializer) {
        this.processInitializer = processInitializer;
    }

    public String getModuleDefinitionPath() {
        return this.moduleDefinitionPath;
    }

    public void setModuleDefinitionPath(String moduleDefinitionPath) {
        this.checkInactive();
        this.moduleDefinitionPath = moduleDefinitionPath;
    }

    public final Map<String, InternalRepository> getModuleRepositories() {
        return this.moduleRepositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CDOSession getModuleSession(final String moduleName) {
        Map<String, CDOSession> map = this.moduleSessions;
        synchronized (map) {
            InternalRepository repository;
            CDOSession session = this.moduleSessions.get(moduleName);
            if (session == null && (repository = this.moduleRepositories.get(moduleName)) != null) {
                session = this.openModuleSession(repository);
                session.addListener((IListener)new LifecycleEventAdapter(){

                    protected void onDeactivated(ILifecycle lifecycle) {
                        if (AbstractLifecycleManager.this.isActive()) {
                            AbstractLifecycleManager.this.moduleSessions.remove(moduleName);
                        }
                    }
                });
                this.moduleSessions.put(moduleName, session);
            }
            return session;
        }
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.systemRepository, "systemRepository");
        this.checkState(this.systemName, "systemName");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.acceptor = JVMUtil.getAcceptor((IManagedContainer)this.container, (String)ACCEPTOR_NAME);
        this.connector = JVMUtil.getConnector((IManagedContainer)this.container, (String)ACCEPTOR_NAME);
        CDONet4jSessionConfiguration sessionConfiguration = this.createSessionConfiguration(this.systemRepository.getName());
        this.systemSession = sessionConfiguration.openNet4jSession();
        List<String> moduleNames = this.initSystemRepository(this.systemSession);
        if (moduleNames != null) {
            for (String moduleName : moduleNames) {
                this.addModule(moduleName);
            }
        }
        this.systemRepository.addHandler((IRepository.Handler)this.writeAccessHandler);
    }

    protected void doDeactivate() throws Exception {
        this.systemRepository.removeHandler((IRepository.Handler)this.writeAccessHandler);
        LifecycleUtil.deactivate((Object)this.systemSession);
        AbstractLifecycleManager.deactivate(this.moduleSessions);
        AbstractLifecycleManager.deactivate(this.moduleRepositories);
        LifecycleUtil.deactivate((Object)this.connector);
        LifecycleUtil.deactivate((Object)this.acceptor);
        super.doDeactivate();
    }

    protected List<String> initSystemRepository(CDOSession session) throws Exception {
        CDOTransaction transaction = session.openTransaction();
        CDOResource resource = transaction.getOrCreateResource("/system");
        EList contents = resource.getContents();
        if (contents.isEmpty()) {
            OM.LOG.info("Initializing system resource");
            Process process = LMFactory.eINSTANCE.createProcess();
            process.setModuleDefinitionPath(this.moduleDefinitionPath);
            process.setInitialModuleVersion(Version.createOSGi((int)0, (int)1, (int)0));
            this.initProcess(process);
            System system = LMFactory.eINSTANCE.createSystem();
            system.setName(this.systemName);
            system.setProcess(process);
            contents.add((Object)system);
            transaction.setCommitComment("<initialize system>");
            transaction.commit();
            return null;
        }
        EObject root = (EObject)contents.get(0);
        if (root instanceof System) {
            System system = (System)root;
            String name = system.getName();
            if (!Objects.equals(name, this.systemName)) {
                throw new IllegalStateException("System name '" + name + "' does not match configured name '" + this.systemName + "'");
            }
            ArrayList<String> moduleNames = new ArrayList<String>();
            for (Module module : system.getModules()) {
                moduleNames.add(module.getName());
            }
            return moduleNames;
        }
        throw new IllegalStateException("System resource does not contain a system");
    }

    protected void initProcess(Process process) {
        if (this.processInitializer != null) {
            this.processInitializer.accept(process);
        }
    }

    protected void handleCommit(IStoreAccessor.CommitContext commitContext) {
        InternalCDORevisionDelta[] dirtyObjectDeltas = commitContext.getDirtyObjectDeltas();
        if (dirtyObjectDeltas != null) {
            ArrayList<Pair<String, CDOID>> newModules = new ArrayList<Pair<String, CDOID>>();
            int i = 0;
            while (i < dirtyObjectDeltas.length) {
                InternalCDORevisionDelta revisionDelta = dirtyObjectDeltas[i];
                EClass eClass = revisionDelta.getEClass();
                if (eClass == SYSTEM) {
                    AbstractLifecycleManager.handleListDelta(commitContext, revisionDelta, SYSTEM__MODULES, addedModule -> this.handleModuleAddition((InternalCDORevision)addedModule, (List<Pair<String, CDOID>>)newModules), removeModuleDelta -> this.handleModuleDeletion(commitContext, revisionDelta, (CDORemoveFeatureDelta)removeModuleDelta));
                } else if (eClass == MODULE) {
                    CDOFeatureDelta featureDelta = revisionDelta.getFeatureDelta((EStructuralFeature)MODULE__NAME);
                    if (featureDelta != null) {
                        throw new CDOException("Renaming modules is not supported");
                    }
                } else if (eClass == STREAM) {
                    AbstractLifecycleManager.handleListDelta(commitContext, revisionDelta, STREAM__CONTENTS, addedContent -> this.handleBaselineAddition(commitContext, (InternalCDORevision)addedContent), AbstractLifecycleManager::preventRemoval);
                }
                ++i;
            }
            this.createNewModules(commitContext, newModules);
        }
    }

    protected void handleModuleAddition(InternalCDORevision addedModule, List<Pair<String, CDOID>> newModules) {
        String name = (String)addedModule.get((EStructuralFeature)MODULE__NAME, 0);
        if (!this.isValidModuleName(name)) {
            throw new CDOException("Module name is invalid: " + name);
        }
        if (this.moduleRepositories.containsKey(name)) {
            throw new CDOException("Module name is not unique: " + name);
        }
        CDOID initialStreamID = null;
        CDOList streams = addedModule.getListOrNull((EStructuralFeature)MODULE__STREAMS);
        if (streams != null && !streams.isEmpty()) {
            initialStreamID = (CDOID)streams.get(0);
        }
        newModules.add((Pair<String, CDOID>)Pair.create((Object)name, initialStreamID));
    }

    protected void handleModuleDeletion(IStoreAccessor.CommitContext commitContext, InternalCDORevisionDelta systemRevisionDelta, CDORemoveFeatureDelta removeModuleDelta) {
        CDOID systemID = systemRevisionDelta.getID();
        int index = removeModuleDelta.getIndex();
        InternalCDORevision systemRevision = (InternalCDORevision)commitContext.getOldRevisions().get(systemID);
        CDOID removedID = (CDOID)systemRevision.get((EStructuralFeature)SYSTEM__MODULES, index);
        InternalCDORevision[] internalCDORevisionArray = ((InternalCommitContext)commitContext).getDetachedRevisions();
        int n = internalCDORevisionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevision revision = internalCDORevisionArray[n2];
            if (revision.getID() == removedID) {
                String moduleName = (String)revision.get((EStructuralFeature)MODULE__NAME, 0);
                CDOSession session = this.moduleSessions.remove(moduleName);
                LifecycleUtil.deactivate((Object)session);
                InternalRepository repository = this.moduleRepositories.remove(moduleName);
                LifecycleUtil.deactivate((Object)repository);
                break;
            }
            ++n2;
        }
    }

    protected void handleBaselineAddition(IStoreAccessor.CommitContext commitContext, InternalCDORevision addedContent) {
    }

    protected void createNewModules(IStoreAccessor.CommitContext commitContext, List<Pair<String, CDOID>> newModules) {
        for (Pair<String, CDOID> newModule : newModules) {
            try {
                Version initialModuleVersion;
                String newModuleName = (String)newModule.getElement1();
                CDOID initialStreamID = (CDOID)newModule.getElement2();
                this.createNewModule(newModuleName);
                try (CDOView systemView = this.systemSession.openView();){
                    CDOResource systemResource = systemView.getResource("/system");
                    System system = (System)systemResource.getContents().get(0);
                    Process process = system.getProcess();
                    initialModuleVersion = process.getInitialModuleVersion();
                }
                CDOSession moduleSession = this.getModuleSession(newModuleName);
                try (CDOTransaction moduleTransaction = moduleSession.openTransaction();){
                    if (moduleTransaction.hasResource(this.moduleDefinitionPath)) continue;
                    ModuleDefinition moduleDefinition = ModulesFactory.eINSTANCE.createModuleDefinition();
                    moduleDefinition.setName(newModuleName);
                    moduleDefinition.setVersion(initialModuleVersion);
                    CDOResource moduleDefinitionResource = moduleTransaction.createResource(this.moduleDefinitionPath);
                    moduleDefinitionResource.getContents().add((Object)moduleDefinition);
                    moduleTransaction.commit();
                    long creationTime = moduleSession.getRepositoryInfo().getCreationTime();
                    commitContext.modify(context -> {
                        for (CDOIDAndVersion newObject : context.getChangeSetData().getNewObjects()) {
                            if (newObject.getID() != initialStreamID) continue;
                            InternalCDORevision streamRevision = (InternalCDORevision)newObject;
                            streamRevision.set((EStructuralFeature)STREAM__START_TIME_STAMP, 0, (Object)creationTime);
                        }
                    });
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected void createNewModule(String moduleName) throws Exception {
        this.addModule(moduleName);
    }

    protected boolean isValidModuleName(String moduleName) {
        if (moduleName == null) {
            return false;
        }
        String trimmed = moduleName.trim();
        if (!Objects.equals(trimmed, moduleName)) {
            return false;
        }
        return trimmed.length() != 0;
    }

    protected void addModule(String moduleName) throws Exception {
        RunnableWithException.forkAndWait(() -> {
            OM.LOG.info("Adding module " + moduleName + " to system " + this.systemName);
            InternalRepository moduleRepository = this.createModuleRepository(moduleName);
            CDOServerUtil.addRepository((IManagedContainer)this.container, (IRepository)moduleRepository);
            this.securitySupport.addModuleRepository(moduleRepository);
            this.moduleRepositories.put(moduleName, moduleRepository);
        });
    }

    protected abstract InternalRepository createModuleRepository(String var1) throws CoreException;

    protected CDONet4jSession openModuleSession(InternalRepository moduleRepository) {
        CDONet4jSessionConfiguration configuration = this.createSessionConfiguration(moduleRepository.getName());
        configuration.setSignalTimeout(Integer.MAX_VALUE);
        CDONet4jSession session = configuration.openNet4jSession();
        session.options().setCommitTimeout(Integer.MAX_VALUE);
        return session;
    }

    protected CDONet4jSessionConfiguration createSessionConfiguration(String repositoryName) {
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        configuration.setConnector((IConnector)this.connector);
        configuration.setRepositoryName(repositoryName);
        IPasswordCredentials credentials = this.securitySupport.getCredentials();
        if (credentials != null) {
            configuration.setCredentialsProvider((IPasswordCredentialsProvider)new PasswordCredentialsProvider(credentials));
        }
        return configuration;
    }

    private <R> R executeAgainstModuleSession(IStoreAccessor.CommitContext commitContext, CDOID moduleID, final Function<CDOSession, R> function) {
        CDORevision module = commitContext.getRevision(moduleID);
        String moduleName = (String)module.data().get((EStructuralFeature)MODULE__NAME, 0);
        final CDOSession moduleSession = this.getModuleSession(moduleName);
        final Throwable[] exception = new Throwable[1];
        final AtomicReference result = new AtomicReference();
        Thread thread = new Thread(function.getClass().getName()){

            @Override
            public void run() {
                try {
                    Object value = function.apply(moduleSession);
                    result.set(value);
                }
                catch (Error | RuntimeException ex) {
                    exception[0] = ex;
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException ex) {
            thread.interrupt();
            throw WrappedException.wrap((Exception)ex);
        }
        if (exception[0] instanceof RuntimeException) {
            throw (RuntimeException)exception[0];
        }
        if (exception[0] instanceof Error) {
            throw (Error)exception[0];
        }
        return (R)result.get();
    }

    private static void handleListDelta(IStoreAccessor.CommitContext commitContext, InternalCDORevisionDelta revisionDelta, EReference reference, Consumer<InternalCDORevision> additionConsumer, Consumer<CDORemoveFeatureDelta> removalConsumer) {
        CDOListFeatureDelta listDelta = (CDOListFeatureDelta)revisionDelta.getFeatureDelta((EStructuralFeature)reference);
        if (listDelta != null) {
            for (CDOFeatureDelta featureDelta : listDelta.getListChanges()) {
                if (removalConsumer != null && featureDelta instanceof CDORemoveFeatureDelta) {
                    CDORemoveFeatureDelta removeDelta = (CDORemoveFeatureDelta)featureDelta;
                    removalConsumer.accept(removeDelta);
                    continue;
                }
                if (additionConsumer == null || !(featureDelta instanceof CDOAddFeatureDelta)) continue;
                CDOAddFeatureDelta addDelta = (CDOAddFeatureDelta)featureDelta;
                CDOID id = (CDOID)addDelta.getValue();
                InternalCDORevision revision = (InternalCDORevision)commitContext.getRevision(id);
                additionConsumer.accept(revision);
            }
        }
    }

    private static void preventRemoval(CDORemoveFeatureDelta removeFeatureDelta) throws CDOException {
        EStructuralFeature feature = removeFeatureDelta.getFeature();
        EClass eClass = feature.getEContainingClass();
        throw new CDOException("Removing from " + eClass.getName() + "." + feature.getName() + " is not supported");
    }

    private static void deactivate(Map<String, ?> map) {
        for (Object value : map.values()) {
            LifecycleUtil.deactivate(value);
        }
        map.clear();
    }

    public static CDOBranchRef getBranch(CDORevision floatingBaseline) {
        String branchPath = null;
        EClass eClass = floatingBaseline.getEClass();
        if (eClass == STREAM) {
            branchPath = (String)floatingBaseline.data().get((EStructuralFeature)STREAM__MAINTENANCE_BRANCH, 0);
            if (branchPath == null) {
                branchPath = (String)floatingBaseline.data().get((EStructuralFeature)STREAM__DEVELOPMENT_BRANCH, 0);
            }
        } else if (eClass == CHANGE) {
            branchPath = (String)floatingBaseline.data().get((EStructuralFeature)CHANGE__BRANCH, 0);
        }
        if (branchPath == null) {
            return null;
        }
        return new CDOBranchRef(branchPath);
    }

    private static interface SecuritySupport {
        public static final SecuritySupport UNAVAILABLE = new SecuritySupport(){

            @Override
            public IPasswordCredentials getCredentials() {
                return null;
            }

            @Override
            public void addModuleRepository(InternalRepository moduleRepository) {
            }
        };

        public IPasswordCredentials getCredentials();

        public void addModuleRepository(InternalRepository var1);

        public static final class Available
        implements SecuritySupport {
            private static final String USER_NAME = "Lifecycle Manager";
            private static final char[] KEY = new char[]{'c', 'd', 'o', ' ', 'r', 'o', 'c', 'k', 's', ' ', '(', 'e', 's', ')'};
            private final InternalSecurityManager securityManager;
            private final IPasswordCredentials credentials;

            public Available(InternalRepository systemRepository) {
                this.securityManager = (InternalSecurityManager)SecurityManagerUtil.getSecurityManager((IRepository)systemRepository);
                if (this.securityManager != null) {
                    byte[] bytes;
                    String uuid = systemRepository.getUUID();
                    try {
                        bytes = SecurityUtil.pbeEncrypt((byte[])uuid.getBytes(), (char[])KEY, (String)"PBEWithMD5AndDES", (byte[])SecurityUtil.DEFAULT_SALT, (int)20);
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                        bytes = new String(KEY).getBytes();
                    }
                    String hex = HexUtil.bytesToHex((byte[])bytes);
                    this.credentials = new PasswordCredentials(USER_NAME, SecurityUtil.toCharArray((String)hex));
                    this.securityManager.modify(realm -> {
                        User lmUser = realm.getUser(this.credentials.getUserID());
                        if (lmUser == null) {
                            Role normalObjectsWriter;
                            lmUser = realm.addUser(this.credentials);
                            Role allObjectsReader = realm.getRole("All Objects Reader");
                            if (allObjectsReader != null) {
                                lmUser.getRoles().add((Object)allObjectsReader);
                            }
                            if ((normalObjectsWriter = realm.getRole("Normal Objects Writer")) != null) {
                                lmUser.getRoles().add((Object)normalObjectsWriter);
                            }
                        }
                    });
                } else {
                    this.credentials = null;
                }
            }

            @Override
            public IPasswordCredentials getCredentials() {
                return this.credentials;
            }

            @Override
            public void addModuleRepository(InternalRepository moduleRepository) {
                if (this.securityManager != null) {
                    this.securityManager.addSecondaryRepository(moduleRepository);
                }
            }
        }
    }
}

