/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db.offline;

import java.io.File;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.tests.db.offline.DBOfflineConfig;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.io.TMPUtil;
import org.h2.jdbcx.JdbcDataSource;

public class H2OfflineConfig
extends DBOfflineConfig {
    private static final long serialVersionUID = 1L;
    private static File reusableFolder;
    private static JdbcDataSource defaultDataSource;

    public H2OfflineConfig() {
        super("H2Offline");
    }

    @Override
    public void initCapabilities(Set<String> capabilities) {
        super.initCapabilities(capabilities);
        capabilities.add("H2");
    }

    @Override
    protected IDBAdapter createDBAdapter() {
        return new H2Adapter();
    }

    @Override
    protected DataSource createDataSource(String repoName) {
        block7: {
            if (reusableFolder == null) {
                reusableFolder = this.createDBFolder();
                IOUtil.delete((File)reusableFolder);
            }
            if (defaultDataSource == null) {
                defaultDataSource = new JdbcDataSource();
                defaultDataSource.setURL("jdbc:h2:" + reusableFolder.getAbsolutePath() + "/h2test");
            }
            Connection conn = null;
            Statement stmt = null;
            try {
                try {
                    conn = defaultDataSource.getConnection();
                    stmt = conn.createStatement();
                    stmt.execute("DROP SCHEMA IF EXISTS " + repoName);
                    stmt.execute("CREATE SCHEMA " + repoName);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DBUtil.close((Connection)conn);
                    DBUtil.close((Statement)stmt);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DBUtil.close((Connection)conn);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
            DBUtil.close((Connection)conn);
            DBUtil.close((Statement)stmt);
        }
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:" + reusableFolder.getAbsolutePath() + "/h2test;SCHEMA=" + repoName);
        return dataSource;
    }

    protected File createDBFolder() {
        return TMPUtil.createTempFolder((String)"h2_", (String)"_test");
    }

    protected void tearDownClean(String repoName) {
        reusableFolder.deleteOnExit();
        Connection connection = null;
        Statement stmt = null;
        try {
            try {
                connection = defaultDataSource.getConnection();
                stmt = connection.createStatement();
                stmt.execute("DROP SCHEMA " + repoName);
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(stmt);
            DBUtil.close((Connection)connection);
            throw throwable;
        }
        DBUtil.close((Statement)stmt);
        DBUtil.close((Connection)connection);
    }
}

