/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.factory;

import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.factory.ProductDescriptionAware;
import org.eclipse.net4j.util.factory.PropertiesFactory;

public final class SimpleFactory
extends Factory {
    public static final String ELEM = "simpleFactory";
    private static final String ATTR_PRODUCT_CLASS = "productClass";
    private static final String ATTR_SETTER_NAME = "setterName";
    private final IConfigurationElement configurationElement;

    public SimpleFactory(IConfigurationElement configurationElement) {
        super(SimpleFactory.getProductGroup(configurationElement), SimpleFactory.getType(configurationElement));
        this.configurationElement = configurationElement;
    }

    @Override
    public Object create(String description) throws ProductCreationException {
        try {
            Object product = this.configurationElement.createExecutableExtension(ATTR_PRODUCT_CLASS);
            if (product != null) {
                this.configure(product, description);
            }
            return product;
        }
        catch (Exception ex) {
            throw new ProductCreationException("Could not create product of type '" + SimpleFactory.getType(this.configurationElement) + "' in group '" + SimpleFactory.getProductGroup(this.configurationElement) + "'", ex);
        }
    }

    private void configure(Object product, String description) throws NoSuchMethodException {
        String setterName = this.configurationElement.getAttribute(ATTR_SETTER_NAME);
        if (!StringUtil.isEmpty(setterName)) {
            Method propertiesSetter = SimpleFactory.getSetter(product, setterName, Map.class);
            if (propertiesSetter != null) {
                Map<String, String> properties = PropertiesFactory.parseProperties(description);
                ReflectUtil.invokeMethod(propertiesSetter, product, properties);
                return;
            }
            Method descriptionSetter = SimpleFactory.getSetter(product, setterName, String.class);
            if (descriptionSetter != null) {
                ReflectUtil.invokeMethod(descriptionSetter, product, description);
                return;
            }
            throw new NoSuchMethodException("Class " + product.getClass().getName() + " has no " + setterName + "(Map<String, String>) and no " + setterName + "(String) method");
        }
        if (product instanceof ProductDescriptionAware) {
            ((ProductDescriptionAware)product).setDescription(description);
            return;
        }
    }

    private static String getProductGroup(IConfigurationElement configurationElement) {
        return configurationElement.getAttribute("productGroup");
    }

    private static String getType(IConfigurationElement configurationElement) {
        return configurationElement.getAttribute("type");
    }

    private static Method getSetter(Object product, String name, Class<?> paramType) {
        return ReflectUtil.getMethodOrNull(product.getClass(), name, paramType);
    }
}

