/*
 * Decompiled with CFR 0.152.
 */
package org.gastro.internal.rcp;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.gastro.business.BusinessDay;
import org.gastro.business.BusinessFactory;
import org.gastro.inventory.InventoryFactory;
import org.gastro.inventory.MenuCard;
import org.gastro.inventory.Restaurant;
import org.gastro.inventory.Station;
import org.gastro.rcp.IConfiguration;
import org.gastro.rcp.IModel;

public class Model
extends Lifecycle
implements IModel {
    public static final Model INSTANCE = new Model();
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry());
    private CDONet4jSession session;
    private CDOView view;
    private Restaurant restaurant;
    private BusinessDay businessDay;
    private Station station;

    private Model() {
    }

    @Override
    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    @Override
    public synchronized Restaurant getRestaurant() {
        if (this.restaurant == null) {
            String name = IConfiguration.INSTANCE.getRestaurant();
            String path = String.valueOf(name) + "/inventory";
            if (!this.view.hasResource(path)) {
                CDOTransaction transaction = this.session.openTransaction();
                Restaurant restaurant = InventoryFactory.eINSTANCE.createRestaurant();
                restaurant.setName(name);
                try {
                    try {
                        CDOResource resource = transaction.createResource(path);
                        resource.getContents().add((Object)restaurant);
                        transaction.commit();
                    }
                    catch (CommitException ex) {
                        throw WrappedException.wrap((Exception)((Object)ex));
                    }
                }
                finally {
                    transaction.close();
                }
            }
            CDOResource resource = this.view.getResource(path);
            this.restaurant = (Restaurant)resource.getContents().get(0);
        }
        return this.restaurant;
    }

    @Override
    public synchronized BusinessDay getBusinessDay() {
        if (this.businessDay == null) {
            Restaurant restaurant = this.getRestaurant();
            Date date = IConfiguration.INSTANCE.getBusinessDay();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String path = String.valueOf(restaurant.getName()) + "/" + formatter.format(date);
            if (!this.view.hasResource(path)) {
                CDOTransaction transaction = this.session.openTransaction();
                Restaurant txRestaurant = (Restaurant)transaction.getObject((EObject)restaurant);
                EList menuCards = txRestaurant.getMenuCards();
                if (menuCards.isEmpty()) {
                    MenuCard menuCard = InventoryFactory.eINSTANCE.createMenuCard();
                    menuCard.setTitle("Untitled");
                    menuCards.add((Object)menuCard);
                }
                BusinessDay businessDay = BusinessFactory.eINSTANCE.createBusinessDay();
                businessDay.setDate(date);
                businessDay.setMenuCard((MenuCard)menuCards.get(0));
                try {
                    try {
                        CDOResource resource = transaction.createResource(path);
                        resource.getContents().add((Object)businessDay);
                        transaction.commit();
                    }
                    catch (CommitException ex) {
                        throw WrappedException.wrap((Exception)((Object)ex));
                    }
                }
                finally {
                    transaction.close();
                }
            }
            CDOResource resource = this.view.getResource(path);
            this.businessDay = (BusinessDay)resource.getContents().get(0);
        }
        return this.businessDay;
    }

    @Override
    public synchronized Station getStation() {
        if (this.station == null) {
            String id = IConfiguration.INSTANCE.getStation();
            for (Station station : this.getRestaurant().getStations()) {
                if (!station.getStationID().equalsIgnoreCase(id)) continue;
                this.station = station;
                break;
            }
        }
        return this.station;
    }

    @Override
    public <T extends CDOObject> Object modify(T object, IModel.ITransactionalOperation<T> operation) {
        try (CDOTransaction transaction = this.session.openTransaction();){
            CDOObject transactionalObject = (CDOObject)transaction.getObject(object);
            Object result = operation.execute(transactionalObject);
            transaction.commit();
            if (result instanceof CDOObject) {
                EObject eObject = this.view.getObject((EObject)((CDOObject)result));
                return eObject;
            }
            Object object2 = result;
            return object2;
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        String server = IConfiguration.INSTANCE.getServer();
        String repository = IConfiguration.INSTANCE.getRepository();
        IConnector connector = Net4jUtil.getConnector((IManagedContainer)IPluginContainer.INSTANCE, (String)"tcp", (String)server);
        CDONet4jSessionConfiguration config = CDONet4jUtil.createNet4jSessionConfiguration();
        config.setConnector(connector);
        config.setRepositoryName(repository);
        this.session = config.openNet4jSession();
        this.view = this.session.openView();
        this.view.options().addChangeSubscriptionPolicy(CDOAdapterPolicy.ALL);
    }

    protected void doDeactivate() throws Exception {
        this.session.close();
        this.session = null;
        this.view = null;
        this.restaurant = null;
        this.station = null;
        this.adapterFactory.dispose();
        super.doDeactivate();
    }
}

