/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.Delivery;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.IAssemblyManager;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.provider.LMEditPlugin;
import org.eclipse.emf.cdo.lm.ui.InteractiveDeliveryMerger;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.emf.cdo.lm.ui.widgets.BaselineComposite;
import org.eclipse.emf.cdo.lm.util.LMMerger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPage;

public class NewDeliveryAction
extends LMAction<Stream> {
    private static final LMMerger MERGER = new InteractiveDeliveryMerger();
    private boolean changeWasNull;
    private ISystemDescriptor systemDescriptor;
    private EList<Baseline> possibleChanges;
    private Change change;
    private IAssemblyDescriptor[] assemblyDescriptors = new IAssemblyDescriptor[0];
    private boolean deleteCheckouts;
    private Button deleteCheckoutsButton;

    public NewDeliveryAction(IWorkbenchPage page, Stream stream, Change change) {
        super(page, String.valueOf(change == null ? "New Delivery" : "Deliver to " + stream.getTypeAndName()) + INTERACTIVE, "Add a new delivery to stream '" + stream.getName() + "'", ExtendedImageRegistry.INSTANCE.getImageDescriptor(LMEditPlugin.INSTANCE.getImage("full/obj16/Delivery")), "Add a new delivery to stream '" + stream.getName() + "'.", "icons/NewDelivery.png", stream);
        this.change = change;
        this.changeWasNull = change == null;
    }

    @Override
    protected void preRun() throws Exception {
        Stream stream = (Stream)this.getContext();
        this.systemDescriptor = ISystemManager.INSTANCE.getDescriptor((EObject)stream.getSystem());
        this.possibleChanges = new BasicEList();
        if (this.changeWasNull) {
            stream.forEachBaseline(baseline -> {
                Change change;
                if (baseline instanceof Change && (change = (Change)baseline).getDeliveryPoint(stream) == null) {
                    this.possibleChanges.add((Object)change);
                }
            });
            this.possibleChanges.sort(Baseline.COMPARATOR);
        } else {
            this.possibleChanges.add((Object)this.change);
        }
        if (this.change == null && !this.possibleChanges.isEmpty()) {
            this.change = (Change)this.possibleChanges.get(0);
        }
        this.assemblyDescriptors = IAssemblyManager.INSTANCE.getDescriptors((Baseline)this.change);
        super.preRun();
    }

    @Override
    protected boolean isDialogNeeded() {
        return this.changeWasNull || this.assemblyDescriptors.length != 0;
    }

    @Override
    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        label.setText("Change:");
        BaselineComposite baselineComposite = new BaselineComposite(parent, 0, this.possibleChanges, this.getContext());
        baselineComposite.setLayoutData(GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        if (this.change != null) {
            baselineComposite.setBaseline((Baseline)this.change);
        }
        baselineComposite.addModifyListener((control, baseline) -> {
            this.change = (Change)baseline;
            this.assemblyDescriptors = IAssemblyManager.INSTANCE.getDescriptors((Baseline)this.change);
            this.deleteCheckoutsButton.setEnabled(this.assemblyDescriptors.length != 0);
            this.validateDialog();
        });
        if (!this.changeWasNull) {
            label.setEnabled(false);
            baselineComposite.setEnabled(false);
        }
        new Label(parent, 0);
        this.deleteCheckoutsButton = new Button(parent, 32);
        this.deleteCheckoutsButton.setText("Delete checkout(s)");
        this.deleteCheckoutsButton.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).create());
        this.deleteCheckoutsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.deleteCheckouts = this.deleteCheckoutsButton.getSelection();
            this.validateDialog();
        }));
        this.deleteCheckoutsButton.setSelection(this.deleteCheckouts);
        this.deleteCheckoutsButton.setEnabled(this.assemblyDescriptors.length != 0);
        if (!this.changeWasNull) {
            this.deleteCheckoutsButton.setFocus();
        }
    }

    @Override
    protected String doValidate(LMAction.LMDialog dialog) {
        if (this.change == null) {
            return "A change must be selected.";
        }
        return super.doValidate(dialog);
    }

    @Override
    protected void doRun(Stream stream, IProgressMonitor monitor) throws Exception {
        Delivery delivery = this.systemDescriptor.createDelivery(stream, this.change, MERGER, monitor);
        if (delivery != null && this.deleteCheckouts) {
            IAssemblyDescriptor[] iAssemblyDescriptorArray = this.assemblyDescriptors;
            int n = this.assemblyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                IAssemblyDescriptor assemblyDescriptor = iAssemblyDescriptorArray[n2];
                try {
                    CDOCheckout checkout = assemblyDescriptor.getCheckout();
                    checkout.delete(true);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
                ++n2;
            }
        }
    }
}

