/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.factory;

import java.text.MessageFormat;
import org.eclipse.net4j.util.factory.FactoryKey;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;
import org.eclipse.net4j.util.factory.IFactoryKeyAware;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.factory.ProductDescriptionProvider;

public abstract class Factory
implements IFactory,
IFactoryKeyAware {
    public static final String NO_DESCRIPTION = null;
    private IFactoryKey key;

    public Factory() {
        this((IFactoryKey)null);
    }

    public Factory(FactoryKey key) {
        this((IFactoryKey)key);
    }

    public Factory(IFactoryKey key) {
        this.key = key;
    }

    public Factory(String productGroup, String type) {
        this(new FactoryKey(productGroup, type));
    }

    public Factory(String productGroup) {
        this(productGroup, null);
    }

    public IFactoryKey getFactoryKey() {
        return this.key;
    }

    @Override
    public void setFactoryKey(IFactoryKey factoryKey) {
        this.key = factoryKey;
    }

    @Override
    public FactoryKey getKey() {
        if (this.key instanceof FactoryKey) {
            return (FactoryKey)this.key;
        }
        return new FactoryKey(this.key.getProductGroup(), this.key.getType());
    }

    public String getProductGroup() {
        return this.key.getProductGroup();
    }

    public String getType() {
        return this.key.getType();
    }

    @Override
    public String getDescriptionFor(Object product) {
        if (product instanceof ProductDescriptionProvider) {
            return ((ProductDescriptionProvider)product).getDescription();
        }
        return null;
    }

    protected final ProductCreationException productCreationException(String description, Throwable cause) {
        return new ProductCreationException(this.productCreationExceptionMessage(description), cause);
    }

    protected final ProductCreationException productCreationException(String description) {
        return new ProductCreationException(this.productCreationExceptionMessage(description));
    }

    private String productCreationExceptionMessage(String description) {
        return "Could not create product " + this.getKey() + " with " + description;
    }

    public String toString() {
        return MessageFormat.format("Factory[{0}, {1}]", this.getProductGroup(), this.getType());
    }
}

