/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.db.mapping.AbstractTypeMapping;
import org.eclipse.emf.cdo.server.db.mapping.AbstractTypeMappingFactory;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.TypeMappingUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.tests.AbstractCDOTest;
import org.eclipse.emf.cdo.tests.config.impl.Config;
import org.eclipse.emf.cdo.tests.db.verifier.DBStoreVerifier;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.IFactory;

public class CustomTypeMappingTest
extends AbstractCDOTest {
    public void testCustomTypeMapping() throws CommitException {
        MyIntToVarcharTypeMapping.Factory factory = new MyIntToVarcharTypeMapping.Factory();
        IPluginContainer.INSTANCE.registerFactory((IFactory)factory);
        try {
            final EPackage pkg = this.createUniquePackage();
            EClass foo = EMFUtil.createEClass((EPackage)pkg, (String)"foo", (boolean)false, (boolean)false);
            EAttribute bar = EMFUtil.createEAttribute((EClass)foo, (String)"bar", (EClassifier)EcorePackage.eINSTANCE.getEInt());
            EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource("http://www.eclipse.org/CDO/DBStore");
            annotation.getDetails().put((Object)"typeMapping", (Object)"org.eclipse.emf.cdo.tests.db.EIntToVarchar");
            annotation.getDetails().put((Object)"columnType", (Object)DBType.VARCHAR.getKeyword());
            bar.getEAnnotations().add((Object)annotation);
            if (!this.isConfig((Config)LEGACY)) {
                CDOUtil.prepareDynamicEPackage((EPackage)pkg);
            }
            CDOSession session = this.openSession();
            CDOTransaction transaction = session.openTransaction();
            CDOResource resource = transaction.createResource(this.getResourcePath("/test"));
            EObject obj = EcoreUtil.create((EClass)foo);
            obj.eSet((EStructuralFeature)bar, (Object)42);
            resource.getContents().add((Object)obj);
            transaction.commit();
            transaction.close();
            session.close();
            CustomTypeMappingTest.msg((Object)"Check if type was mapped to string...");
            new DBStoreVerifier((IRepository)this.getRepository()){

                @Override
                protected void doVerify() throws Exception {
                    Statement stmt = null;
                    ResultSet rset = null;
                    try {
                        stmt = this.getStatement();
                        rset = stmt.executeQuery("SELECT " + DBUtil.quoted((String)"bar") + " FROM " + DBUtil.quoted((String)(String.valueOf(pkg.getName()) + "_foo")));
                        1.assertEquals((Object)"java.lang.String", (Object)rset.getMetaData().getColumnClassName(1));
                        rset.next();
                        1.assertEquals((Object)"2a", (Object)rset.getString(1));
                    }
                    catch (Throwable throwable) {
                        DBUtil.close(rset);
                        DBUtil.close((Statement)stmt);
                        throw throwable;
                    }
                    DBUtil.close((ResultSet)rset);
                    DBUtil.close((Statement)stmt);
                }
            }.verify();
        }
        finally {
            IPluginContainer.INSTANCE.getFactoryRegistry().remove((Object)factory.getKey());
        }
    }

    public static class MyIntToVarcharTypeMapping
    extends AbstractTypeMapping {
        public static final ITypeMapping.Descriptor DESCRIPTOR = TypeMappingUtil.createDescriptor((String)"org.eclipse.emf.cdo.tests.db.EIntToVarchar", (EClassifier)EcorePackage.eINSTANCE.getEInt(), (DBType)DBType.VARCHAR);

        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            Integer val = (Integer)value;
            stmt.setString(index, Integer.toHexString(val));
        }

        protected Object getResultSetValue(ResultSet resultSet) throws SQLException {
            String stringVal = resultSet.getString(this.getField().getName());
            return Integer.parseInt(stringVal, 16);
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory() {
                super(DESCRIPTOR);
            }

            public ITypeMapping create(String description) {
                return new MyIntToVarcharTypeMapping();
            }
        }
    }
}

