/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.releng.apireports;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.releng.apireports.Activator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.comparator.Delta;
import org.eclipse.pde.api.tools.internal.comparator.DeltaXmlVisitor;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiScope;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiScope;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ApiReportsGenerator {
    private ApiReportsGenerator() {
    }

    /*
     * Loose catch block
     */
    public static IStatus generate(String reportFileName, String baselineName, String exclusionPatterns, IProgressMonitor monitor) {
        if (baselineName == null || baselineName.length() == 0) {
            IApiBaseline baseline = ApiBaselineManager.getManager().getDefaultApiBaseline();
            if (baseline != null) {
                baselineName = baseline.getName();
            }
            if (baselineName == null || baselineName.length() == 0) {
                return Activator.errorStatus("Baseline name not specified");
            }
        }
        if (reportFileName == null || reportFileName.length() == 0) {
            reportFileName = System.getProperty("api.report", new File("api.xml").getAbsolutePath());
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.subTask("Collecting elements to compare");
        try {
            block41: {
                IApiBaseline baseline;
                IApiScope scope;
                BufferedWriter writer;
                block39: {
                    IStatus iStatus;
                    block40: {
                        File reportFile;
                        block37: {
                            IStatus iStatus2;
                            block38: {
                                progress.subTask("Computing deltas...");
                                reportFile = new File(reportFileName);
                                progress.worked(25);
                                ApiReportsGenerator.updateMonitor((IProgressMonitor)progress);
                                writer = null;
                                if (reportFile.exists()) {
                                    reportFile.delete();
                                    break block37;
                                }
                                File parent = reportFile.getParentFile();
                                if (parent.exists() || parent.mkdirs()) break block37;
                                iStatus2 = Activator.errorStatus("Failed to create report directory structure");
                                if (writer == null) break block38;
                                try {
                                    writer.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return iStatus2;
                        }
                        writer = new BufferedWriter(new FileWriter(reportFile));
                        List<Object> projects = ApiReportsGenerator.collectProjects(exclusionPatterns);
                        scope = ApiReportsGenerator.walkStructureSelection(projects, monitor);
                        baseline = ApiBaselineManager.getManager().getApiBaseline(baselineName);
                        if (baseline != null) break block39;
                        iStatus = Activator.errorStatus("Baseline not found: " + baselineName);
                        if (writer == null) break block40;
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return iStatus;
                }
                IDelta delta = ApiComparator.compare((IApiScope)scope, (IApiBaseline)baseline, (int)1, (boolean)false, (boolean)true, (IProgressMonitor)monitor);
                if (delta != null) {
                    ApiReportsGenerator.sortDelta(delta);
                    progress.worked(25);
                    ApiReportsGenerator.updateMonitor((IProgressMonitor)progress);
                    ApiDeltaVisitor visitor = new ApiDeltaVisitor();
                    delta.accept((DeltaVisitor)visitor);
                    Document document = visitor.getDocument();
                    String xml = Util.serializeDocument((Document)document);
                    writer.write(xml);
                    writer.flush();
                    progress.worked(25);
                }
                {
                    catch (CoreException e) {
                        Activator.log(e.getStatus());
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block41;
                    }
                    catch (Throwable e) {
                        try {
                            Activator.log(e);
                            break block41;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (writer != null) {
                                try {
                                    writer.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                }
                if (writer == null) break block41;
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            progress.worked(25);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
            catch (OperationCanceledException operationCanceledException) {
            }
        }
        finally {
            monitor.done();
        }
        return Status.CANCEL_STATUS;
    }

    private static List<Object> collectProjects(String exclusionPatterns) {
        Pattern[] patterns = new Pattern[]{};
        if (exclusionPatterns != null) {
            String[] split = exclusionPatterns.split(",");
            patterns = new Pattern[split.length];
            int i = 0;
            while (i < split.length) {
                patterns[i] = Pattern.compile(split[i].trim());
                ++i;
            }
        }
        ArrayList<Object> result = new ArrayList<Object>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject;
            String name;
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && ApiReportsGenerator.isAPI(project) && !ApiReportsGenerator.isExcluded(patterns, name = project.getName()) && (javaProject = JavaCore.create((IProject)project)) != null) {
                result.add(javaProject);
                Activator.log(Status.info((String)("API report project: " + name)));
            }
            ++n2;
        }
        return result;
    }

    private static boolean isAPI(IProject project) {
        try {
            return project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature");
        }
        catch (CoreException ex) {
            return false;
        }
    }

    private static boolean isExcluded(Pattern[] patterns, String name) {
        Pattern[] patternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            Matcher matcher = pattern.matcher(name);
            if (matcher.matches()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IApiScope walkStructureSelection(List<Object> projects, IProgressMonitor monitor) {
        ApiScope scope = new ApiScope();
        IApiBaseline workspaceBaseline = ApiBaselineManager.getManager().getWorkspaceBaseline();
        if (workspaceBaseline == null) {
            return scope;
        }
        Collections.sort(projects, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof IJavaElement && o2 instanceof IJavaElement) {
                    IJavaElement element = (IJavaElement)o1;
                    IJavaElement element2 = (IJavaElement)o2;
                    return element.getElementType() - element2.getElementType();
                }
                return 0;
            }
        });
        block9: for (Object project : projects) {
            if (!(project instanceof IJavaElement)) continue;
            IJavaElement element = (IJavaElement)project;
            IJavaProject javaProject = element.getJavaProject();
            try {
                switch (element.getElementType()) {
                    case 5: {
                        ICompilationUnit compilationUnit = (ICompilationUnit)element;
                        IApiComponent apiComponent = workspaceBaseline.getApiComponent(javaProject.getElementName());
                        if (apiComponent == null) continue block9;
                        ApiReportsGenerator.addElementFor(compilationUnit, apiComponent, scope);
                        break;
                    }
                    case 4: {
                        IPackageFragment fragment = (IPackageFragment)element;
                        IApiComponent apiComponent = workspaceBaseline.getApiComponent(javaProject.getElementName());
                        IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)fragment.getAncestor(3);
                        boolean isArchive = false;
                        if (packageFragmentRoot != null) {
                            isArchive = packageFragmentRoot.isArchive();
                        }
                        if (apiComponent == null) continue block9;
                        ApiReportsGenerator.addElementFor(fragment, isArchive, apiComponent, scope);
                        break;
                    }
                    case 3: {
                        IPackageFragmentRoot fragmentRoot = (IPackageFragmentRoot)element;
                        IApiComponent apiComponent = workspaceBaseline.getApiComponent(javaProject.getElementName());
                        if (apiComponent == null) continue block9;
                        ApiReportsGenerator.addElementFor(fragmentRoot, apiComponent, scope);
                        break;
                    }
                    case 2: {
                        IApiComponent apiComponent = workspaceBaseline.getApiComponent(javaProject.getElementName());
                        if (apiComponent == null) continue block9;
                        scope.addElement((IApiElement)apiComponent);
                    }
                }
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
            catch (Throwable e) {
                Activator.log(e);
            }
        }
        return scope;
    }

    private static void addElementFor(IPackageFragmentRoot fragmentRoot, IApiComponent apiComponent, ApiScope scope) throws JavaModelException, CoreException {
        boolean isArchive = fragmentRoot.isArchive();
        IJavaElement[] packageFragments = fragmentRoot.getChildren();
        int j = 0;
        int max2 = packageFragments.length;
        while (j < max2) {
            IPackageFragment packageFragment = (IPackageFragment)packageFragments[j];
            ApiReportsGenerator.addElementFor(packageFragment, isArchive, apiComponent, scope);
            ++j;
        }
    }

    private static void addElementFor(IPackageFragment packageFragment, boolean isArchive, IApiComponent apiComponent, ApiScope scope) throws JavaModelException, CoreException {
        IApiDescription apiDescription = apiComponent.getApiDescription();
        IApiAnnotations annotations = apiDescription.resolveAnnotations((IElementDescriptor)Factory.packageDescriptor((String)packageFragment.getElementName()));
        if (annotations == null || !VisibilityModifiers.isAPI((int)annotations.getVisibility())) {
            return;
        }
        if (isArchive) {
            IOrdinaryClassFile[] classFiles = packageFragment.getOrdinaryClassFiles();
            int i = 0;
            int max = classFiles.length;
            while (i < max) {
                ApiReportsGenerator.addElementFor(classFiles[i], apiComponent, scope);
                ++i;
            }
        } else {
            ICompilationUnit[] units = packageFragment.getCompilationUnits();
            int i = 0;
            int max = units.length;
            while (i < max) {
                ApiReportsGenerator.addElementFor(units[i], apiComponent, scope);
                ++i;
            }
        }
    }

    private static void addElementFor(IOrdinaryClassFile classFile, IApiComponent apiComponent, ApiScope scope) {
        try {
            IApiTypeRoot typeRoot = apiComponent.findTypeRoot(classFile.getType().getFullyQualifiedName());
            if (typeRoot != null) {
                scope.addElement((IApiElement)typeRoot);
            }
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
        catch (Throwable e) {
            Activator.log(e);
        }
    }

    private static void addElementFor(ICompilationUnit compilationUnit, IApiComponent component, ApiScope scope) throws JavaModelException {
        IType[] types = compilationUnit.getTypes();
        int i = 0;
        int max = types.length;
        while (i < max) {
            try {
                IApiTypeRoot typeRoot = component.findTypeRoot(types[i].getFullyQualifiedName());
                if (typeRoot != null) {
                    scope.addElement((IApiElement)typeRoot);
                }
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
            catch (Throwable e) {
                Activator.log(e);
            }
            ++i;
        }
    }

    private static void sortDelta(IDelta delta) {
        try {
            int deltasCounter = (Integer)ApiReportsGenerator.reflect(delta, "deltasCounter");
            if (deltasCounter > 0) {
                IDelta[] children = (IDelta[])ApiReportsGenerator.reflect(delta, "children");
                Arrays.sort(children, 0, deltasCounter, Comparator.comparing(IDelta::getMessage));
            }
        }
        catch (Throwable e) {
            Activator.log(e);
        }
    }

    private static <T> T reflect(IDelta delta, String fieldName) throws Exception {
        Field f = Delta.class.getDeclaredField(fieldName);
        f.setAccessible(true);
        return (T)f.get(delta);
    }

    private static void updateMonitor(IProgressMonitor monitor, int work) throws OperationCanceledException {
        if (monitor == null) {
            return;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.worked(work);
    }

    private static void updateMonitor(IProgressMonitor monitor) throws OperationCanceledException {
        ApiReportsGenerator.updateMonitor(monitor, 0);
    }

    private static final class ApiDeltaVisitor
    extends DeltaXmlVisitor {
        protected void processLeafDelta(IDelta delta) {
            super.processLeafDelta(delta);
            if (delta.getElementType() != 2) {
                String[] arguments;
                Element deltasElement = (Element)this.getDocument().getFirstChild();
                Element deltaElement = (Element)deltasElement.getLastChild();
                String message = delta.getMessage();
                if (message != null && (message.startsWith("The deprecation modifiers has") || message.startsWith("The deprecation modifier has")) && (arguments = delta.getArguments()) != null && arguments.length >= 2) {
                    message = String.valueOf(message) + "." + arguments[1];
                    deltaElement.setAttribute("message", message);
                }
            }
        }
    }
}

