/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.internal.client;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRef;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.lm.assembly.Assembly;
import org.eclipse.emf.cdo.lm.assembly.AssemblyModule;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.impl.SystemImpl;
import org.eclipse.emf.cdo.lm.internal.client.SystemDescriptor;
import org.eclipse.emf.cdo.lm.internal.client.bundle.OM;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.AbstractCDOViewProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.registry.IRegistry;

public class LMViewProvider
extends AbstractCDOViewProvider {
    public static final String SCHEME = "cdo.lm";
    private static final String PARAM_BRANCH = "branch";
    private static final String PARAM_TIME_STAMP = "timeStamp";

    public LMViewProvider() {
        this(500);
    }

    public LMViewProvider(int priority) {
        super(LMViewProvider.schemeRegex((String)SCHEME), priority);
    }

    public CDOView getView(URI uri, ResourceSet resourceSet) {
        LMViewProviderAdapter adapter = LMViewProviderAdapter.get(resourceSet);
        if (adapter == null) {
            adapter = LMViewProviderAdapter.create(resourceSet);
        }
        return adapter.getView(uri);
    }

    public URI getResourceURI(CDOView view, String path) {
        CDOSession session = view.getSession();
        IRegistry properties = session.properties();
        ISystemDescriptor systemDescriptor = (ISystemDescriptor)properties.get((Object)SystemDescriptor.KEY_SYSTEM_DESCRIPTOR);
        String moduleName = (String)properties.get((Object)"org.eclipse.emf.cdo.lm.client.ModuleName");
        String systemName = systemDescriptor.getSystemName();
        String authority = LMViewProvider.createAuthority(systemName, moduleName);
        String[] segments = StringUtil.isEmpty((String)path) ? null : new Path(path).segments();
        return URI.createHierarchicalURI((String)SCHEME, (String)authority, null, (String[])segments, null, null);
    }

    public URI getViewURI(URI uri) {
        if (uri == null) {
            return null;
        }
        String scheme = uri.scheme();
        if (!SCHEME.equals(scheme)) {
            return null;
        }
        return super.getViewURI(uri);
    }

    public static URI createViewURI(AssemblyModule module) {
        Assembly assembly = module.getAssembly();
        String systemName = assembly.getSystemName();
        String moduleName = module.getName();
        String authority = LMViewProvider.createAuthority(systemName, moduleName);
        CDOBranchPointRef branchPoint = module.getBranchPoint();
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put(PARAM_BRANCH, branchPoint.getBranchPath());
        parameters.put(PARAM_TIME_STAMP, branchPoint.getTimeStampSpec());
        String query = CDOURIUtil.formatQuery(parameters);
        return URI.createHierarchicalURI((String)SCHEME, (String)authority, null, (String)query, null);
    }

    private static String createAuthority(String systemName, String moduleName) {
        return URI.encodeAuthority((String)(String.valueOf(systemName) + ":" + moduleName), (boolean)false);
    }

    private static CDOView openView(ResourceSet resourceSet, URI uri) {
        final CDORepository moduleRepository = LMViewProvider.getModuleRepository(uri);
        CDOSession session = moduleRepository.acquireSession();
        CDOBranchPoint branchPoint = LMViewProvider.getBranchPoint(uri, session);
        InternalCDOView view = (InternalCDOView)session.openView(branchPoint, resourceSet);
        view.setRepositoryName(moduleRepository.getName());
        view.addListener((IListener)new LifecycleEventAdapter(){

            protected void onDeactivated(ILifecycle lifecycle) {
                moduleRepository.releaseSession();
            }
        });
        return view;
    }

    private static CDORepository getModuleRepository(URI uri) {
        int colon;
        String authority;
        if (SCHEME.equals(uri.scheme()) && (authority = URI.decode((String)uri.authority())) != null && (colon = authority.indexOf(":")) != -1) {
            ISystemDescriptor systemDescriptor;
            String systemName = authority.substring(0, colon);
            String moduleName = authority.substring(colon + 1);
            if (SystemImpl.isValidName((String)systemName) && SystemImpl.isValidName((String)moduleName) && (systemDescriptor = ISystemManager.INSTANCE.getDescriptor(systemName)) != null) {
                return systemDescriptor.getModuleRepository(moduleName);
            }
        }
        return null;
    }

    private static CDOBranchPoint getBranchPoint(URI uri, CDOSession session) {
        Map parameters = CDOURIUtil.getParameters((String)uri.query());
        String branchPath = (String)parameters.get(PARAM_BRANCH);
        CDOBranch branch = session.getBranchManager().getBranch(branchPath);
        String timeSpec = (String)parameters.get(PARAM_TIME_STAMP);
        boolean timeUnspecified = StringUtil.isEmpty((String)timeSpec) || "*".equals(timeSpec);
        long timeStamp = timeUnspecified ? 0L : Long.parseLong(timeSpec);
        return branch.getPoint(timeStamp);
    }

    private static final class LMViewProviderAdapter
    extends AdapterImpl {
        private final Map<URI, CDOView> views = new HashMap<URI, CDOView>();

        private LMViewProviderAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOView getView(final URI uri) {
            Map<URI, CDOView> map = this.views;
            synchronized (map) {
                CDOView view = this.views.get(uri);
                if (view == null) {
                    ResourceSet resourceSet = this.getTarget();
                    CDOViewSet viewSet = CDOUtil.getViewSet((Notifier)resourceSet);
                    if (viewSet != null) {
                        CDOView[] cDOViewArray = viewSet.getViews();
                        int n = cDOViewArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CDOView viewSetView = cDOViewArray[n2];
                            if (uri == viewSetView.getURI()) {
                                view = viewSetView;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (view == null) {
                        view = LMViewProvider.openView(resourceSet, uri);
                    }
                    if (view != null) {
                        this.views.put(uri, view);
                        view.addListener((IListener)new LifecycleEventAdapter(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            protected void onDeactivated(ILifecycle lifecycle) {
                                Map<URI, CDOView> map = views;
                                synchronized (map) {
                                    views.remove(uri);
                                }
                            }
                        });
                    }
                }
                return view;
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == LMViewProviderAdapter.class;
        }

        public ResourceSet getTarget() {
            return (ResourceSet)super.getTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTarget(Notifier newTarget) {
            ResourceSet resourceSet = this.getTarget();
            if (newTarget == resourceSet) {
                return;
            }
            if (newTarget == null) {
                CDOView[] array;
                Map<URI, CDOView> map = this.views;
                synchronized (map) {
                    array = this.views.values().toArray(new CDOView[this.views.size()]);
                    this.views.clear();
                }
                CDOView[] cDOViewArray = array;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOView view = cDOViewArray[n2];
                    try {
                        view.close();
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                    ++n2;
                }
            } else if (resourceSet != null) {
                throw new IllegalStateException("Illegal attempt to retarget LMViewProviderAdapter to " + newTarget);
            }
            super.setTarget(newTarget);
        }

        public static LMViewProviderAdapter get(ResourceSet resourceSet) {
            EList adapters = resourceSet.eAdapters();
            LMViewProviderAdapter adapter = (LMViewProviderAdapter)EcoreUtil.getAdapter((List)adapters, LMViewProviderAdapter.class);
            if (adapter != null && adapter.getTarget() != resourceSet) {
                adapters.remove((Object)adapter);
                adapter = null;
            }
            return adapter;
        }

        public static LMViewProviderAdapter create(ResourceSet resourceSet) {
            LMViewProviderAdapter adapter = new LMViewProviderAdapter();
            resourceSet.eAdapters().add((Object)adapter);
            return adapter;
        }
    }
}

