/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.etypes.ModelElement;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.reviews.Comment;
import org.eclipse.emf.cdo.lm.reviews.CommentStatus;
import org.eclipse.emf.cdo.lm.reviews.Commentable;
import org.eclipse.emf.cdo.lm.reviews.ReviewsFactory;
import org.eclipse.emf.cdo.lm.reviews.provider.ReviewsEditPlugin;
import org.eclipse.emf.cdo.lm.reviews.ui.bundle.OM;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class NewCommentAction
extends LMAction.NewElement<Commentable> {
    private final boolean heading;
    private String text;
    private CommentStatus status = CommentStatus.NONE;

    public NewCommentAction(IWorkbenchPage page, StructuredViewer viewer, Commentable commentable, boolean heading) {
        super(page, viewer, "New " + NewCommentAction.getTypeString(heading) + INTERACTIVE, "Add a new " + NewCommentAction.getTypeString(heading).toLowerCase(), ExtendedImageRegistry.INSTANCE.getImageDescriptor(ReviewsEditPlugin.INSTANCE.getImage("full/obj16/" + NewCommentAction.getTypeString(heading))), "Add a new " + NewCommentAction.getTypeString(heading).toLowerCase() + ".", "icons/wizban/New" + NewCommentAction.getTypeString(heading) + ".png", (CDOObject)commentable);
        this.heading = heading;
    }

    protected ImageDescriptor getImageDescriptor(String imagePath) {
        return OM.getImageDescriptor(imagePath);
    }

    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        label.setText("Text:");
        int style = 2048;
        if (!this.heading) {
            style |= 2;
        }
        Text textArea = new Text(parent, style);
        textArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, !this.heading).align(4, 4).create());
        textArea.addModifyListener(event -> {
            this.text = textArea.getText();
            this.validateDialog();
        });
        final Button button = this.newCheckBox(parent, "Needs Resolution");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewCommentAction.this.status = button.getSelection() ? CommentStatus.UNRESOLVED : CommentStatus.NONE;
                NewCommentAction.this.validateDialog();
            }
        });
    }

    protected String doValidate(LMAction.LMDialog dialog) {
        if (StringUtil.isEmpty((String)this.text)) {
            return "A text must be entered.";
        }
        return super.doValidate(dialog);
    }

    protected CDOObject newElement(Commentable commentable, IProgressMonitor monitor) throws Exception {
        ISystemDescriptor systemDescriptor = ISystemManager.INSTANCE.getDescriptor((EObject)commentable);
        String author = systemDescriptor.getSystemRepository().getCredentials().getUserID();
        Comment comment = this.createComment();
        comment.setAuthor(author);
        comment.setText(this.text);
        comment.setStatus(this.status);
        return (CDOObject)systemDescriptor.modify((ModelElement)commentable, c -> {
            c.getComments().add((Object)comment);
            return comment;
        }, monitor);
    }

    private Comment createComment() {
        if (this.heading) {
            return ReviewsFactory.eINSTANCE.createHeading();
        }
        return ReviewsFactory.eINSTANCE.createComment();
    }

    private static String getTypeString(boolean heading) {
        return heading ? "Heading" : "Comment";
    }
}

