/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.ws;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.net4j.ILocationAware;
import org.eclipse.net4j.internal.ws.WSConnector;
import org.eclipse.net4j.ws.jetty.Net4jWebSocket;

public class WSClientConnector
extends WSConnector {
    private WebSocketClient client;
    private boolean ownedClient;
    private long connectTimeout = 5000L;
    private String url;
    private URI serviceURI;
    private String acceptorName;

    public ILocationAware.Location getLocation() {
        return ILocationAware.Location.CLIENT;
    }

    public WebSocketClient getClient() {
        return this.client;
    }

    public void setClient(WebSocketClient client) {
        this.checkInactive();
        this.client = client;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.checkInactive();
        this.connectTimeout = connectTimeout;
    }

    @Override
    public URI getServiceURI() {
        return this.serviceURI;
    }

    @Override
    public String getAcceptorName() {
        return this.acceptorName;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) throws URISyntaxException {
        this.checkInactive();
        this.url = url;
        URI uri = new URI(url);
        Path path = new Path(uri.getPath());
        int index = this.getAcceptorSegmentIndex((IPath)path);
        if (index == -1) {
            throw new URISyntaxException(url, "Acceptor name prefix '@' not found");
        }
        String serviceURIString = uri.getScheme() + "://" + uri.getAuthority();
        int i = 0;
        while (i < index) {
            serviceURIString = serviceURIString + "/" + path.segment(i);
            ++i;
        }
        this.serviceURI = new URI(serviceURIString);
        this.acceptorName = path.segment(index).substring("@".length());
    }

    public String toString() {
        return MessageFormat.format("WSClientConnector[{0}]", this.getURL());
    }

    protected int getAcceptorSegmentIndex(IPath path) {
        int i = 0;
        while (i < path.segmentCount()) {
            if (path.segment(i).startsWith("@")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void doBeforeActivate() throws Exception {
        if (this.client == null) {
            this.client = new WebSocketClient();
            this.ownedClient = true;
        }
        super.doBeforeActivate();
        if (this.serviceURI == null) {
            throw new IllegalStateException("serviceURI is null");
        }
        if (this.acceptorName == null || this.acceptorName.length() == 0) {
            throw new IllegalStateException("acceptorName is null or empty");
        }
    }

    protected void doActivate() throws Exception {
        if (this.ownedClient) {
            this.client.start();
        }
        super.doActivate();
        Net4jWebSocket webSocket = new Net4jWebSocket(this);
        this.setWebSocket(webSocket);
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setHeader("Net4jAcceptor", this.acceptorName);
        CompletableFuture result = this.client.connect((Object)webSocket, this.serviceURI, request);
        result.get(this.connectTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void doDeactivate() throws Exception {
        super.doDeactivate();
        if (this.ownedClient) {
            this.client.stop();
            this.client = null;
        }
    }
}

