/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Hashtable;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class TableNameInfo {
    private DataDictionary dd;
    private Hashtable<Long, ConglomerateDescriptor> ddCache;
    private Hashtable<UUID, TableDescriptor> tdCache;
    private Hashtable<Long, TableDescriptor> tableCache = new Hashtable(31);
    private Hashtable<Long, String> indexCache;

    public TableNameInfo(LanguageConnectionContext lcc, boolean andIndex) throws StandardException {
        if (andIndex) {
            this.indexCache = new Hashtable(13);
        }
        TransactionController tc = lcc.getTransactionExecute();
        this.dd = lcc.getDataDictionary();
        this.ddCache = this.dd.hashAllConglomerateDescriptorsByNumber(tc);
        this.tdCache = this.dd.hashAllTableDescriptorsByTableId(tc);
    }

    public String getTableName(Long conglomId) {
        if (conglomId == null) {
            return "?";
        }
        TableDescriptor td = this.tableCache.get(conglomId);
        if (td == null) {
            ConglomerateDescriptor cd = this.ddCache.get(conglomId);
            if (cd != null) {
                td = this.tdCache.get(cd.getTableID());
            }
            if (cd == null || td == null) {
                Object name;
                if (conglomId > 20L) {
                    name = "*** TRANSIENT_" + conglomId;
                } else {
                    switch (conglomId.intValue()) {
                        case 0: {
                            name = "*** INVALID CONGLOMERATE ***";
                            break;
                        }
                        case 1: {
                            name = "ConglomerateDirectory";
                            break;
                        }
                        case 2: {
                            name = "PropertyConglomerate";
                            break;
                        }
                        default: {
                            name = "*** INTERNAL TABLE " + conglomId;
                        }
                    }
                }
                return name;
            }
            this.tableCache.put(conglomId, td);
            if (this.indexCache != null && cd.isIndex()) {
                this.indexCache.put(conglomId, cd.getConglomerateName());
            }
        }
        return td.getName();
    }

    public String getTableType(Long conglomId) {
        String type;
        if (conglomId == null) {
            return "?";
        }
        TableDescriptor td = this.tableCache.get(conglomId);
        if (td != null) {
            switch (td.getTableType()) {
                case 0: {
                    type = "T";
                    break;
                }
                case 1: {
                    type = "S";
                    break;
                }
                default: {
                    SanityManager.THROWASSERT("Illegal table type " + td.getName() + " " + td.getTableType());
                    type = "?";
                    break;
                }
            }
        } else {
            type = conglomId > 20L ? "T" : "S";
        }
        return type;
    }

    public String getIndexName(Long conglomId) {
        if (conglomId == null) {
            return "?";
        }
        return this.indexCache.get(conglomId);
    }
}

