/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.lm.LMFactory;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.ModuleType;
import org.eclipse.emf.cdo.lm.Process;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.provider.LMEditPlugin;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.cdo.lm.ui.actions.NewStreamAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class NewModuleAction
extends LMAction.NewElement<System> {
    private static final ModuleType NO_MODULE_TYPE = LMFactory.eINSTANCE.createModuleType("");
    private ISystemDescriptor systemDescriptor;
    private String name;
    private ModuleType type;
    private NewStreamAction.CommonStreamParameters<System> streamParameters;

    public NewModuleAction(IWorkbenchPage page, TreeViewer viewer, System system) {
        super(page, (StructuredViewer)viewer, "New Module" + INTERACTIVE, "Add a new module to system '" + system.getName() + "'", ExtendedImageRegistry.INSTANCE.getImageDescriptor(LMEditPlugin.INSTANCE.getImage("full/obj16/Module")), "Add a new module to system '" + system.getName() + "'.", "icons/NewModule.png", system);
    }

    @Override
    protected void preRun() throws Exception {
        System system = (System)this.getContext();
        this.systemDescriptor = ISystemManager.INSTANCE.getDescriptor((EObject)system);
        Process process = system.getProcess();
        Version initialModuleVersion = process.getInitialModuleVersion();
        this.streamParameters = initialModuleVersion == null ? new NewStreamAction.CommonStreamParameters<System>(this, 0, 1) : new NewStreamAction.CommonStreamParameters<System>(this, (Integer)initialModuleVersion.getSegment(0), (Integer)initialModuleVersion.getSegment(1));
        super.preRun();
    }

    @Override
    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        label.setText("Name:");
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        text.addModifyListener(e -> {
            this.name = text.getText();
            this.validateDialog();
        });
        Object moduleTypes = this.systemDescriptor.getSystem().getProcess().getModuleTypes();
        if (!moduleTypes.isEmpty()) {
            moduleTypes = new ArrayList(moduleTypes);
            moduleTypes.add(NO_MODULE_TYPE);
            Label label2 = new Label(parent, 0);
            label2.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
            label2.setText("Type:");
            ComboViewer comboViewer = new ComboViewer(parent, 8);
            comboViewer.setLabelProvider((IBaseLabelProvider)new ModuleTypeLabelProvider());
            comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            comboViewer.setInput(moduleTypes);
            comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object selection = event.getStructuredSelection().getFirstElement();
                    NewModuleAction.this.type = selection == NO_MODULE_TYPE ? null : (ModuleType)selection;
                    NewModuleAction.this.validateDialog();
                }
            });
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).create());
        Label separator1 = new Label(composite, 258);
        separator1.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        Label label3 = new Label(composite, 0);
        label3.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        label3.setText("Initial Stream");
        Label separator2 = new Label(composite, 258);
        separator2.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        this.streamParameters.fillDialogArea(parent);
    }

    @Override
    protected String doValidate(LMAction.LMDialog dialog) {
        if (this.name == null || this.name.isEmpty()) {
            return "A valid name must be entered.";
        }
        String result = this.streamParameters.validate();
        if (result != null) {
            return result;
        }
        return super.doValidate(dialog);
    }

    @Override
    protected CDOObject newElement(System system, IProgressMonitor monitor) throws Exception {
        Module module = this.systemDescriptor.createModule(this.name, this.type, this.streamParameters, monitor);
        return (CDOObject)module.getStreams().get(0);
    }

    private static final class ModuleTypeLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof ModuleType) {
                ModuleType type = (ModuleType)element;
                return type.getName();
            }
            return super.getText(element);
        }
    }
}

