/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.lm.reviews.Comment;
import org.eclipse.emf.cdo.lm.reviews.CommentStatus;
import org.eclipse.emf.cdo.lm.reviews.Commentable;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.cdo.lm.reviews.provider.CommentableItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class CommentItemProvider
extends CommentableItemProvider {
    private static final StyledString.Style STYLE_UNRESOLVED = StyledString.Style.newBuilder().setForegroundColor(URI.createURI((String)"color://rgb/220/40/40")).toStyle();
    private static final StyledString.Style STYLE_RESOLVED = StyledString.Style.newBuilder().setForegroundColor(URI.createURI((String)"color://rgb/20/180/20")).toStyle();
    private ItemPropertyDescriptor statusPropertyDescriptor;

    public CommentItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addParentHeadingPropertyDescriptor(object);
            this.addAuthorPropertyDescriptor(object);
            this.addTextPropertyDescriptor(object);
            this.addStatusPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addParentHeadingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Comment_parentHeading_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Comment_parentHeading_feature", "_UI_Comment_type"), (EStructuralFeature)ReviewsPackage.Literals.COMMENT__PARENT_HEADING, false, false, false, null, null, null));
    }

    protected void addAuthorPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Comment_author_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Comment_author_feature", "_UI_Comment_type"), (EStructuralFeature)ReviewsPackage.Literals.COMMENT__AUTHOR, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addTextPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Comment_text_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Comment_text_feature", "_UI_Comment_type"), (EStructuralFeature)ReviewsPackage.Literals.COMMENT__TEXT, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addStatusPropertyDescriptor(Object object) {
        this.statusPropertyDescriptor = this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Comment_status_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Comment_status_feature", "_UI_Comment_type"), (EStructuralFeature)ReviewsPackage.Literals.COMMENT__STATUS, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null);
        this.itemPropertyDescriptors.add(this.statusPropertyDescriptor);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Comment"));
    }

    protected Object overlayImage(Object object, Object image) {
        image = super.overlayImage(object, image);
        return CommentableItemProvider.overlayCommentableImage((Commentable)((Comment)object), image);
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        return ((StyledString)this.getStyledText(object)).getString();
    }

    @Override
    public Object getStyledText(Object object) {
        Comment comment = (Comment)object;
        StyledString styledString = new StyledString(this.getTypeString(), StyledString.Style.QUALIFIER_STYLER).append(" ").append(this.getTextString(comment));
        StyledString.Style style = null;
        CommentStatus status = comment.getStatus();
        if (status == CommentStatus.UNRESOLVED) {
            style = STYLE_UNRESOLVED;
        } else if (status == CommentStatus.RESOLVED) {
            style = STYLE_RESOLVED;
        }
        if (style != null) {
            this.getPropertyDescriptors(comment);
            String statusLabel = this.statusPropertyDescriptor.getLabelProvider((Object)comment).getText((Object)status);
            styledString.append("  ").append("[" + statusLabel + "]", style);
        }
        return styledString;
    }

    protected String getTypeString() {
        return this.getString("_UI_Comment_type");
    }

    protected String getTextString(Comment comment) {
        return comment.getText();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        Object notifier = notification.getNotifier();
        switch (notification.getFeatureID(Comment.class)) {
            case 9: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notifier, false, true));
                return;
            }
            case 10: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notifier, false, true));
                CommentableItemProvider.propagateNotification((ItemProviderAdapter)this, notification, notifier);
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

