/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.internal.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRef;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.explorer.CDOExplorerElement;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckoutManager;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutImpl;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.ModuleType;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.assembly.Assembly;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.IAssemblyManager;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.internal.client.AssemblyDescriptor;
import org.eclipse.emf.cdo.lm.internal.client.LMManager;
import org.eclipse.emf.cdo.lm.internal.client.SystemDescriptor;
import org.eclipse.emf.cdo.lm.internal.client.bundle.OM;
import org.eclipse.emf.cdo.lm.modules.ModuleDefinition;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.concurrent.TaskQueue;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public final class AssemblyManager
extends LMManager<CDOCheckout, CDOCheckoutManager, IAssemblyDescriptor>
implements IAssemblyManager {
    public static final AssemblyManager INSTANCE = new AssemblyManager();
    private static final String ASSEMBLY_FILE_NAME = "module.assembly";
    private static final String ASSEMBLY_UPDATE_FILE_NAME = "update.assembly";
    private static final String ERRORS_FILE_NAME = "resolution.errors";
    private static final String RESOLUTION_ERROR = "Module definition could not be resolved";
    private static final ThreadLocal<Boolean> CREATING_DESCRIPTOR = new ThreadLocal();
    private final IListener systemManagerListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof ISystemManager.BaselineCreatedEvent) {
                ISystemManager.BaselineCreatedEvent e = (ISystemManager.BaselineCreatedEvent)event;
                ISystemDescriptor systemDescriptor = e.getSystemDescriptor();
                ObjectUtil.forEachSafe((Object[])((IAssemblyDescriptor[])AssemblyManager.this.getDescriptors()), assemblyDescriptor -> {
                    if (assemblyDescriptor.getSystemDescriptor() == systemDescriptor) {
                        ((AssemblyDescriptor)assemblyDescriptor).baselineAdded(e.getNewBaseline());
                    }
                });
            } else if (event instanceof ISystemManager.StreamBranchChangedEvent) {
                ISystemManager.StreamBranchChangedEvent e = (ISystemManager.StreamBranchChangedEvent)event;
                Stream stream = e.getStream();
                ObjectUtil.forEachSafe((Object[])((IAssemblyDescriptor[])AssemblyManager.this.getDescriptors()), assemblyDescriptor -> {
                    Baseline baseline = assemblyDescriptor.getBaseline();
                    if (baseline == stream) {
                        CDOCheckout checkout = assemblyDescriptor.getCheckout();
                        checkout.setBranchPoint(stream.getBranchPoint());
                    }
                });
            } else if (event instanceof ISystemManager.ModuleDeletedEvent) {
                ISystemManager.ModuleDeletedEvent e = (ISystemManager.ModuleDeletedEvent)event;
                ISystemDescriptor systemDescriptor = e.getSystemDescriptor();
                CDOID deletedModuleID = e.getDeletedModuleID();
                ObjectUtil.forEachSafe((Object[])((IAssemblyDescriptor[])AssemblyManager.this.getDescriptors()), assemblyDescriptor -> {
                    if (assemblyDescriptor.getSystemDescriptor() == systemDescriptor) {
                        ((AssemblyDescriptor)assemblyDescriptor).moduleDeleted(deletedModuleID);
                    }
                });
            }
        }
    };
    private final TaskQueue<IAssemblyDescriptor> updateChecker = new TaskQueue<IAssemblyDescriptor>(){

        protected String getJobName(IAssemblyDescriptor descriptor) {
            return "Check for updates in " + descriptor.getName();
        }

        protected void execute(IAssemblyDescriptor descriptor, IProgressMonitor monitor) throws Exception {
            ((AssemblyDescriptor)descriptor).checkForUpdates(monitor);
        }

        protected void handleException(IAssemblyDescriptor descriptor, Exception ex) {
            if (AssemblyManager.this.isActive()) {
                super.handleException((Object)descriptor, ex);
            }
        }
    };
    private final Map<CDOCheckout, IAssemblyDescriptor> unfinalizedDescriptors = new WeakHashMap<CDOCheckout, IAssemblyDescriptor>();

    private AssemblyManager() {
        super(CDOExplorerUtil.getCheckoutManager(), CDOCheckout.class);
    }

    public void scheduleUpdateCheck(IAssemblyDescriptor descriptor) {
        if (CREATING_DESCRIPTOR.get() != Boolean.TRUE) {
            this.updateChecker.schedule((Object)descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAssemblyDescriptor getDescriptor(CDOCheckout explorerElement) {
        AssemblyManager assemblyManager = this;
        synchronized (assemblyManager) {
            IAssemblyDescriptor descriptor = (IAssemblyDescriptor)super.getDescriptor(explorerElement);
            if (descriptor == null) {
                descriptor = this.unfinalizedDescriptors.get(explorerElement);
            }
            return descriptor;
        }
    }

    @Override
    public IAssemblyDescriptor getDescriptor(EObject object) {
        CDOCheckout checkout;
        IAssemblyDescriptor descriptor = AssemblyDescriptor.get(object);
        if (descriptor == null && (checkout = CDOExplorerUtil.getCheckout((Object)object)) != null) {
            descriptor = this.getDescriptor(checkout);
        }
        return descriptor;
    }

    @Override
    public IAssemblyDescriptor[] getDescriptors(Baseline baseline) {
        ArrayList result = new ArrayList();
        this.forEachDescriptor((D d) -> {
            if (d.getBaseline() == baseline) {
                result.add(d);
            }
        });
        return result.toArray(this.newArray(result.size()));
    }

    @Override
    public IAssemblyDescriptor createDescriptor(String label, Baseline baseline, IProgressMonitor monitor) throws Exception {
        Module module = baseline.getModule();
        String moduleName = module.getName();
        ModuleType moduleType = module.getType();
        System system = module.getSystem();
        SystemDescriptor systemDescriptor = (SystemDescriptor)ISystemManager.INSTANCE.getDescriptor((EObject)system);
        ModuleDefinition moduleDefinition = systemDescriptor.extractModuleDefinition(baseline);
        Assembly assembly = null;
        ISystemDescriptor.ResolutionException.Reason[] reasons = null;
        try {
            assembly = systemDescriptor.resolve(moduleDefinition, baseline, monitor);
        }
        catch (ISystemDescriptor.ResolutionException ex) {
            reasons = ex.getReasons();
            OM.LOG.warn((Throwable)ex);
            assembly = systemDescriptor.createEmptyAssembly();
        }
        CDORepository moduleRepository = systemDescriptor.getModuleRepository(moduleName);
        if (moduleRepository != null) {
            CDOCheckout checkout = this.createCheckout(label, baseline, moduleRepository);
            Properties properties = new Properties();
            properties.setProperty("systemName", system.getName());
            properties.setProperty("moduleName", moduleName);
            properties.setProperty("baselineID", CDOExplorerUtil.getCDOIDString((CDOID)baseline.cdoID()));
            if (moduleType != null) {
                properties.setProperty("moduleType", moduleType.getName());
            }
            this.saveLMProperties(checkout, properties);
            if (assembly != null) {
                AssemblyManager.saveAssembly(checkout, assembly, false);
            }
            if (reasons != null && reasons.length != 0) {
                AssemblyManager.saveErrors(checkout, reasons);
            }
            try {
                CREATING_DESCRIPTOR.set(Boolean.TRUE);
                checkout.open();
            }
            finally {
                CREATING_DESCRIPTOR.remove();
            }
            return this.getDescriptor(checkout);
        }
        return null;
    }

    @Override
    public String getModuleTypeProperty(CDOCheckout checkout) {
        Object property;
        Properties properties = AssemblyManager.loadLMProperties(checkout);
        if (properties != null && (property = properties.get("moduleType")) instanceof String) {
            return (String)property;
        }
        return null;
    }

    private CDOCheckout createCheckout(String label, Baseline baseline, CDORepository moduleRepository) {
        CDOID rootID;
        int branchID;
        boolean readOnly;
        String type;
        if (baseline.isFloating()) {
            type = "online-transactional";
            readOnly = false;
        } else {
            type = "online-historical";
            readOnly = true;
        }
        CDOBranchPointRef ref = baseline.getBranchPoint();
        CDOSession session = moduleRepository.acquireSession();
        try {
            CDOBranchPoint branchPoint = ref.resolve(session.getBranchManager());
            branchID = branchPoint.getBranch().getID();
            rootID = session.getRepositoryInfo().getRootResourceID();
        }
        finally {
            moduleRepository.releaseSession();
        }
        CDOCheckoutManager checkoutManager = CDOExplorerUtil.getCheckoutManager();
        Properties properties = new Properties();
        properties.setProperty("type", type);
        properties.setProperty("label", checkoutManager.getUniqueLabel(label));
        properties.setProperty("repository", moduleRepository.getID());
        properties.setProperty("branchID", Integer.toString(branchID));
        properties.setProperty("timeStamp", Long.toString(ref.getTimeStamp()));
        properties.setProperty("readOnly", Boolean.toString(readOnly));
        properties.setProperty("rootID", CDOExplorerUtil.getCDOIDString((CDOID)rootID));
        properties.setProperty("prefetch", StringUtil.TRUE);
        return checkoutManager.addCheckout(properties);
    }

    protected IAssemblyDescriptor[] newArray(int size) {
        return new IAssemblyDescriptor[size];
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        ISystemManager.INSTANCE.addListener(this.systemManagerListener);
    }

    @Override
    protected void doDeactivate() throws Exception {
        ISystemManager.INSTANCE.removeListener(this.systemManagerListener);
        super.doDeactivate();
    }

    @Override
    protected void explorerElementAdded(CDOCheckout checkout) {
        if (checkout.isOpen()) {
            this.initializeDescriptor(checkout);
            this.finalizeDescriptor(checkout);
        }
    }

    @Override
    protected void explorerElementRemoved(CDOCheckout checkout) {
        this.removeDescriptor(checkout);
    }

    @Override
    protected void explorerElementChanged(CDOCheckout checkout) {
        this.updateDescriptor(checkout);
    }

    @Override
    protected void notifyExplorerElementEvent(IEvent event) {
        if (event instanceof CDOCheckoutManager.CheckoutInitializeEvent) {
            CDOCheckoutManager.CheckoutInitializeEvent e = (CDOCheckoutManager.CheckoutInitializeEvent)event;
            this.initializeDescriptor(e.getCheckout());
        } else if (event instanceof CDOCheckoutManager.CheckoutStateEvent) {
            CDOCheckoutManager.CheckoutStateEvent e = (CDOCheckoutManager.CheckoutStateEvent)event;
            switch (e.getNewState()) {
                case Open: {
                    this.finalizeDescriptor(e.getCheckout());
                    break;
                }
                case Closed: {
                    this.removeDescriptor(e.getCheckout());
                }
            }
        } else {
            super.notifyExplorerElementEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDescriptor(CDOCheckout checkout) {
        Properties properties = AssemblyManager.loadLMProperties(checkout);
        if (properties != null) {
            String systemName = properties.getProperty("systemName");
            CDOID baselineID = CDOIDUtil.read((String)properties.getProperty("baselineID"));
            AssemblyManager assemblyManager = this;
            synchronized (assemblyManager) {
                if (!this.descriptors.containsKey(checkout) && !this.unfinalizedDescriptors.containsKey(checkout)) {
                    AssemblyDescriptor descriptor = new AssemblyDescriptor(checkout, systemName, baselineID);
                    LifecycleUtil.activate((Object)descriptor);
                    this.unfinalizedDescriptors.put(checkout, descriptor);
                    ++this.count;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeDescriptor(CDOCheckout checkout) {
        IAssemblyDescriptor descriptor;
        AssemblyManager assemblyManager = this;
        synchronized (assemblyManager) {
            descriptor = this.unfinalizedDescriptors.remove(checkout);
            if (descriptor != null) {
                this.descriptors.put(checkout, descriptor);
                ++this.count;
            }
        }
        if (descriptor != null) {
            this.scheduleUpdateCheck(descriptor);
            this.fireElementAddedEvent(descriptor);
        }
    }

    private void updateDescriptor(CDOCheckout checkout) {
        AssemblyDescriptor descriptor = (AssemblyDescriptor)this.getDescriptor(checkout);
        if (descriptor != null) {
            descriptor.checkoutChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDescriptor(CDOCheckout checkout) {
        IAssemblyDescriptor descriptor;
        AssemblyManager assemblyManager = this;
        synchronized (assemblyManager) {
            descriptor = (IAssemblyDescriptor)this.descriptors.remove(checkout);
            if (descriptor != null) {
                --this.count;
            }
        }
        if (descriptor != null) {
            LifecycleUtil.deactivate((Object)descriptor);
            this.fireElementRemovedEvent(descriptor);
        }
    }

    private static File getAssemblyFile(CDOCheckout checkout, boolean createFolderOnDemand, boolean update) {
        File stateFolder = AssemblyManager.getLMStateFolder((CDOExplorerElement)checkout, createFolderOnDemand);
        return new File(stateFolder, update ? ASSEMBLY_UPDATE_FILE_NAME : ASSEMBLY_FILE_NAME);
    }

    private static File getErrorsFile(CDOCheckout checkout, boolean createFolderOnDemand) {
        File stateFolder = AssemblyManager.getLMStateFolder((CDOExplorerElement)checkout, createFolderOnDemand);
        return new File(stateFolder, ERRORS_FILE_NAME);
    }

    private static void deleteFile(File file) throws IOException {
        if (file.isFile() && !file.delete()) {
            throw new IOException(String.valueOf(file) + " could not be deleted");
        }
    }

    public static void saveAssembly(CDOCheckout checkout, Assembly assembly, boolean update) throws IOException {
        File file = AssemblyManager.getAssemblyFile(checkout, true, update);
        URI uri = URI.createFileURI((String)file.getAbsolutePath());
        ResourceSetImpl assemblyResourceSet = new ResourceSetImpl();
        Resource assemblyResource = assemblyResourceSet.createResource(uri);
        assemblyResource.getContents().add((Object)assembly);
        assemblyResource.save(null);
    }

    public static Assembly loadAssembly(CDOCheckout checkout, boolean update) {
        File file = AssemblyManager.getAssemblyFile(checkout, false, update);
        if (file.isFile()) {
            URI uri = URI.createFileURI((String)file.getAbsolutePath());
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(uri, true);
            Assembly assembly = (Assembly)resource.getContents().get(0);
            return assembly;
        }
        return null;
    }

    public static void deleteAssembly(CDOCheckout checkout, boolean update) throws IOException {
        File file = AssemblyManager.getAssemblyFile(checkout, true, update);
        AssemblyManager.deleteFile(file);
    }

    public static void setCheckoutError(CDOCheckout checkout, String error) {
        ((CDOCheckoutImpl)checkout).setError(error);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> saveErrors(CDOCheckout checkout, ISystemDescriptor.ResolutionException.Reason[] reasons) throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        AssemblyManager.setCheckoutError(checkout, RESOLUTION_ERROR);
        File file = AssemblyManager.getErrorsFile(checkout, true);
        if (reasons != null && reasons.length != 0) {
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                FileWriter fileWriter = new FileWriter(file);
                try {
                    try (BufferedWriter writer = new BufferedWriter(fileWriter);){
                        ISystemDescriptor.ResolutionException.Reason[] reasonArray = reasons;
                        int n = reasons.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ISystemDescriptor.ResolutionException.Reason reason = reasonArray[n2];
                            String error = reason.toString();
                            errors.add(error);
                            writer.write(error);
                            writer.write(StringUtil.NL);
                            ++n2;
                        }
                    }
                    if (fileWriter == null) return errors;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fileWriter == null) throw throwable;
                    fileWriter.close();
                    throw throwable;
                }
                fileWriter.close();
                return errors;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        AssemblyManager.deleteFile(file);
        return errors;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> loadErrors(CDOCheckout checkout) {
        File file = AssemblyManager.getErrorsFile(checkout, true);
        if (!file.isFile()) return null;
        ArrayList<String> errors = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileReader fileReader = new FileReader(file);
                try {
                    try (BufferedReader reader = new BufferedReader(fileReader);){
                        String error;
                        while ((error = reader.readLine()) != null) {
                            errors.add(error);
                        }
                    }
                    if (fileReader == null) return errors;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fileReader == null) throw throwable;
                    fileReader.close();
                    throw throwable;
                }
                fileReader.close();
                return errors;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public static void deleteErrors(CDOCheckout checkout) throws IOException {
        if (RESOLUTION_ERROR.equals(checkout.getError())) {
            AssemblyManager.setCheckoutError(checkout, null);
        }
        File file = AssemblyManager.getErrorsFile(checkout, true);
        AssemblyManager.deleteFile(file);
    }
}

