/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealBasicNoPutResultSetStatistics;
import org.apache.derby.shared.common.i18n.MessageService;

abstract class RealNoRowsResultSetStatistics
implements ResultSetStatistics {
    protected String indent;
    protected String subIndent;
    protected int sourceDepth;
    public ResultSetStatistics sourceResultSetStatistics;
    public long executeTime;
    public long inspectOverall;
    public long inspectNum;
    public String inspectDesc;

    public RealNoRowsResultSetStatistics(long executeTime, ResultSetStatistics sourceRS) {
        if (sourceRS instanceof RealBasicNoPutResultSetStatistics) {
            this.executeTime = executeTime - ((RealBasicNoPutResultSetStatistics)sourceRS).getTotalTime();
        }
    }

    protected void initFormatInfo(int depth) {
        char[] indentchars = new char[depth];
        char[] subIndentchars = new char[depth + 1];
        this.sourceDepth = depth + 1;
        subIndentchars[depth] = 9;
        while (depth > 0) {
            subIndentchars[depth - 1] = 9;
            indentchars[depth - 1] = 9;
            --depth;
        }
        this.indent = new String(indentchars);
        this.subIndent = new String(subIndentchars);
    }

    protected String dumpTimeStats(String indent) {
        return indent + MessageService.getTextMessage("43Y29.U", new Object[0]) + " = " + this.executeTime + "\n";
    }

    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.sourceResultSetStatistics);
        return children;
    }

    public abstract String getNodeName();

    @Override
    public double getEstimatedRowCount() {
        return 0.0;
    }

    @Override
    public String getRSXplainDetails() {
        return null;
    }

    @Override
    public Object getResultSetDescriptor(Object rsID, Object parentID, Object scanID, Object sortID, Object stmtID, Object timingID) {
        return new XPLAINResultSetDescriptor((UUID)rsID, this.getRSXplainType(), this.getRSXplainDetails(), null, null, null, null, (UUID)parentID, null, null, null, null, null, null, null, null, null, null, null, (UUID)scanID, (UUID)sortID, (UUID)stmtID, (UUID)timingID);
    }

    @Override
    public Object getResultSetTimingsDescriptor(Object timingID) {
        return new XPLAINResultSetTimingsDescriptor((UUID)timingID, null, null, null, null, this.executeTime, null, null, null, null, null);
    }

    @Override
    public Object getSortPropsDescriptor(Object UUID2) {
        return null;
    }

    @Override
    public Object getScanPropsDescriptor(Object UUID2) {
        return null;
    }
}

