/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.internal.db.DBStoreTable;
import org.eclipse.emf.cdo.server.internal.db.IObjectTypeMapper;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.MappingNames;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class ObjectTypeTable
extends DBStoreTable
implements IObjectTypeMapper {
    private IDBField id;
    private IDBField clazz;
    private IDBField created;
    private String sqlDelete;
    private String sqlInsert;
    private String sqlSelect;

    public ObjectTypeTable(IDBStore store) {
        super(store, MappingNames.CDO_OBJECTS);
    }

    public final IDBField id() {
        return this.id;
    }

    public final IDBField clazz() {
        return this.clazz;
    }

    @Override
    public final CDOClassifierRef getObjectType(IDBStoreAccessor accessor, CDOID id) {
        IIDHandler idHandler = this.store().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlSelect, IDBPreparedStatement.ReuseProbability.MAX);
        try {
            IDBResultSet resultSet;
            idHandler.setCDOID((PreparedStatement)stmt, 1, id);
            if (DBUtil.isTracerEnabled()) {
                DBUtil.trace((String)stmt.toString());
            }
            if (!(resultSet = stmt.executeQuery()).next()) {
                if (DBUtil.isTracerEnabled()) {
                    DBUtil.trace((String)("ClassID for CDOID " + id + " not found"));
                }
                return null;
            }
            CDOID classID = idHandler.getCDOID((ResultSet)resultSet, 1);
            EClass eClass = (EClass)this.store().getMetaDataManager().getMetaInstance(classID);
            CDOClassifierRef cDOClassifierRef = new CDOClassifierRef((EClassifier)eClass);
            return cDOClassifierRef;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    public final boolean putObjectType(IDBStoreAccessor accessor, long timeStamp, CDOID id, EClass type) {
        IIDHandler idHandler = this.store().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsert, IDBPreparedStatement.ReuseProbability.MAX);
        try {
            int result;
            idHandler.setCDOID((PreparedStatement)stmt, 1, id);
            idHandler.setCDOID((PreparedStatement)stmt, 2, this.store().getMetaDataManager().getMetaID((EModelElement)type, timeStamp));
            stmt.setLong(3, timeStamp);
            if (DBUtil.isTracerEnabled()) {
                DBUtil.trace((String)stmt.toString());
            }
            if ((result = stmt.executeUpdate()) != 1) {
                throw new DBException("Object type could not be inserted: " + id);
            }
            return true;
        }
        catch (SQLException ex) {
            if (this.store().getDBAdapter().isDuplicateKeyException(ex)) {
                return false;
            }
            throw new DBException((Throwable)ex);
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    public final boolean removeObjectType(IDBStoreAccessor accessor, CDOID id) {
        IIDHandler idHandler = this.store().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlDelete, IDBPreparedStatement.ReuseProbability.MAX);
        try {
            int result;
            idHandler.setCDOID((PreparedStatement)stmt, 1, id);
            if (DBUtil.isTracerEnabled()) {
                DBUtil.trace((String)stmt.toString());
            }
            boolean bl = (result = stmt.executeUpdate()) == 1;
            return bl;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    public CDOID getMaxID(Connection connection, IIDHandler idHandler) {
        ResultSet resultSet;
        Statement stmt;
        block4: {
            CDOID cDOID;
            stmt = null;
            resultSet = null;
            try {
                stmt = connection.createStatement();
                resultSet = stmt.executeQuery("SELECT MAX(" + this.id + ") FROM " + this.table());
                if (!resultSet.next()) break block4;
                cDOID = idHandler.getCDOID(resultSet, 1);
            }
            catch (SQLException ex) {
                try {
                    throw new DBException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    DBUtil.close(resultSet);
                    DBUtil.close((Statement)stmt);
                    throw throwable;
                }
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
            return cDOID;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return null;
    }

    @Override
    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
        String where = " WHERE " + this.created + " BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)this.table(), null, (String)where);
    }

    @Override
    public void rawImport(Connection connection, CDODataInput in, OMMonitor monitor) throws IOException {
        DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)this.table(), (OMMonitor)monitor);
    }

    @Override
    protected void firstActivate(IDBTable table) {
        DBType idType = this.store().getIDHandler().getDBType();
        int idLength = this.store().getIDColumnLength();
        this.id = table.addField(MappingNames.ATTRIBUTES_ID, idType, idLength, true);
        this.clazz = table.addField(MappingNames.ATTRIBUTES_CLASS, idType, idLength);
        this.created = table.addField(MappingNames.ATTRIBUTES_CREATED, DBType.BIGINT);
        table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.id});
        InternalRepository repository = (InternalRepository)this.store().getRepository();
        if (repository.isSupportingUnits()) {
            table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{this.clazz});
        }
    }

    @Override
    protected void reActivate(IDBTable table) {
        this.id = table.getField(MappingNames.ATTRIBUTES_ID);
        this.clazz = table.getField(MappingNames.ATTRIBUTES_CLASS);
        this.created = table.getField(MappingNames.ATTRIBUTES_CREATED);
    }

    @Override
    protected void initSQL(IDBTable table) {
        this.sqlSelect = "SELECT " + this.clazz + " FROM " + table + " WHERE " + this.id + "=?";
        this.sqlInsert = "INSERT INTO " + table + "(" + this.id + "," + this.clazz + "," + this.created + ") VALUES (?, ?, ?)";
        this.sqlDelete = "DELETE FROM " + table + " WHERE " + this.id + "=?";
    }
}

