/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.impl.io.vfmem.DataStore;
import org.apache.derby.impl.io.vfmem.DataStoreEntry;
import org.apache.derby.impl.io.vfmem.PathUtil;
import org.apache.derby.impl.io.vfmem.VirtualRandomAccessFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.shared.common.error.StandardException;

public class VirtualFile
implements StorageFile {
    private final String path;
    private final DataStore dStore;

    public VirtualFile(String path, DataStore dbData) {
        this.path = path;
        this.dStore = dbData;
    }

    @Override
    public String[] list() {
        DataStoreEntry entry = this.getEntry();
        if (entry == null || !entry.isDirectory()) {
            return null;
        }
        return this.dStore.listChildren(this.path);
    }

    @Override
    public boolean canWrite() {
        return this.getEntry() != null && !this.getEntry().isReadOnly();
    }

    @Override
    public boolean exists() {
        return this.getEntry() != null;
    }

    @Override
    public boolean isDirectory() {
        DataStoreEntry entry = this.getEntry();
        return entry != null && entry.isDirectory();
    }

    @Override
    public boolean delete() {
        return this.dStore.deleteEntry(this.path);
    }

    @Override
    public boolean deleteAll() {
        DataStoreEntry entry = this.getEntry();
        if (entry == null) {
            return false;
        }
        if (entry.isDirectory()) {
            return this.dStore.deleteAll(this.path);
        }
        return this.delete();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getCanonicalPath() {
        return this.getPath();
    }

    @Override
    public String getName() {
        return PathUtil.getBaseName(this.path);
    }

    @Override
    public boolean createNewFile() {
        return this.dStore.createEntry(this.path, false) != null;
    }

    @Override
    public boolean renameTo(StorageFile newName) {
        return this.dStore.move(this, newName);
    }

    @Override
    public boolean mkdir() {
        DataStoreEntry entry = this.getEntry();
        if (entry == null) {
            return this.dStore.createEntry(this.path, true) != null;
        }
        return false;
    }

    @Override
    public boolean mkdirs() {
        DataStoreEntry entry = this.getEntry();
        if (entry == null) {
            return this.dStore.createAllParents(this.path) && this.dStore.createEntry(this.path, true) != null;
        }
        return false;
    }

    public long length() {
        DataStoreEntry entry = this.getEntry();
        if (entry != null && !entry.isDirectory()) {
            return entry.length();
        }
        return 0L;
    }

    @Override
    public StorageFile getParentDir() {
        String parent = PathUtil.getParent(this.path);
        if (parent == null) {
            return null;
        }
        return new VirtualFile(parent, this.dStore);
    }

    @Override
    public boolean setReadOnly() {
        DataStoreEntry entry = this.getEntry();
        if (entry == null) {
            return false;
        }
        entry.setReadOnly();
        return true;
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException {
        return this.getOutputStream(false);
    }

    @Override
    public OutputStream getOutputStream(boolean append) throws FileNotFoundException {
        DataStoreEntry entry = this.getEntry();
        if (entry == null && (entry = this.dStore.createEntry(this.path, false)) == null) {
            throw new FileNotFoundException("Unable to create file: " + this.path);
        }
        return entry.getOutputStream(append);
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        DataStoreEntry entry = this.getEntry();
        if (entry == null) {
            throw new FileNotFoundException(this.path);
        }
        return entry.getInputStream();
    }

    @Override
    public int getExclusiveFileLock() throws StandardException {
        return 1;
    }

    @Override
    public void releaseExclusiveFileLock() {
    }

    @Override
    public StorageRandomAccessFile getRandomAccessFile(String mode) throws FileNotFoundException {
        if (!(mode.equals("r") || mode.equals("rw") || mode.equals("rws") || mode.equals("rwd"))) {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
        DataStoreEntry entry = this.getEntry();
        if (entry == null) {
            if (mode.equals("r")) {
                throw new FileNotFoundException("Cannot read from non-existing file: " + this.path + " (mode=" + mode + ")");
            }
            entry = this.dStore.createEntry(this.path, false);
            if (entry == null) {
                throw new FileNotFoundException("Unable to create file: " + this.path + " (mode=" + mode + ")");
            }
        }
        return new VirtualRandomAccessFile(entry, mode.equals("r"));
    }

    public String toString() {
        return "(db=" + this.dStore.getDatabaseName() + ")" + this.path + "#exists=" + this.exists() + ", isDirectory=" + this.isDirectory() + ", length=" + this.length() + ", canWrite=" + this.canWrite();
    }

    private DataStoreEntry getEntry() {
        return this.dStore.getEntry(this.path);
    }

    @Override
    public void limitAccessToOwner() {
    }
}

