/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import java.util.HashMap;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.conn.SQLSessionContext;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;

public class SQLSessionContextImpl
implements SQLSessionContext {
    private String currentUser;
    private String currentRole = null;
    private SchemaDescriptor currentDefaultSchema;
    private HashMap<UUID, Boolean> constraintModes;
    private Boolean deferredAll;

    public SQLSessionContextImpl(SchemaDescriptor sd, String currentUser) {
        this.currentDefaultSchema = sd;
        this.currentUser = currentUser;
    }

    @Override
    public void setRole(String role) {
        this.currentRole = role;
    }

    @Override
    public String getRole() {
        return this.currentRole;
    }

    @Override
    public void setUser(String user) {
        this.currentUser = user;
    }

    @Override
    public String getCurrentUser() {
        return this.currentUser;
    }

    @Override
    public void setDefaultSchema(SchemaDescriptor sd) {
        this.currentDefaultSchema = sd;
    }

    @Override
    public SchemaDescriptor getDefaultSchema() {
        return this.currentDefaultSchema;
    }

    @Override
    public HashMap<UUID, Boolean> getConstraintModes() {
        return this.constraintModes != null ? new HashMap<UUID, Boolean>(this.constraintModes) : null;
    }

    @Override
    public void setConstraintModes(HashMap<UUID, Boolean> hm) {
        this.constraintModes = hm != null ? new HashMap<UUID, Boolean>(hm) : null;
    }

    @Override
    public void setDeferred(UUID constraintId, boolean deferred) {
        if (this.constraintModes == null) {
            this.constraintModes = new HashMap();
        }
        this.constraintModes.put(constraintId, deferred);
    }

    @Override
    public Boolean isDeferred(UUID constraintId) {
        Boolean v = null;
        if (this.constraintModes != null) {
            v = this.constraintModes.get(constraintId);
        }
        if (v != null) {
            return v;
        }
        return this.deferredAll;
    }

    @Override
    public void resetConstraintModes() {
        if (this.constraintModes != null) {
            this.constraintModes.clear();
        }
        this.deferredAll = null;
    }

    @Override
    public void setDeferredAll(Boolean deferred) {
        this.deferredAll = deferred;
        if (this.constraintModes != null) {
            this.constraintModes.clear();
        }
    }

    @Override
    public Boolean getDeferredAll() {
        return this.deferredAll;
    }
}

