/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Base64;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.factory.SingletonFactory;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.om.OMPlatform;

@FunctionalInterface
public interface StringConverter
extends Function<Object, String> {
    public static final String PRODUCT_GROUP = "org.eclipse.net4j.util.stringConverters";
    public static final StringConverter IDENTITY = new StringConverter(){

        @Override
        public String apply(Object value) {
            return StringUtil.safe(value, null);
        }
    };
    public static final StringConverter CHARS = new StringConverter(){

        @Override
        public String apply(Object value) {
            return value == null ? null : (value instanceof char[] ? String.valueOf((char[])value) : value.toString());
        }
    };
    public static final StringConverter SAFE = new StringConverter(){

        @Override
        public String apply(Object value) {
            return StringUtil.safe(value);
        }
    };
    public static final StringConverter HEX = new StringConverter(){

        @Override
        public String apply(Object value) {
            return value == null ? null : HexUtil.bytesToHex((byte[])value);
        }
    };
    public static final StringConverter BASE64 = new StringConverter(){
        private final Base64.Encoder encoder = Base64.getEncoder();

        @Override
        public String apply(Object value) {
            return value == null ? null : this.encoder.encodeToString((byte[])value);
        }
    };
    public static final StringConverter UPPER = new StringConverter(){

        @Override
        public String apply(Object value) {
            return value == null ? null : StringUtil.safe(value).toUpperCase();
        }
    };
    public static final StringConverter LOWER = new StringConverter(){

        @Override
        public String apply(Object value) {
            return value == null ? null : StringUtil.safe(value).toLowerCase();
        }
    };
    public static final StringConverter CAP = new StringConverter(){

        @Override
        public String apply(Object value) {
            return value == null ? null : StringUtil.cap(value.toString());
        }
    };
    public static final StringConverter CAP_ALL = new StringConverter(){

        @Override
        public String apply(Object value) {
            return value == null ? null : StringUtil.capAll(value.toString());
        }
    };
    public static final StringConverter UNCAP = new StringConverter(){

        @Override
        public String apply(Object value) {
            return value == null ? null : StringUtil.uncap(value.toString());
        }
    };
    public static final StringConverter UNCAP_ALL = new StringConverter(){

        @Override
        public String apply(Object value) {
            return value == null ? null : StringUtil.uncapAll(value.toString());
        }
    };
    public static final StringConverter ESCAPE = new StringConverter(){

        @Override
        public String apply(Object value) {
            return value == null ? null : StringUtil.escape(value.toString());
        }
    };
    public static final StringConverter UNESCAPE = new StringConverter(){

        @Override
        public String apply(Object value) {
            return value == null ? null : StringUtil.unescape(value.toString());
        }
    };
    public static final StringConverter STRIP_HTML = new StringConverter(){

        @Override
        public String apply(Object value) {
            return value == null ? null : StringUtil.stripHTML(value.toString());
        }
    };
    public static final StringConverter NET4J_USER_PATH = new StringConverter(){

        @Override
        public String apply(Object value) {
            File path = OMPlatform.INSTANCE.getUserFolder();
            String suffix = StringUtil.safe(value);
            if (suffix.length() != 0) {
                path = new File(path, suffix);
            }
            return path.getAbsolutePath();
        }
    };
    public static final StringConverter NET4J_STATE_PATH = new StringConverter(){

        @Override
        public String apply(Object value) {
            File path = OMPlatform.INSTANCE.getStateFolder();
            String suffix = StringUtil.safe(value);
            if (suffix.length() != 0) {
                path = new File(path, suffix);
            }
            return path.getAbsolutePath();
        }
    };
    public static final StringConverter NET4J_CONFIG_PATH = new StringConverter(){

        @Override
        public String apply(Object value) {
            File path = OMPlatform.INSTANCE.getConfigFolder();
            String suffix = StringUtil.safe(value);
            if (suffix.length() != 0) {
                path = new File(path, suffix);
            }
            return path.getAbsolutePath();
        }
    };
    public static final StringConverter SYSTEM_PROPERTY = new StringConverter(){

        @Override
        public String apply(Object value) {
            if (value == null) {
                return null;
            }
            String str = value.toString();
            return OMPlatform.INSTANCE.getProperty(str);
        }
    };
    public static final StringConverter PROPERTY_URI = new StringConverter(){

        @Override
        public String apply(Object value) {
            if (value == null) {
                return null;
            }
            String str = value.toString();
            if (str == null) {
                return null;
            }
            URI uri = URI.create(str);
            String key = uri.getFragment();
            if (key == null) {
                return null;
            }
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream stream = uri.toURL().openStream();){
                    Properties properties = new Properties();
                    properties.load(stream);
                    return properties.getProperty(key);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }
    };

    @Override
    public String apply(Object var1);

    default public StringConverter compose(StringConverter before) {
        Objects.requireNonNull(before);
        return value -> this.apply(before.apply(value));
    }

    default public StringConverter andThen(StringConverter after) {
        Objects.requireNonNull(after);
        return value -> after.apply(this.apply(value));
    }

    public static final class MetaFactory
    extends org.eclipse.net4j.util.factory.MetaFactory {
        private static final String PG = "org.eclipse.net4j.util.stringConverters";
        private static final IFactory[] CHILDREN = new IFactory[]{new SingletonFactory("org.eclipse.net4j.util.stringConverters", "identity", IDENTITY), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "chars", CHARS), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "safe", SAFE), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "hex", HEX), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "base64", BASE64), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "upper", UPPER), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "lower", LOWER), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "cap", CAP), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "cap_all", CAP_ALL), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "uncap", UNCAP), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "uncap_all", UNCAP_ALL), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "escape", ESCAPE), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "unescape", UNESCAPE), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "strip_html", STRIP_HTML), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "net4j_user_path", NET4J_USER_PATH), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "net4j_state_path", NET4J_STATE_PATH), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "net4j_config_path", NET4J_CONFIG_PATH), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "system_property", SYSTEM_PROPERTY), new SingletonFactory("org.eclipse.net4j.util.stringConverters", "property_uri", PROPERTY_URI)};

        public MetaFactory() {
            super("org.eclipse.net4j.util.stringConverters");
        }

        @Override
        public IFactory[] create(String description) throws ProductCreationException {
            return CHILDREN;
        }
    }
}

