/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.common.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.net4j.buddies.common.IAccount;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.IBuddyContainer;
import org.eclipse.net4j.buddies.common.IMessage;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public final class ProtocolUtil {
    private ProtocolUtil() {
    }

    public static void writeBuddies(ExtendedDataOutputStream out, Collection<IBuddy> buddies) throws IOException {
        if (buddies == null) {
            out.writeInt(0);
        } else {
            out.writeInt(buddies.size());
            for (IBuddy buddy : buddies) {
                out.writeString(buddy.getUserID());
            }
        }
    }

    public static Set<IBuddy> readBuddies(ExtendedDataInputStream in, IBuddyContainer buddyContainer) throws IOException {
        int size = in.readInt();
        HashSet<IBuddy> buddies = new HashSet<IBuddy>();
        int i = 0;
        while (i < size) {
            String userID = in.readString();
            IBuddy buddy = buddyContainer.getBuddy(userID);
            if (buddy != null) {
                buddies.add(buddy);
            }
            ++i;
        }
        return buddies;
    }

    public static String[] readUserIDs(ExtendedDataInputStream in) throws IOException {
        int size = in.readInt();
        String[] userIDs = new String[size];
        int i = 0;
        while (i < size) {
            userIDs[i] = in.readString();
            ++i;
        }
        return userIDs;
    }

    public static void writeAccount(ExtendedDataOutputStream out, IAccount account) throws IOException {
        if (account != null) {
            out.writeBoolean(true);
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)out);
            oos.writeObject(account);
        } else {
            out.writeBoolean(false);
        }
    }

    public static IAccount readAccount(ExtendedDataInputStream in) throws IOException {
        boolean exists = in.readBoolean();
        if (!exists) {
            return null;
        }
        try {
            ObjectInputStream ois = new ObjectInputStream((InputStream)in);
            return (IAccount)ois.readObject();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public static void writeState(ExtendedDataOutputStream out, IBuddy.State state) throws IOException {
        switch (state) {
            case AVAILABLE: {
                out.writeByte(1);
                break;
            }
            case LONESOME: {
                out.writeByte(2);
                break;
            }
            case AWAY: {
                out.writeByte(3);
                break;
            }
            case DO_NOT_DISTURB: {
                out.writeByte(4);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal state: " + (Object)((Object)state));
            }
        }
    }

    public static IBuddy.State readState(ExtendedDataInputStream in) throws IOException {
        byte state = in.readByte();
        switch (state) {
            case 1: {
                return IBuddy.State.AVAILABLE;
            }
            case 2: {
                return IBuddy.State.LONESOME;
            }
            case 3: {
                return IBuddy.State.AWAY;
            }
            case 4: {
                return IBuddy.State.DO_NOT_DISTURB;
            }
        }
        throw new IllegalArgumentException("Illegal state: " + state);
    }

    public static void writeFacilityTypes(ExtendedDataOutputStream out, String[] facilityTypes) throws IOException {
        if (facilityTypes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(facilityTypes.length);
            String[] stringArray = facilityTypes;
            int n = facilityTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String facilityType = stringArray[n2];
                out.writeString(facilityType);
                ++n2;
            }
        }
    }

    public static String[] readFacilityTypes(ExtendedDataInputStream in) throws IOException {
        int size = in.readInt();
        String[] facilityTypes = new String[size];
        int i = 0;
        while (i < size) {
            facilityTypes[i] = in.readString();
            ++i;
        }
        return facilityTypes;
    }

    public static void writeMessage(ExtendedDataOutputStream out, IMessage message) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)out);
        oos.writeObject(message);
    }

    public static IMessage readMessage(ExtendedDataInputStream in, final ClassLoader classLoader) throws IOException {
        try {
            ObjectInputStream ois = new ObjectInputStream((InputStream)in){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String className = desc.getName();
                    return classLoader.loadClass(className);
                }
            };
            return (IMessage)ois.readObject();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }
}

