/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.error;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.util.ArrayUtil;

public class StandardException
extends Exception {
    public static final int REPORT_DEFAULT = 0;
    public static final int REPORT_NEVER = 1;
    public static final int REPORT_ALWAYS = 2;
    private transient Object[] arguments;
    private int severity;
    private String textMessage;
    private String sqlState;
    private transient int report;
    private transient boolean isForPublicAPI;
    private transient SQLException next;

    protected StandardException(String messageID) {
        this(messageID, null, null);
    }

    protected StandardException(String messageID, Throwable t, Object[] args) {
        super(messageID);
        this.severity = StandardException.getSeverityFromIdentifier(messageID);
        this.sqlState = StandardException.getSQLStateFromIdentifier(messageID);
        this.arguments = args;
        if (t != null) {
            this.initCause(t);
        }
        SanityManager.ASSERT(messageID != null, "StandardException with no messageID");
    }

    private StandardException(String sqlState, String text) {
        this(sqlState);
        this.textMessage = text;
    }

    public final Object[] getArguments() {
        return ArrayUtil.copy(this.arguments);
    }

    public final int report() {
        return this.report;
    }

    public final void setReport(int report) {
        this.report = report;
    }

    public final void setSeverity(int severity) {
        this.severity = severity;
    }

    public final int getSeverity() {
        return this.severity;
    }

    public final int getErrorCode() {
        return this.severity;
    }

    public final String getSQLState() {
        return this.sqlState;
    }

    public final SQLException getNextException() {
        return this.next;
    }

    final void markAsPublicAPI() {
        this.isForPublicAPI = true;
    }

    public static String getSQLStateFromIdentifier(String messageID) {
        if (messageID.length() == 5) {
            return messageID;
        }
        return messageID.substring(0, 5);
    }

    public static int getSeverityFromIdentifier(String messageID) {
        int lseverity = 0;
        block0 : switch (messageID.length()) {
            case 5: {
                block3 : switch (messageID.charAt(0)) {
                    case '0': {
                        switch (messageID.charAt(1)) {
                            case '1': {
                                lseverity = 10000;
                                break;
                            }
                            case '7': 
                            case 'A': {
                                lseverity = 20000;
                                break;
                            }
                            case '8': {
                                lseverity = 40000;
                            }
                        }
                        break;
                    }
                    case '2': 
                    case '3': {
                        lseverity = 20000;
                        break;
                    }
                    case '4': {
                        switch (messageID.charAt(1)) {
                            case '0': {
                                lseverity = 30000;
                                break block3;
                            }
                            case '2': {
                                lseverity = 20000;
                            }
                        }
                    }
                }
                break;
            }
            default: {
                switch (messageID.charAt(6)) {
                    case 'M': {
                        lseverity = 50000;
                        break block0;
                    }
                    case 'D': {
                        lseverity = 45000;
                        break block0;
                    }
                    case 'C': {
                        lseverity = 40000;
                        break block0;
                    }
                    case 'T': {
                        lseverity = 30000;
                        break block0;
                    }
                    case 'S': {
                        lseverity = 20000;
                        break block0;
                    }
                    case 'U': {
                        lseverity = 0;
                    }
                }
            }
        }
        return lseverity;
    }

    public static StandardException normalClose() {
        StandardException se = StandardException.newException("XXXXX.C.6", new Object[0]);
        se.report = 1;
        return se;
    }

    public static StandardException newException(String messageId, Object ... args) {
        return StandardException.newException(messageId, null, args);
    }

    public static StandardException newException(String messageId, Throwable t, Object ... args) {
        return new StandardException(messageId, t, args);
    }

    public static StandardException newException(String messageID, Object a1, Throwable t) throws BadMessageArgumentException {
        throw new BadMessageArgumentException();
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Throwable t) throws BadMessageArgumentException {
        throw new BadMessageArgumentException();
    }

    public static StandardException newPreLocalizedException(String MessageID, Throwable t, String localizedMessage) {
        StandardException se = new StandardException(MessageID, localizedMessage);
        if (t != null) {
            se.initCause(t);
        }
        return se;
    }

    public static StandardException getArgumentFerry(SQLException se) {
        Throwable cause = se.getCause();
        return cause instanceof StandardException ? (StandardException)cause : null;
    }

    private static boolean isVacuousWrapper(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return t.getCause() != null;
        }
        return false;
    }

    public static StandardException unexpectedUserException(Throwable t) {
        SQLException sqlex;
        String state;
        SQLException sqle;
        if (StandardException.isVacuousWrapper(t)) {
            return StandardException.unexpectedUserException(t.getCause());
        }
        StandardException ferry = null;
        if (t instanceof SQLException && (ferry = StandardException.getArgumentFerry(sqle = (SQLException)t)) != null && ferry.isForPublicAPI) {
            ferry.next = sqle.getNextException();
            return ferry;
        }
        if (t instanceof SQLException && ferry == null && (state = (sqlex = (SQLException)t).getSQLState()) != null && state.length() == 5 && state.startsWith("38") && !state.equals("38000")) {
            StandardException se = new StandardException(state, sqlex.getMessage());
            if (sqlex.getNextException() != null) {
                se.initCause(sqlex.getNextException());
            }
            return se;
        }
        if (t instanceof StandardException) {
            return (StandardException)t;
        }
        Object detailMessage = t.getMessage();
        detailMessage = detailMessage == null ? "" : ((String)detailMessage).trim();
        detailMessage = ((String)detailMessage).length() == 0 ? t.getClass().getName() : t.getClass().getName() + ": " + (String)detailMessage;
        return StandardException.newException("38000", t, detailMessage);
    }

    public static StandardException plainWrapException(Throwable t) {
        SQLException sqle;
        String sqlState;
        if (StandardException.isVacuousWrapper(t)) {
            return StandardException.plainWrapException(t.getCause());
        }
        if (t instanceof StandardException) {
            return (StandardException)t;
        }
        if (t instanceof SQLException && (sqlState = (sqle = (SQLException)t).getSQLState()) != null) {
            StandardException se = new StandardException(sqlState, "(" + sqle.getErrorCode() + ") " + sqle.getMessage());
            if ((sqle = sqle.getNextException()) != null) {
                se.initCause(StandardException.plainWrapException(sqle));
            }
            return se;
        }
        String detailMessage = t.getMessage();
        detailMessage = detailMessage == null ? "" : detailMessage.trim();
        StandardException se = StandardException.newException("XJ001.U", t, detailMessage, t.getClass().getName());
        return se;
    }

    public static StandardException closeException() {
        StandardException se = StandardException.newException("close.C.1", new Object[0]);
        se.setReport(1);
        return se;
    }

    @Override
    public String getMessage() {
        if (this.textMessage == null) {
            this.textMessage = MessageService.getTextMessage(this.getMessageId(), this.getArguments());
        }
        return this.textMessage;
    }

    public final String getMessageId() {
        return super.getMessage();
    }

    public String getErrorProperty(String type) {
        return StandardException.getErrorProperty(this.getMessageId(), type);
    }

    @Override
    public String toString() {
        String msg = this.getMessage();
        return "ERROR " + this.getSQLState() + ": " + msg;
    }

    private static String getErrorProperty(String messageId, String type) {
        return MessageService.getProperty(messageId, type);
    }

    public static StandardException interrupt(InterruptedException ie) {
        StandardException se = StandardException.newException("08000", ie, new Object[0]);
        return se;
    }

    public static SQLWarning newWarning(String messageId, Object ... oa) {
        String message = MessageService.getTextMessage(messageId, oa);
        String state = StandardException.getSQLStateFromIdentifier(messageId);
        SQLWarning sqlw = new SQLWarning(message, state, 10000);
        return sqlw;
    }

    public final boolean isLockTimeout() {
        return "40XL1".equals(this.getSQLState());
    }

    public final boolean isSelfDeadlock() {
        return "40XL2".equals(this.getSQLState());
    }

    public final boolean isLockTimeoutOrDeadlock() {
        return "40XL1".equals(this.getSQLState()) || "40001".equals(this.getSQLState());
    }

    public static class BadMessageArgumentException
    extends Throwable {
    }
}

