/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.internal.client;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TimeStamp
extends Number
implements Comparable<TimeStamp> {
    public static final TimeStamp UNSPECIFIED_DATE = new TimeStamp(0L);
    private static final Pattern PATTERN = Pattern.compile("(\\d{8}|\\d{6}|\\d{4})(-(\\d{2}(\\d{2}(\\d{2})?)?)(-(\\d{1,3}))?)?");
    private static final int NANOS_PER_MILLI = 1000000;
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();
    private static final long serialVersionUID = 1L;
    private final long value;

    public TimeStamp() {
        this(System.currentTimeMillis());
    }

    public TimeStamp(String string) throws DateTimeException {
        this(TimeStamp.parseTimeStamp(string));
    }

    public TimeStamp(long value) {
        this.value = value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int compareTo(TimeStamp obj) {
        return TimeStamp.compare(this.value, obj.value);
    }

    public int hashCode() {
        return TimeStamp.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeStamp) {
            return this.value == ((TimeStamp)obj).longValue();
        }
        return false;
    }

    public String toString() {
        return TimeStamp.toString(this.value);
    }

    private static void pad(StringBuilder builder, int value, int length) {
        String string = Integer.toString(value);
        int fill = length - string.length();
        int i = 0;
        while (i < fill) {
            builder.append('0');
            ++i;
        }
        builder.append(string);
    }

    private static String exceptionMessage(String string) {
        return "Invalid time stamp format: \"" + string + "\"";
    }

    public static int compare(long x, long y) {
        return Long.compare(x, y);
    }

    public static int hashCode(long value) {
        return Long.hashCode(value);
    }

    public static String toString(long value) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(value), ZONE_ID);
        StringBuilder builder = new StringBuilder(19);
        TimeStamp.pad(builder, localDateTime.getYear(), 4);
        TimeStamp.pad(builder, localDateTime.getMonthValue(), 2);
        TimeStamp.pad(builder, localDateTime.getDayOfMonth(), 2);
        builder.append('-');
        TimeStamp.pad(builder, localDateTime.getHour(), 2);
        TimeStamp.pad(builder, localDateTime.getMinute(), 2);
        TimeStamp.pad(builder, localDateTime.getSecond(), 2);
        builder.append('-');
        TimeStamp.pad(builder, localDateTime.getNano() / 1000000, 3);
        return builder.toString();
    }

    public static long parseTimeStamp(String string) throws DateTimeException {
        Matcher matcher = PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new DateTimeException(TimeStamp.exceptionMessage(string));
        }
        try {
            Object date = matcher.group(1);
            if (((String)date).length() == 4) {
                date = Integer.toString(LocalDate.now().getYear()) + (String)date;
            } else if (((String)date).length() == 6) {
                date = Integer.toString(LocalDate.now().getYear() / 100) + (String)date;
            }
            Object time = matcher.group(3);
            if (time == null) {
                time = "000000";
            } else if (((String)time).length() == 2) {
                time = (String)time + "0000";
            } else if (((String)time).length() == 4) {
                time = (String)time + "00";
            }
            Object millis = matcher.group(7);
            if (millis == null) {
                millis = "000";
            } else if (((String)millis).length() == 1) {
                millis = "00" + (String)millis;
            } else if (((String)millis).length() == 2) {
                millis = "0" + (String)millis;
            }
            int year = Integer.parseInt(((String)date).substring(0, 4));
            int month = Integer.parseInt(((String)date).substring(4, 6));
            int day = Integer.parseInt(((String)date).substring(6, 8));
            LocalDate localDate = LocalDate.of(year, month, day);
            int hour = Integer.parseInt(((String)time).substring(0, 2));
            int minute = Integer.parseInt(((String)time).substring(2, 4));
            int second = Integer.parseInt(((String)time).substring(4, 6));
            int nanos = Integer.parseInt((String)millis) * 1000000;
            LocalTime localTime = LocalTime.of(hour, minute, second, nanos);
            LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
            ZonedDateTime zonedDateTime = localDateTime.atZone(ZONE_ID);
            return zonedDateTime.toInstant().toEpochMilli();
        }
        catch (DateTimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DateTimeException(TimeStamp.exceptionMessage(string), ex);
        }
    }
}

