/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.mem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.internal.server.mem.MEMStore;
import org.eclipse.emf.cdo.internal.server.mem.MEMStoreChunkReader;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.LongIDStoreAccessor;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class MEMStoreAccessor
extends LongIDStoreAccessor
implements IStoreAccessor.Raw2,
IStoreAccessor.DurableLocking2,
InternalCDOBranchManager.BranchLoader5 {
    private final MEMStore store;
    private List<InternalCDORevision> newRevisions;

    public MEMStoreAccessor(MEMStore store, ISession session) {
        super((Store)store, session);
        this.store = store;
    }

    public MEMStoreAccessor(MEMStore store, ITransaction transaction) {
        super((Store)store, transaction);
        this.store = store;
    }

    @Override
    public MEMStore getStore() {
        return this.store;
    }

    @Override
    public MEMStoreChunkReader createChunkReader(InternalCDORevision revision, EStructuralFeature feature) {
        return new MEMStoreChunkReader(this, (CDORevision)revision, feature);
    }

    @Override
    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        return Collections.emptySet();
    }

    @Override
    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        throw new UnsupportedOperationException();
    }

    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        return this.store.createBranch(branchID, branchInfo);
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        return this.store.loadBranch(branchID);
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        return this.store.loadSubBranches(branchID);
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
        return this.store.loadBranches(startID, endID, branchHandler);
    }

    public CDOBranch[] deleteBranches(int branchID, OMMonitor monitor) {
        return this.store.deleteBranches(branchID, monitor);
    }

    public void renameBranch(int branchID, String oldName, String newName) {
        this.store.renameBranch(branchID, oldName, newName);
    }

    public CDOBranchPoint changeTag(AtomicInteger modCount, String oldName, String newName, CDOBranchPoint branchPoint) {
        return null;
    }

    public void loadTags(String name, Consumer<InternalCDOBranchManager.BranchLoader.BranchInfo> handler) {
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        this.store.loadCommitInfos(branch, startTime, endTime, handler);
    }

    @Override
    public Set<CDOID> readChangeSet(OMMonitor monitor, CDOChangeSetSegment ... segments) {
        return this.store.readChangeSet(segments);
    }

    @Override
    public InternalCDORevision readRevision(CDOID id, CDOBranchPoint branchPoint, int listChunk, CDORevisionCacheAdder cache) {
        return this.store.getRevision(id, branchPoint);
    }

    @Override
    public InternalCDORevision readRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int listChunk, CDORevisionCacheAdder cache) {
        return this.store.getRevisionByVersion(id, branchVersion);
    }

    @Override
    public void handleRevisions(EClass eClass, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        this.store.handleRevisions(eClass, branch, timeStamp, exactTime, handler);
    }

    @Override
    protected void doCommit(OMMonitor monitor) {
        this.newRevisions = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWrite(InternalCommitContext context, OMMonitor monitor) {
        MEMStore mEMStore = this.store;
        synchronized (mEMStore) {
            super.doWrite(context, monitor);
        }
    }

    @Override
    protected void writeCommitInfo(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, CDOBranchPoint mergeSource, OMMonitor monitor) {
        this.store.addCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, mergeSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRollback(IStoreAccessor.CommitContext context) {
        if (this.newRevisions != null) {
            MEMStore mEMStore = this.store;
            synchronized (mEMStore) {
                for (InternalCDORevision revision : this.newRevisions) {
                    this.store.rollbackRevision(revision);
                }
            }
        }
    }

    @Override
    public void writePackageUnits(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
    }

    @Override
    protected void writeRevisions(InternalCDORevision[] revisions, CDOBranch branch, OMMonitor monitor) {
        InternalCDORevision[] internalCDORevisionArray = revisions;
        int n = revisions.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevision revision = internalCDORevisionArray[n2];
            this.writeRevision(revision);
            ++n2;
        }
    }

    protected void writeRevision(InternalCDORevision revision) {
        if (this.newRevisions == null) {
            this.newRevisions = new ArrayList<InternalCDORevision>();
        }
        this.newRevisions.add(revision);
        this.store.addRevision(revision, false);
    }

    @Override
    protected void writeRevisionDeltas(InternalCDORevisionDelta[] revisionDeltas, CDOBranch branch, long created, OMMonitor monitor) {
        InternalCDORevisionDelta[] internalCDORevisionDeltaArray = revisionDeltas;
        int n = revisionDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevisionDelta revisionDelta = internalCDORevisionDeltaArray[n2];
            this.writeRevisionDelta(revisionDelta, branch, created);
            ++n2;
        }
    }

    protected void writeRevisionDelta(InternalCDORevisionDelta revisionDelta, CDOBranch branch, long created) {
        CDOID id = revisionDelta.getID();
        InternalCDORevision revision = this.store.getRevisionByVersion(id, (CDOBranchVersion)revisionDelta);
        if (revision == null) {
            throw new ConcurrentModificationException("Trying to update object " + id + " that was already modified");
        }
        InternalCDORevision newRevision = revision.copy();
        newRevision.adjustForCommit(branch, created);
        revisionDelta.applyTo((CDORevision)newRevision);
        this.writeRevision(newRevision);
    }

    @Override
    protected void detachObjects(CDOID[] detachedObjects, CDOBranch branch, long timeStamp, OMMonitor monitor) {
        CDOID[] cDOIDArray = detachedObjects;
        int n = detachedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            CDOID id = cDOIDArray[n2];
            this.detachObject(id, branch, timeStamp);
            ++n2;
        }
    }

    protected void detachObject(CDOID id, CDOBranch branch, long timeStamp) {
        this.store.detachObject(id, branch, timeStamp);
    }

    @Override
    public void queryResources(IStoreAccessor.QueryResourcesContext context) {
        this.store.queryResources(context);
    }

    @Override
    public void queryXRefs(IStoreAccessor.QueryXRefsContext context) {
        this.store.queryXRefs(context);
    }

    @Override
    public IQueryHandler getQueryHandler(CDOQueryInfo info) {
        return null;
    }

    @Override
    public void rawExport(CDODataOutput out, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime) throws IOException {
        this.store.rawExport(out, fromBranchID, toBranchID, fromCommitTime, toCommitTime);
    }

    @Override
    public void rawImport(CDODataInput in, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        this.store.rawImport(in, fromBranchID, toBranchID, fromCommitTime, toCommitTime, monitor);
    }

    @Override
    public void rawStore(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        this.writePackageUnits(packageUnits, monitor);
    }

    @Override
    public void rawStore(InternalCDORevision revision, OMMonitor monitor) {
        this.store.addRevision(revision, true);
    }

    @Override
    public void rawStore(byte[] id, long size, InputStream inputStream) throws IOException {
        this.writeBlob(id, size, inputStream);
    }

    @Override
    public void rawStore(byte[] id, long size, Reader reader) throws IOException {
        this.writeClob(id, size, reader);
    }

    @Override
    public void rawStore(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, OMMonitor monitor) {
        this.writeCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, null, monitor);
    }

    @Override
    public void rawStore(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, CDOBranchPoint mergeSource, OMMonitor monitor) {
        this.writeCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, mergeSource, monitor);
    }

    @Override
    public void rawDelete(CDOID id, int version, CDOBranch branch, EClass eClass, OMMonitor monitor) {
        this.store.rawDelete(id, version, branch);
    }

    @Override
    public void rawCommit(double commitWork, OMMonitor monitor) {
    }

    public IDurableLockingManager.LockArea createLockArea(String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        return this.store.createLockArea(userID, branchPoint, readOnly, locks);
    }

    @Override
    public IDurableLockingManager.LockArea createLockArea(String durableLockingID, String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        return this.store.createLockArea(durableLockingID, userID, branchPoint, readOnly, locks);
    }

    @Override
    public void updateLockArea(IDurableLockingManager.LockArea lockArea) {
        this.store.updateLockArea(lockArea);
    }

    public IDurableLockingManager.LockArea getLockArea(String durableLockingID) throws IDurableLockingManager.LockAreaNotFoundException {
        return this.store.getLockArea(durableLockingID);
    }

    public void getLockAreas(String userIDPrefix, IDurableLockingManager.LockArea.Handler handler) {
        this.store.getLockAreas(userIDPrefix, handler);
    }

    public void deleteLockArea(String durableLockingID) {
        this.store.deleteLockArea(durableLockingID);
    }

    @Override
    public void lock(String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToLock) {
        this.store.lock(durableLockingID, type, objectsToLock);
    }

    @Override
    public void unlock(String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToUnlock) {
        this.store.unlock(durableLockingID, type, objectsToUnlock);
    }

    @Override
    public void queryLobs(List<byte[]> ids) {
        this.store.queryLobs(ids);
    }

    @Override
    public void handleLobs(long fromTime, long toTime, CDOLobHandler handler) throws IOException {
        this.store.handleLobs(fromTime, toTime, handler);
    }

    @Override
    public void loadLob(byte[] id, OutputStream out) throws IOException {
        this.store.loadLob(id, out);
    }

    @Override
    protected void writeBlob(byte[] id, long size, InputStream inputStream) throws IOException {
        this.store.writeBlob(id, size, inputStream);
    }

    @Override
    protected void writeClob(byte[] id, long size, Reader reader) throws IOException {
        this.store.writeClob(id, size, reader);
    }

    protected void doDeactivate() throws Exception {
        if (this.newRevisions != null) {
            this.newRevisions.clear();
            this.newRevisions = null;
        }
        super.doDeactivate();
    }

    @Deprecated
    public void deleteBranch(int branchID) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void renameBranch(int branchID, String newName) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    protected void writeCommitInfo(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void unlock(String durableLockingID) {
        throw new UnsupportedOperationException();
    }
}

