/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db;

import java.io.File;
import java.util.Map;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.server.db.evolution.phased.Context;
import org.eclipse.emf.cdo.server.db.evolution.phased.DefaultRepositoryExporter;
import org.eclipse.emf.cdo.server.db.evolution.phased.FolderContextManager;
import org.eclipse.emf.cdo.server.db.evolution.phased.Phase;
import org.eclipse.emf.cdo.server.db.evolution.phased.PhasedModelEvolutionSupport;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.tests.AbstractCDOTest;
import org.eclipse.emf.cdo.tests.config.impl.ConfigTest;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

@ConfigTest.CleanRepositoriesBefore(reason="Model evolution")
@ConfigTest.CleanRepositoriesAfter(reason="Model evolution")
public class ModelEvolutionTest
extends AbstractCDOTest {
    private static final EPackage.Registry PACKAGE_REGISTRY = EPackage.Registry.INSTANCE;
    private static final ResourceSet RESOURCE_SET = EMFUtil.newEcoreResourceSet((EPackage.Registry)PACKAGE_REGISTRY);
    private static final String NS_URI = "http://www.example.org/model";
    private static final EPackage V1 = ModelEvolutionTest.createModelV1();
    private PhasedModelEvolutionSupport support;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        RESOURCE_SET.getResources().clear();
    }

    protected void doTearDown() throws Exception {
        RESOURCE_SET.getResources().clear();
        super.doTearDown();
    }

    protected void initTestProperties(Map<String, Object> properties) {
        File rootFolder = this.createTempFolder();
        FolderContextManager contextManager = new FolderContextManager();
        contextManager.setSaveNewModels(true);
        this.support = new PhasedModelEvolutionSupport();
        this.support.setRootFolder(rootFolder);
        this.support.setContextManager((Context.Manager)contextManager);
        this.support.setMode(PhasedModelEvolutionSupport.Mode.Migrate);
        this.support.setRepositoryExporter((Phase.Handler)new DefaultRepositoryExporter());
        super.initTestProperties(properties);
        properties.put("test.repository.InitialPackages", new EPackage[]{V1});
        properties.put("test.repository.ModelEvolutionSupport", this.support);
    }

    public void testFeatureAddition() throws Exception {
        CDOSession session = this.openSession();
        CDOTransaction transaction = session.openTransaction();
        CDOResource resource = transaction.createResource(this.getResourcePath("test"));
        EObject a = ModelEvolutionTest.create(V1, "A");
        resource.getContents().add((Object)a);
        EObject b1 = ModelEvolutionTest.create(V1, "B");
        ModelEvolutionTest.list(a, "children_bidi").add((Object)b1);
        b1.eSet(b1.eClass().getEStructuralFeature("shape"), (Object)((EEnum)V1.getEClassifier("Shape")).getEEnumLiteral("TRIANGLE"));
        EObject b2 = ModelEvolutionTest.create(V1, "B");
        ModelEvolutionTest.list(a, "children").add((Object)b2);
        b2.eSet(b2.eClass().getEStructuralFeature("shape"), (Object)((EEnum)V1.getEClassifier("Shape")).getEEnumLiteral("RECTANGLE"));
        transaction.commit();
        EPackage v2 = ModelEvolutionTest.registerPackage((EPackage)EcoreUtil.copy((EObject)V1));
        EEnum v2Shape = (EEnum)v2.getEClassifier("Shape");
        EClass v2A = (EClass)v2.getEClassifier("A");
        EClass v2B = (EClass)v2.getEClassifier("B");
        for (EEnumLiteral literal : v2Shape.getELiterals()) {
            if (literal.getValue() < 3) continue;
            literal.setValue(literal.getValue() + 1);
        }
        EMFUtil.createEEnumLiteral((EEnum)v2Shape, (String)"PENTAGON", (int)3);
        v2A.getEStructuralFeatures().remove(0);
        EAttribute v2Aname = EcoreFactory.eINSTANCE.createEAttribute();
        v2Aname.setName("name");
        v2Aname.setEType((EClassifier)EcorePackage.Literals.ESTRING);
        v2A.getEStructuralFeatures().add(1, (Object)v2Aname);
        EReference v2Anew_children = EcoreFactory.eINSTANCE.createEReference();
        v2Anew_children.setName("new_children");
        v2Anew_children.setEType((EClassifier)v2B);
        v2Anew_children.setUpperBound(-1);
        v2Anew_children.setContainment(true);
        v2A.getEStructuralFeatures().add((Object)v2Anew_children);
        EAttribute v2Bname = EcoreFactory.eINSTANCE.createEAttribute();
        v2Bname.setName("name");
        v2Bname.setEType((EClassifier)EcorePackage.Literals.ESTRING);
        v2B.getEStructuralFeatures().add(0, (Object)v2Bname);
        this.restartRepository();
        CDOSession session2 = this.openSession();
        ModelEvolutionTest.msg((Object)EMFUtil.getXMI((EPackage)session2.getPackageRegistry().getEPackage(NS_URI)));
        CDOTransaction transaction2 = session2.openTransaction();
        CDOResource resource2 = transaction2.getResource(this.getResourcePath("test"));
        EObject a2 = (EObject)resource2.getContents().get(0);
        a2.eSet((EStructuralFeature)v2Aname, (Object)"Eike Stepper");
        EObject b3 = ModelEvolutionTest.create(v2, "B");
        ModelEvolutionTest.list(a2, "new_children").add((Object)b3);
        transaction2.commit();
        System.out.println();
    }

    private static EObject create(EPackage ePackage, EClass eClass) {
        return ePackage.getEFactoryInstance().create(eClass);
    }

    private static EObject create(EPackage ePackage, String className) {
        return ModelEvolutionTest.create(ePackage, (EClass)ePackage.getEClassifier(className));
    }

    private static EList<EObject> list(EObject object, EStructuralFeature feature) {
        return (EList)object.eGet(feature);
    }

    private static EList<EObject> list(EObject object, String featureName) {
        return ModelEvolutionTest.list(object, object.eClass().getEStructuralFeature(featureName));
    }

    private static void linkOpposites(EReference ref1, EReference ref2) {
        ref1.setEOpposite(ref2);
        ref2.setEOpposite(ref1);
    }

    private static EPackage registerPackage(EPackage ePackage) {
        String nsURI = ePackage.getNsURI();
        RESOURCE_SET.createResource(URI.createURI((String)nsURI)).getContents().add((Object)ePackage);
        PACKAGE_REGISTRY.put((Object)nsURI, (Object)ePackage);
        return ePackage;
    }

    private static EPackage createModelV1() {
        EPackage model = EMFUtil.createEPackage((String)"model", (String)"model", (String)NS_URI);
        EEnum Shape = EMFUtil.createEEnum((EPackage)model, (String)"Shape", (String[])new String[]{"CIRCLE", "SQUARE", "TRIANGLE", "RECTANGLE", "OVAL", "DIAMOND"});
        EClass A = EMFUtil.createEClass((EPackage)model, (String)"A");
        EClass B = EMFUtil.createEClass((EPackage)model, (String)"B");
        EReference A_sub_a = EMFUtil.createEReference((EClass)A, (String)"sub_a", (EClassifier)A);
        A_sub_a.setContainment(true);
        EReference A_children = EMFUtil.createEReference((EClass)A, (String)"children", (EClassifier)B, (boolean)false, (boolean)true);
        A_children.setContainment(true);
        EReference A_children_bidi = EMFUtil.createEReference((EClass)A, (String)"children_bidi", (EClassifier)B, (boolean)false, (boolean)true);
        A_children_bidi.setContainment(true);
        EReference B_parent = EMFUtil.createEReference((EClass)B, (String)"parent", (EClassifier)A);
        ModelEvolutionTest.linkOpposites(A_children_bidi, B_parent);
        EMFUtil.createEAttribute((EClass)B, (String)"shape", (EClassifier)Shape);
        return ModelEvolutionTest.registerPackage(model);
    }
}

