/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.internal.db.IObjectTypeMapper;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.AbstractMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.MappingNames;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.ObjectTypeCache;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.ObjectTypeTable;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class AbstractHorizontalMappingStrategy
extends AbstractMappingStrategy {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractHorizontalMappingStrategy.class);
    private static final EAttribute[] NO_PERSISTENT_LOB_ATTRIBUTES = new EAttribute[0];
    private ObjectTypeTable objects;
    private IObjectTypeMapper objectTypeMapper;
    private IClassMapping resourceFolderMapping;
    private IClassMapping modelResourceMapping;
    private IClassMapping textResourceMapping;
    private IClassMapping binaryResourceMapping;

    public final ObjectTypeTable objects() {
        return this.objects;
    }

    public IObjectTypeMapper getObjectTypeMapper() {
        return this.objectTypeMapper;
    }

    @Override
    public CDOClassifierRef readObjectType(IDBStoreAccessor accessor, CDOID id) {
        return this.objectTypeMapper.getObjectType(accessor, id);
    }

    public boolean putObjectType(IDBStoreAccessor accessor, long timeStamp, CDOID id, EClass type) {
        return this.objectTypeMapper.putObjectType(accessor, timeStamp, id, type);
    }

    public boolean removeObjectType(IDBStoreAccessor accessor, CDOID id) {
        return this.objectTypeMapper.removeObjectType(accessor, id);
    }

    @Override
    public void repairAfterCrash(IDBAdapter dbAdapter, Connection connection) {
        IDBStore store = this.getStore();
        IRepository repository = store.getRepository();
        if (repository.getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            IIDHandler idHandler = store.getIDHandler();
            if (repository.isSupportingBranches()) {
                CDOID minLocalID = this.getMinLocalID(connection);
                idHandler.setNextLocalObjectID(minLocalID);
            }
            CDOID maxID = this.objectTypeMapper.getMaxID(connection, idHandler);
            idHandler.setLastObjectID(maxID);
        }
    }

    @Override
    public void queryResources(IDBStoreAccessor accessor, IStoreAccessor.QueryResourcesContext context) {
        boolean shallContinue;
        if (context.getTimeStamp() != 0L && !this.hasAuditSupport()) {
            throw new IllegalArgumentException("Mapping Strategy does not support audits");
        }
        if (this.resourceFolderMapping == null) {
            this.resourceFolderMapping = this.getClassMapping(EresourcePackage.eINSTANCE.getCDOResourceFolder());
            this.modelResourceMapping = this.getClassMapping(EresourcePackage.eINSTANCE.getCDOResource());
            this.textResourceMapping = this.getClassMapping(EresourcePackage.eINSTANCE.getCDOTextResource());
            this.binaryResourceMapping = this.getClassMapping(EresourcePackage.eINSTANCE.getCDOBinaryResource());
        }
        if (shallContinue = true) {
            shallContinue = this.queryResources(accessor, this.resourceFolderMapping, context);
        }
        if (shallContinue) {
            shallContinue = this.queryResources(accessor, this.modelResourceMapping, context);
        }
        if (shallContinue) {
            shallContinue = this.queryResources(accessor, this.textResourceMapping, context);
        }
        if (shallContinue) {
            shallContinue = this.queryResources(accessor, this.binaryResourceMapping, context);
        }
    }

    @Override
    public void queryXRefs(IDBStoreAccessor accessor, IStoreAccessor.QueryXRefsContext context) {
        IIDHandler idHandler = this.getStore().getIDHandler();
        StringBuilder builder = null;
        for (CDOID targetID : context.getTargetObjects().keySet()) {
            if (builder == null) {
                builder = new StringBuilder("(");
            } else {
                builder.append(",");
            }
            idHandler.appendCDOID(builder, targetID);
        }
        builder.append(")");
        String idString = builder.toString();
        for (EClass eClass : context.getSourceCandidates().keySet()) {
            IClassMapping classMapping = this.getClassMapping(eClass);
            boolean more = classMapping.queryXRefs(accessor, context, idString);
            if (more) continue;
            return;
        }
    }

    @Override
    public void rawExport(IDBStoreAccessor accessor, CDODataOutput out, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(" WHERE a_t.");
        builder.append(DBUtil.quoted((String)MappingNames.ATTRIBUTES_CREATED));
        builder.append(" BETWEEN ");
        builder.append(fromCommitTime);
        builder.append(" AND ");
        builder.append(toCommitTime);
        String attrSuffix = builder.toString();
        IDBConnection connection = accessor.getDBConnection();
        Collection<IClassMapping> classMappings = this.getClassMappings(true).values();
        out.writeXInt(classMappings.size());
        for (IClassMapping classMapping : classMappings) {
            EClass eClass = classMapping.getEClass();
            out.writeCDOClassifierRef((EClassifier)eClass);
            IDBTable table = classMapping.getDBTables().get(0);
            DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)table, (String)"a_t", (String)attrSuffix);
            for (IListMapping listMapping : classMapping.getListMappings()) {
                this.rawExportList(out, connection, listMapping, table, attrSuffix);
            }
        }
        this.objectTypeMapper.rawExport((Connection)connection, out, fromCommitTime, toCommitTime);
    }

    protected void rawExportList(CDODataOutput out, IDBConnection connection, IListMapping listMapping, IDBTable attrTable, String attrSuffix) throws IOException {
        for (IDBTable table : listMapping.getDBTables()) {
            String listSuffix = ", " + attrTable + " a_t" + attrSuffix;
            String listJoin = this.getListJoinForRawExport("a_t", "l_t");
            if (listJoin != null) {
                listSuffix = String.valueOf(listSuffix) + listJoin;
            }
            DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)table, (String)"l_t", (String)listSuffix);
        }
    }

    protected String getListJoinForRawExport(String attrTable, String listTable) {
        return this.getListJoin(attrTable, listTable);
    }

    @Override
    public void rawImport(IDBStoreAccessor accessor, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        int size = in.readXInt();
        if (size == 0) {
            return;
        }
        int objectTypeMapperWork = 10;
        monitor.begin((double)(3 * size + objectTypeMapperWork));
        try {
            IDBConnection connection = accessor.getDBConnection();
            int i = 0;
            while (i < size) {
                EClass eClass = (EClass)in.readCDOClassifierRefAndResolve();
                IClassMapping classMapping = this.getClassMapping(eClass);
                IDBTable table = classMapping.getDBTables().get(0);
                DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)table, (OMMonitor)monitor.fork());
                this.rawImportReviseOldRevisions(connection, table, monitor.fork());
                this.rawImportUnreviseNewRevisions(connection, table, fromCommitTime, toCommitTime, monitor.fork());
                List<IListMapping> listMappings = classMapping.getListMappings();
                int listSize = listMappings.size();
                if (listSize == 0) {
                    monitor.worked();
                } else {
                    OMMonitor listMonitor = monitor.fork();
                    listMonitor.begin((double)listSize);
                    try {
                        for (IListMapping listMapping : listMappings) {
                            this.rawImportList(in, connection, listMapping, listMonitor.fork());
                        }
                    }
                    finally {
                        listMonitor.done();
                    }
                }
                ++i;
            }
            this.objectTypeMapper.rawImport((Connection)connection, in, monitor.fork((double)objectTypeMapperWork));
        }
        finally {
            monitor.done();
        }
    }

    protected void rawImportUnreviseNewRevisions(IDBConnection connection, IDBTable table, long fromCommitTime, long toCommitTime, OMMonitor monitor) {
        throw new UnsupportedOperationException("Must be overridden");
    }

    protected void rawImportReviseOldRevisions(IDBConnection connection, IDBTable table, OMMonitor monitor) {
        throw new UnsupportedOperationException("Must be overridden");
    }

    protected void rawImportList(CDODataInput in, IDBConnection connection, IListMapping listMapping, OMMonitor monitor) throws IOException {
        Collection<IDBTable> tables = listMapping.getDBTables();
        int size = tables.size();
        if (size == 0) {
            return;
        }
        monitor.begin((double)size);
        try {
            for (IDBTable table : tables) {
                DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)table, (OMMonitor)monitor.fork(), (DBUtil.DeserializeRowHandler)this.getImportListHandler());
            }
        }
        finally {
            monitor.done();
        }
    }

    protected DBUtil.DeserializeRowHandler getImportListHandler() {
        return null;
    }

    @Override
    public String getListJoin(String attrTable, String listTable) {
        return " AND " + attrTable + "." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_ID) + "=" + listTable + "." + DBUtil.quoted((String)MappingNames.LIST_REVISION_ID);
    }

    @Override
    protected boolean isMapped(EClass eClass) {
        return !eClass.isAbstract() && !eClass.isInterface();
    }

    @Override
    protected Collection<EClass> getClassesWithObjectInfo() {
        return this.getClassMappings().keySet();
    }

    @Override
    protected EAttribute[] getPersistentLobAttributes(EClass eClass) {
        if (!eClass.isAbstract() && !eClass.isInterface()) {
            return CDOModelUtil.getClassInfo((EClass)eClass).getAllPersistentLobAttributes();
        }
        return NO_PERSISTENT_LOB_ATTRIBUTES;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.objectTypeMapper == null) {
            this.objectTypeMapper = this.createObjectTypeMapper();
        }
        LifecycleUtil.activate((Object)this.objectTypeMapper);
    }

    @Override
    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.objectTypeMapper);
        this.resourceFolderMapping = null;
        this.modelResourceMapping = null;
        this.textResourceMapping = null;
        this.binaryResourceMapping = null;
        super.doDeactivate();
    }

    private IObjectTypeMapper createObjectTypeMapper() {
        this.objects = new ObjectTypeTable(this.getStore());
        int cacheSize = this.getObjectTypeCacheSize();
        if (cacheSize == 0) {
            return this.objects;
        }
        ObjectTypeCache cache = new ObjectTypeCache(cacheSize);
        cache.setMappingStrategy(this);
        cache.setDelegate(this.objects);
        return cache;
    }

    private int getObjectTypeCacheSize() {
        int objectTypeCacheSize = 100000;
        String value = this.getProperties().get("objectTypeCacheSize");
        if (value != null) {
            try {
                int intValue;
                objectTypeCacheSize = intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                OM.LOG.warn("Malformed configuration option for object type cache size. Using default.");
            }
        }
        return objectTypeCacheSize;
    }

    private boolean queryResources(IDBStoreAccessor accessor, IClassMapping classMapping, IStoreAccessor.QueryResourcesContext context) {
        CDOID folderID = context.getFolderID();
        String name = context.getName();
        boolean exactMatch = context.exactMatch();
        IIDHandler idHandler = this.getStore().getIDHandler();
        PreparedStatement stmt = classMapping.createResourceQueryStatement(accessor, folderID, name, exactMatch, (CDOBranchPoint)context);
        if (stmt == null) {
            return true;
        }
        ResultSet resultSet = null;
        try {
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                CDOID id = idHandler.getCDOID(resultSet, 1);
                if (TRACER.isEnabled()) {
                    TRACER.trace("Resource query returned ID " + id);
                }
                if (context.addResource(id)) continue;
                return false;
            }
            return true;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }

    private CDOID getMinLocalID(Connection connection) {
        final IIDHandler idHandler = this.getStore().getIDHandler();
        final CDOID[] min = new CDOID[]{idHandler.getMaxCDOID()};
        String id = DBUtil.quoted((String)MappingNames.ATTRIBUTES_ID);
        String branch = DBUtil.quoted((String)MappingNames.ATTRIBUTES_BRANCH);
        String created = DBUtil.quoted((String)MappingNames.ATTRIBUTES_CREATED);
        final String prefix = "SELECT MIN(t." + id + ") FROM " + this.objects + " o, ";
        final String suffix = " t WHERE t." + branch + "<0 AND t." + id + "=o." + id + " AND t." + created + "=o." + created;
        this.getStore().visitAllTables(connection, new IDBStore.TableVisitor(){

            @Override
            public void visitTable(Connection connection, String name) throws SQLException {
                Statement stmt = null;
                ResultSet resultSet = null;
                try {
                    CDOID id;
                    stmt = connection.createStatement();
                    resultSet = stmt.executeQuery(String.valueOf(prefix) + name + suffix);
                    if (resultSet.next() && (id = idHandler.getCDOID(resultSet, 1)) != null && idHandler.compare(id, min[0]) < 0) {
                        min[0] = id;
                    }
                }
                catch (Throwable throwable) {
                    DBUtil.close(resultSet);
                    DBUtil.close((Statement)stmt);
                    throw throwable;
                }
                DBUtil.close((ResultSet)resultSet);
                DBUtil.close((Statement)stmt);
            }
        });
        return min[0];
    }
}

