/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.ws;

import java.net.HttpCookie;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.net4j.internal.ws.WSClientConnector;
import org.eclipse.net4j.internal.ws.WSConnector;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.spi.net4j.ConnectorFactory;

public class WSConnectorFactory
extends ConnectorFactory {
    public static final String TOKEN_SEPARATOR = "\n";
    public static final String COOKIE_TOKEN_PREFIX = "cookie:";

    public WSConnectorFactory() {
        super("ws");
    }

    protected WSConnectorFactory(String type) {
        super(type);
    }

    public WSClientConnector create(String description) throws ProductCreationException {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        String[] descriptionTokens = description.split(TOKEN_SEPARATOR);
        String urlDescription = descriptionTokens[0];
        int i = 1;
        while (i < descriptionTokens.length) {
            int index;
            String cookieString;
            String token = descriptionTokens[i];
            if (token.startsWith(COOKIE_TOKEN_PREFIX)) {
                cookieString = token.replaceFirst(COOKIE_TOKEN_PREFIX, "");
                index = cookieString.indexOf("=");
                if (index < 1) {
                    throw new ProductCreationException("Invalid cookie token: " + token);
                }
            } else {
                throw new ProductCreationException("Unrecognized description token: " + token);
            }
            String name = cookieString.substring(0, index);
            String value = cookieString.substring(index + 1);
            cookies.add(new HttpCookie(name, value));
            ++i;
        }
        WSClientConnector connector = this.createConnector();
        try {
            connector.setURL(this.getType() + "://" + urlDescription);
        }
        catch (URISyntaxException ex) {
            throw new ProductCreationException((Throwable)ex);
        }
        connector.setCookies(cookies);
        return connector;
    }

    protected WSClientConnector createConnector() {
        return new WSClientConnector();
    }

    public String getDescriptionFor(Object object) {
        if (object instanceof WSConnector) {
            WSConnector connector = (WSConnector)object;
            String description = connector.getURL();
            if (connector instanceof WSClientConnector) {
                WSClientConnector clientConnector = (WSClientConnector)connector;
                StringBuilder sb = new StringBuilder(description);
                for (HttpCookie cookie : clientConnector.getCookies()) {
                    sb.append(TOKEN_SEPARATOR);
                    sb.append(COOKIE_TOKEN_PREFIX);
                    sb.append(cookie.getName());
                    sb.append("=");
                    sb.append(cookie.getValue());
                }
                description = sb.toString();
            }
            return description;
        }
        return null;
    }
}

