/*
 * Decompiled with CFR 0.152.
 */
package org.gastro.inventory.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.gastro.inventory.Department;
import org.gastro.inventory.Employee;
import org.gastro.inventory.Ingredient;
import org.gastro.inventory.InventoryFactory;
import org.gastro.inventory.InventoryPackage;
import org.gastro.inventory.MenuCard;
import org.gastro.inventory.Offering;
import org.gastro.inventory.Recipe;
import org.gastro.inventory.Restaurant;
import org.gastro.inventory.Section;
import org.gastro.inventory.Stock;
import org.gastro.inventory.StockProduct;
import org.gastro.inventory.Table;
import org.gastro.inventory.impl.DepartmentImpl;
import org.gastro.inventory.impl.EmployeeImpl;
import org.gastro.inventory.impl.IngredientImpl;
import org.gastro.inventory.impl.MenuCardImpl;
import org.gastro.inventory.impl.OfferingImpl;
import org.gastro.inventory.impl.RecipeImpl;
import org.gastro.inventory.impl.RestaurantImpl;
import org.gastro.inventory.impl.SectionImpl;
import org.gastro.inventory.impl.StockImpl;
import org.gastro.inventory.impl.StockProductImpl;
import org.gastro.inventory.impl.TableImpl;

public class InventoryFactoryImpl
extends EFactoryImpl
implements InventoryFactory {
    public static InventoryFactory init() {
        try {
            InventoryFactory theInventoryFactory = (InventoryFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.gastro.org/inventory/1.0");
            if (theInventoryFactory != null) {
                return theInventoryFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new InventoryFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createStock();
            }
            case 2: {
                return this.createStockProduct();
            }
            case 3: {
                return this.createRecipe();
            }
            case 4: {
                return this.createIngredient();
            }
            case 5: {
                return this.createMenuCard();
            }
            case 6: {
                return this.createRestaurant();
            }
            case 7: {
                return this.createDepartment();
            }
            case 8: {
                return this.createOffering();
            }
            case 9: {
                return this.createTable();
            }
            case 10: {
                return this.createEmployee();
            }
            case 12: {
                return this.createSection();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    @Override
    public Stock createStock() {
        StockImpl stock = new StockImpl();
        return stock;
    }

    @Override
    public StockProduct createStockProduct() {
        StockProductImpl stockProduct = new StockProductImpl();
        return stockProduct;
    }

    @Override
    public Recipe createRecipe() {
        RecipeImpl recipe = new RecipeImpl();
        return recipe;
    }

    @Override
    public Ingredient createIngredient() {
        IngredientImpl ingredient = new IngredientImpl();
        return ingredient;
    }

    @Override
    public MenuCard createMenuCard() {
        MenuCardImpl menuCard = new MenuCardImpl();
        return menuCard;
    }

    @Override
    public Restaurant createRestaurant() {
        RestaurantImpl restaurant = new RestaurantImpl();
        return restaurant;
    }

    @Override
    public Department createDepartment() {
        DepartmentImpl department = new DepartmentImpl();
        return department;
    }

    @Override
    public Offering createOffering() {
        OfferingImpl offering = new OfferingImpl();
        return offering;
    }

    @Override
    public Table createTable() {
        TableImpl table = new TableImpl();
        return table;
    }

    @Override
    public Employee createEmployee() {
        EmployeeImpl employee = new EmployeeImpl();
        return employee;
    }

    @Override
    public Section createSection() {
        SectionImpl section = new SectionImpl();
        return section;
    }

    @Override
    public InventoryPackage getInventoryPackage() {
        return (InventoryPackage)this.getEPackage();
    }

    @Deprecated
    public static InventoryPackage getPackage() {
        return InventoryPackage.eINSTANCE;
    }
}

