/*
 * Decompiled with CFR 0.152.
 */
package org.gastro.internal.server;

import java.util.HashMap;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.net4j.CDONet4jServerUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.OSGiActivator;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.OMTracer;
import org.h2.jdbcx.JdbcDataSource;

public abstract class OM {
    public static final String BUNDLE_ID = "org.gastro.server";
    public static final OMBundle BUNDLE = OMPlatform.INSTANCE.bundle("org.gastro.server", OM.class);
    public static final OMTracer DEBUG = BUNDLE.tracer("debug");
    public static final OMLogger LOG = BUNDLE.logger();
    private static IAcceptor acceptor;
    public static IRepository repository;

    public static final class Activator
    extends OSGiActivator {
        private String serverPort;

        public Activator() {
            super(BUNDLE);
        }

        protected void doStart() throws Exception {
            this.serverPort = System.getProperty("org.gastro.server.port");
            if (this.serverPort == null) {
                return;
            }
            LOG.info("Gastro server starting");
            JdbcDataSource dataSource = new JdbcDataSource();
            dataSource.setURL("jdbc:h2:database/gastro");
            IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)true);
            H2Adapter dbAdapter = new H2Adapter();
            IDBConnectionProvider dbConnectionProvider = dbAdapter.createConnectionProvider((DataSource)dataSource);
            IDBStore store = CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)dbConnectionProvider);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("overrideUUID", "gastro");
            props.put("supportingAudits", "true");
            props.put("supportingBranches", "false");
            repository = CDOServerUtil.createRepository((String)"gastro", (IStore)store, props);
            CDOServerUtil.addRepository((IManagedContainer)IPluginContainer.INSTANCE, (IRepository)repository);
            CDONet4jServerUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
            String description = "0.0.0.0:" + this.serverPort;
            acceptor = (IAcceptor)IPluginContainer.INSTANCE.getElement("org.eclipse.net4j.acceptors", "tcp", description);
            LOG.info("Gastro server started");
        }

        protected void doStop() throws Exception {
            if (this.serverPort == null) {
                return;
            }
            LOG.info("Gastro server stopping");
            LifecycleUtil.deactivate((Object)acceptor);
            LifecycleUtil.deactivate((Object)repository);
            LOG.info("Gastro server stopped");
        }
    }
}

