/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor.IEObjectAccessor;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

public class EObjectAccessor
implements IEObjectAccessor {
    private final EObject fEObject;
    private final AdapterFactory fAdapterFactory;

    public EObjectAccessor(AdapterFactory adapterFactory, EObject eObject) {
        this.fAdapterFactory = adapterFactory;
        this.fEObject = eObject;
    }

    public String getName() {
        return this.fEObject.eClass().getName();
    }

    public Image getImage() {
        Adapter adapter = this.fAdapterFactory.adapt((Notifier)this.fEObject, IItemLabelProvider.class);
        if (adapter instanceof IItemLabelProvider) {
            Object image = ((IItemLabelProvider)adapter).getImage((Object)this.fEObject);
            return ExtendedImageRegistry.getInstance().getImage(image);
        }
        return null;
    }

    public EObject getEObject() {
        return this.fEObject;
    }

    public InputStream getContents() throws CoreException {
        XMIResourceImpl r = new XMIResourceImpl(URI.createURI((String)"dummy.xmi"));
        ProperContentCopier copier = new ProperContentCopier();
        EObject copy = copier.copy(this.fEObject);
        copier.copyReferences();
        r.getContents().add((Object)copy);
        StringWriter sw = new StringWriter();
        try {
            r.save((Writer)sw, (Map)Maps.newHashMap());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.compare.rcp.ui", e.getMessage(), (Throwable)e));
        }
        return new ByteArrayInputStream(sw.toString().getBytes());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BoundProperContentIterator
    extends EcoreUtil.ProperContentIterator<EObject> {
        public BoundProperContentIterator(EObject eObject, EReference eReference) {
            super(eObject, false);
            List contents = (List)ReferenceUtil.safeEGet((EObject)eObject, (EStructuralFeature)eReference);
            this.iterator = contents instanceof InternalEList ? ((InternalEList)contents).basicIterator() : contents.iterator();
        }
    }

    private class ProperContentCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = -5458049632291531717L;

        public ProperContentCopier() {
            this.resolveProxies = false;
        }

        /*
         * Unable to fully structure code
         */
        protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
            block5: {
                block4: {
                    if (!eObject.eIsSet((EStructuralFeature)eReference)) {
                        return;
                    }
                    if (!eReference.isMany()) break block4;
                    source = new BoundProperContentIterator(eObject, eReference);
                    target = (List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference), this.resolveProxies);
                    if (source.hasNext()) ** GOTO lbl12
                    target.clear();
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        next = (EObject)source.next();
                        target.add(this.copy(next));
lbl12:
                        // 2 sources

                        ** while (source.hasNext())
                    }
lbl13:
                    // 1 sources

                    break block5;
                }
                childEObject = (EObject)eObject.eGet((EStructuralFeature)eReference, this.resolveProxies);
                if (childEObject == null) {
                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
                } else {
                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), (Object)this.copy(childEObject));
                }
            }
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (!eObject.eIsSet((EStructuralFeature)eReference)) {
                return;
            }
            if (eReference.isMany()) {
                BoundProperContentIterator source = new BoundProperContentIterator(eObject, eReference);
                InternalEList target = (InternalEList)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference), false);
                if (!source.hasNext()) {
                    target.clear();
                } else {
                    boolean isBidirectional = eReference.getEOpposite() != null;
                    int index = 0;
                    while (source.hasNext()) {
                        EObject next = (EObject)source.next();
                        EObject copyReferencedEObject = (EObject)this.get(next);
                        if (copyReferencedEObject == null) {
                            if (!this.useOriginalReferences || isBidirectional) continue;
                            target.addUnique(index, (Object)next);
                            ++index;
                            continue;
                        }
                        if (isBidirectional) {
                            int position = target.indexOf((Object)copyReferencedEObject);
                            if (position == -1) {
                                target.addUnique(index, (Object)copyReferencedEObject);
                            } else if (index != position) {
                                target.move(index, (Object)copyReferencedEObject);
                            }
                        } else {
                            target.addUnique(index, (Object)copyReferencedEObject);
                        }
                        ++index;
                    }
                }
            } else {
                Object referencedEObject = eObject.eGet((EStructuralFeature)eReference, this.resolveProxies);
                if (referencedEObject == null) {
                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
                } else {
                    Object copyReferencedEObject = this.get(referencedEObject);
                    if (copyReferencedEObject == null) {
                        if (this.useOriginalReferences && eReference.getEOpposite() == null) {
                            copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), referencedEObject);
                        }
                    } else {
                        copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), copyReferencedEObject);
                    }
                }
            }
        }
    }
}

