/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.spec;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.impl.ComparisonImpl;
import org.eclipse.emf.compare.internal.DiffCrossReferencer;
import org.eclipse.emf.compare.internal.MatchCrossReferencer;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonSpec
extends ComparisonImpl {
    private static final Function<EStructuralFeature.Setting, EObject> INVERSE_REFERENCES = new Function<EStructuralFeature.Setting, EObject>(){

        public EObject apply(EStructuralFeature.Setting input) {
            if (input != null) {
                return input.getEObject();
            }
            return null;
        }
    };
    private MatchCrossReferencer matchCrossReferencer;
    private DiffCrossReferencer diffCrossReferencer;

    @Override
    public EList<Diff> getDifferences() {
        UnmodifiableIterator diffIterator = Iterators.filter((Iterator)this.eAllContents(), Diff.class);
        BasicEList allDifferences = new BasicEList();
        while (diffIterator.hasNext()) {
            ((AbstractEList)allDifferences).addUnique((Object)((Diff)diffIterator.next()));
        }
        return allDifferences;
    }

    @Override
    public EList<Diff> getDifferences(EObject element) {
        if (element == null) {
            return new BasicEList();
        }
        if (this.diffCrossReferencer == null) {
            this.diffCrossReferencer = new DiffCrossReferencer();
            this.eAdapters().add((Object)this.diffCrossReferencer);
        }
        Iterable crossRefs = Iterables.filter(this.getInverse(element, this.diffCrossReferencer), Diff.class);
        BasicEList diffs = new BasicEList();
        for (Diff diff : crossRefs) {
            diffs.add((Object)diff);
        }
        return diffs;
    }

    @Override
    public Match getMatch(EObject element) {
        if (element == null) {
            return null;
        }
        if (this.matchCrossReferencer == null) {
            this.matchCrossReferencer = new MatchCrossReferencer();
            this.eAdapters().add((Object)this.matchCrossReferencer);
        }
        Iterable crossRefs = Iterables.filter(this.getInverse(element, this.matchCrossReferencer), Match.class);
        return (Match)Iterables.getFirst((Iterable)crossRefs, null);
    }

    private Iterable<EObject> getInverse(EObject element, ECrossReferenceAdapter adapter) {
        return this.getInverse(element, adapter, (Predicate<EStructuralFeature.Setting>)Predicates.alwaysTrue());
    }

    private Iterable<EObject> getInverse(EObject element, ECrossReferenceAdapter adapter, Predicate<EStructuralFeature.Setting> settingsFilter) {
        Collection settings = adapter.getInverseReferences(element, false);
        return Iterables.transform((Iterable)Iterables.filter((Iterable)settings, settingsFilter), INVERSE_REFERENCES);
    }

    @Override
    public IEqualityHelper getEqualityHelper() {
        IEqualityHelper ret = (IEqualityHelper)EcoreUtil.getExistingAdapter((Notifier)this, IEqualityHelper.class);
        if (ret == null) {
            ret = new EqualityHelper(EqualityHelper.createDefaultCache((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().maximumSize(1024)));
            this.eAdapters().add((Object)ret);
            ret.setTarget((Notifier)this);
        }
        return ret;
    }
}

