/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.compare.match.eobject.EObjectIndex;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProximityIndex
implements EObjectIndex {
    private ProximityEObjectMatcher.DistanceFunction meter;
    private List<EObject> lefts;
    private List<EObject> rights;
    private List<EObject> origins;

    public ProximityIndex(ProximityEObjectMatcher.DistanceFunction meter) {
        this.meter = meter;
        this.lefts = Lists.newArrayList();
        this.rights = Lists.newArrayList();
        this.origins = Lists.newArrayList();
    }

    @Override
    public Map<EObjectIndex.Side, EObject> findClosests(EObject eObj, EObjectIndex.Side passedObjectSide) {
        HashMap<EObjectIndex.Side, EObject> result = new HashMap<EObjectIndex.Side, EObject>(3);
        result.put(passedObjectSide, eObj);
        if (passedObjectSide == EObjectIndex.Side.LEFT) {
            EObject closestRight = this.findTheClosest(eObj, EObjectIndex.Side.LEFT, EObjectIndex.Side.RIGHT, true);
            EObject closestOrigin = this.findTheClosest(eObj, EObjectIndex.Side.LEFT, EObjectIndex.Side.ORIGIN, true);
            result.put(EObjectIndex.Side.RIGHT, closestRight);
            result.put(EObjectIndex.Side.ORIGIN, closestOrigin);
        } else if (passedObjectSide == EObjectIndex.Side.RIGHT) {
            EObject closestLeft = this.findTheClosest(eObj, EObjectIndex.Side.RIGHT, EObjectIndex.Side.LEFT, true);
            EObject closestOrigin = this.findTheClosest(eObj, EObjectIndex.Side.RIGHT, EObjectIndex.Side.ORIGIN, true);
            result.put(EObjectIndex.Side.LEFT, closestLeft);
            result.put(EObjectIndex.Side.ORIGIN, closestOrigin);
        } else if (passedObjectSide == EObjectIndex.Side.ORIGIN) {
            EObject closestLeft = this.findTheClosest(eObj, EObjectIndex.Side.ORIGIN, EObjectIndex.Side.LEFT, true);
            EObject closestRight = this.findTheClosest(eObj, EObjectIndex.Side.ORIGIN, EObjectIndex.Side.RIGHT, true);
            result.put(EObjectIndex.Side.LEFT, closestLeft);
            result.put(EObjectIndex.Side.RIGHT, closestRight);
        }
        return result;
    }

    private EObject findTheClosest(EObject eObj, EObjectIndex.Side originalSide, EObjectIndex.Side sideToFind, boolean shouldDoubleCheck) {
        List<EObject> storageToSearchFor = this.lefts;
        switch (sideToFind) {
            case RIGHT: {
                storageToSearchFor = this.rights;
                break;
            }
            case LEFT: {
                storageToSearchFor = this.lefts;
                break;
            }
            case ORIGIN: {
                storageToSearchFor = this.origins;
                break;
            }
        }
        EObject best = null;
        int bestDist = Integer.MAX_VALUE;
        Iterator<EObject> it = storageToSearchFor.iterator();
        while (it.hasNext() && best == null) {
            EObject fastCheck = it.next();
            if (!this.meter.areIdentic(eObj, fastCheck)) continue;
            best = fastCheck;
            bestDist = 0;
        }
        if (best != null) {
            return best;
        }
        it = storageToSearchFor.iterator();
        while (bestDist != 0 && it.hasNext()) {
            EObject potentialClosest = it.next();
            int dist = this.meter.distance(eObj, potentialClosest);
            if (dist >= bestDist) continue;
            if (shouldDoubleCheck) {
                EObject doubleCheck = this.findTheClosest(potentialClosest, sideToFind, originalSide, false);
                if (doubleCheck != eObj) continue;
                bestDist = dist;
                best = potentialClosest;
                continue;
            }
            bestDist = dist;
            best = potentialClosest;
        }
        return best;
    }

    @Override
    public void remove(EObject obj, EObjectIndex.Side side) {
        switch (side) {
            case RIGHT: {
                this.rights.remove(obj);
                break;
            }
            case LEFT: {
                this.lefts.remove(obj);
                break;
            }
            case ORIGIN: {
                this.origins.remove(obj);
                break;
            }
        }
    }

    @Override
    public void index(EObject eObject, EObjectIndex.Side side) {
        switch (side) {
            case RIGHT: {
                this.rights.add(eObject);
                break;
            }
            case LEFT: {
                this.lefts.add(eObject);
                break;
            }
            case ORIGIN: {
                this.origins.add(eObject);
                break;
            }
        }
    }

    @Override
    public Collection<EObject> getValuesStillThere(EObjectIndex.Side side) {
        ImmutableList result = Collections.emptyList();
        switch (side) {
            case RIGHT: {
                result = ImmutableList.copyOf(this.rights);
                break;
            }
            case LEFT: {
                result = ImmutableList.copyOf(this.lefts);
                break;
            }
            case ORIGIN: {
                result = ImmutableList.copyOf(this.origins);
                break;
            }
        }
        return result;
    }
}

