/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.diff.internal.extension.factories;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.diagram.DiagramCompareFactory;
import org.eclipse.emf.compare.diagram.DiagramDiff;
import org.eclipse.emf.compare.diagram.EdgeChange;
import org.eclipse.emf.compare.diagram.diff.internal.extension.AbstractDiffExtensionFactory;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeChangeFactory
extends AbstractDiffExtensionFactory {
    @Override
    public Class<? extends Diff> getExtensionKind() {
        return EdgeChange.class;
    }

    @Override
    public Diff create(Diff input) {
        EdgeChange ret = DiagramCompareFactory.eINSTANCE.createEdgeChange();
        DifferenceKind extensionKind = this.getRelatedExtensionKind(input);
        ret.setKind(extensionKind);
        if (extensionKind == DifferenceKind.MOVE) {
            ret.getRefinedBy().addAll(this.getAllDifferencesForMove(input));
        } else if (extensionKind == DifferenceKind.ADD) {
            ret.getRefinedBy().add((Object)input);
            ret.getRefinedBy().addAll(this.getAllContainedDifferences((ReferenceChange)input));
        } else if (extensionKind == DifferenceKind.DELETE) {
            ret.getRefinedBy().add((Object)input);
        }
        EObject view = null;
        if (input instanceof ReferenceChange) {
            view = ((ReferenceChange)input).getValue();
        } else if (input instanceof AttributeChange) {
            view = MatchUtil.getContainer((Comparison)input.getMatch().getComparison(), (Diff)input);
        }
        while (view != null && !(view instanceof Edge)) {
            view = view.eContainer();
        }
        ret.setView(view);
        ret.setSource(input.getSource());
        ret.setSemanticDiff(this.getSemanticDiff(input));
        return ret;
    }

    @Override
    public void fillRequiredDifferences(Comparison comparison, Diff extension) {
        EList candidates;
        DiagramDiff diff = (DiagramDiff)extension;
        Diff semanticDiff = diff.getSemanticDiff();
        View view = (View)diff.getView();
        Match viewMatch = comparison.getMatch((EObject)view);
        if (view instanceof Edge) {
            EList sourceCandidates = comparison.getDifferences((EObject)((Edge)view).getSource());
            for (Diff sourceDiff : sourceCandidates) {
                EList candidates2;
                if (!(sourceDiff instanceof ReferenceChange) || ((ReferenceChange)sourceDiff).getReference() != NotationPackage.Literals.EDGE__SOURCE || ((ReferenceChange)sourceDiff).getMatch() != viewMatch) continue;
                for (Diff sourceRequired : sourceDiff.getRequires()) {
                    candidates2 = comparison.getDifferences((EObject)sourceRequired);
                    for (DiagramDiff diagramDiff : Iterables.filter((Iterable)candidates2, DiagramDiff.class)) {
                        if (diff == diagramDiff) continue;
                        diff.getRequires().add((Object)diagramDiff);
                    }
                }
                for (Diff sourceRequiredBy : sourceDiff.getRequiredBy()) {
                    candidates2 = comparison.getDifferences((EObject)sourceRequiredBy);
                    for (DiagramDiff diagramDiff : Iterables.filter((Iterable)candidates2, DiagramDiff.class)) {
                        if (diff == diagramDiff) continue;
                        diff.getRequiredBy().add((Object)diagramDiff);
                    }
                }
            }
            EList targetCandidates = comparison.getDifferences((EObject)((Edge)view).getTarget());
            for (Diff targetDiff : targetCandidates) {
                EList candidates3;
                if (!(targetDiff instanceof ReferenceChange) || ((ReferenceChange)targetDiff).getReference() != NotationPackage.Literals.EDGE__TARGET || ((ReferenceChange)targetDiff).getMatch() != viewMatch) continue;
                for (Diff targetRequired : targetDiff.getRequires()) {
                    candidates3 = comparison.getDifferences((EObject)targetRequired);
                    for (DiagramDiff diagramDiff : Iterables.filter((Iterable)candidates3, DiagramDiff.class)) {
                        if (diff == diagramDiff) continue;
                        diff.getRequires().add((Object)diagramDiff);
                    }
                }
                for (Diff targetRequiredBy : targetDiff.getRequiredBy()) {
                    candidates3 = comparison.getDifferences((EObject)targetRequiredBy);
                    for (DiagramDiff diagramDiff : Iterables.filter((Iterable)candidates3, DiagramDiff.class)) {
                        if (diff == diagramDiff) continue;
                        diff.getRequiredBy().add((Object)diagramDiff);
                    }
                }
            }
        }
        if (semanticDiff == null) {
            return;
        }
        for (Diff semanticRequired : semanticDiff.getRequires()) {
            candidates = comparison.getDifferences((EObject)semanticRequired);
            for (DiagramDiff diagramDiff : Iterables.filter((Iterable)candidates, DiagramDiff.class)) {
                if (diagramDiff.getSemanticDiff() != semanticRequired) continue;
                diff.getRequires().add((Object)diagramDiff);
            }
        }
        for (Diff semanticRequiredBy : semanticDiff.getRequiredBy()) {
            candidates = comparison.getDifferences((EObject)semanticRequiredBy);
            for (DiagramDiff diagramDiff : Iterables.filter((Iterable)candidates, DiagramDiff.class)) {
                if (diagramDiff.getSemanticDiff() != semanticRequiredBy) continue;
                diff.getRequiredBy().add((Object)diagramDiff);
            }
        }
    }

    @Override
    public Match getParentMatch(Diff input) {
        return input.getMatch().getComparison().getMatch((EObject)this.getViewContainer(input));
    }

    @Override
    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return input.getValue() instanceof Edge && input.getReference().isContainment() && input.getKind() == DifferenceKind.ADD;
    }

    @Override
    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return input.getValue() instanceof Edge && input.getReference().isContainment() && input.getKind() == DifferenceKind.DELETE;
    }

    @Override
    protected boolean isRelatedToAnExtensionMove(AttributeChange input) {
        return input.getAttribute().eContainer().equals(NotationPackage.eINSTANCE.getRelativeBendpoints()) || input.getAttribute().equals(NotationPackage.eINSTANCE.getIdentityAnchor_Id()) && input.getRefines().isEmpty();
    }

    @Override
    protected boolean isRelatedToAnExtensionMove(ReferenceChange input) {
        return input.getValue() instanceof IdentityAnchor && input.getReference().isContainment() && input.getRefines().isEmpty();
    }

    private Set<Diff> getAllDifferencesForMove(Diff input) {
        Comparison comparison = input.getMatch().getComparison();
        Match match = input.getMatch();
        Set<Diff> result = this.getAllNonExtendedDifferences(comparison, match);
        return result;
    }

    private Set<Diff> getAllNonExtendedDifferences(Comparison comparison, Match match) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        LinkedHashSet prune = Sets.newLinkedHashSet();
        for (Diff candidate : match.getDifferences()) {
            if (this.getRelatedExtensionKind(candidate) != null) {
                result.add(candidate);
                continue;
            }
            if (!(candidate instanceof ReferenceChange) || !((ReferenceChange)candidate).getReference().isContainment()) continue;
            prune.add(comparison.getMatch(((ReferenceChange)candidate).getValue()));
        }
        for (Match submatch : match.getSubmatches()) {
            if (prune.contains(submatch)) continue;
            result.addAll(this.getAllNonExtendedDifferences(comparison, submatch));
        }
        return result;
    }

    private Diff getSemanticDiff(Diff input) {
        List<Diff> diffs;
        View view;
        Object element;
        if (input instanceof ReferenceChange && ((ReferenceChange)input).getValue() instanceof View && (element = ReferenceUtil.safeEGet((EObject)(view = (View)((ReferenceChange)input).getValue()), (EStructuralFeature)NotationPackage.Literals.VIEW__ELEMENT)) instanceof EObject && (diffs = this.findCrossReferences(input.getMatch().getComparison(), (EObject)element, new Predicate<Diff>(){

            public boolean apply(Diff diff) {
                return diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment();
            }
        })).size() > 0) {
            return diffs.get(0);
        }
        return null;
    }
}

