/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.ReferenceChangeItemProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.spec.Strings;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceChangeItemProviderSpec
extends ReferenceChangeItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    private static final int ELIDE_LENGTH = 50;
    private final OverlayImageProvider overlayProvider = new OverlayImageProvider(this.getResourceLocator());

    public ReferenceChangeItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    static String changeText(Diff diff, EStructuralFeature feature) {
        EObject otherSide;
        EObject sourceSide;
        DifferenceSource source = diff.getSource();
        Match matchOfInterrest = diff.getMatch();
        if (source == DifferenceSource.LEFT) {
            sourceSide = matchOfInterrest.getLeft();
            otherSide = matchOfInterrest.getRight();
        } else {
            sourceSide = matchOfInterrest.getRight();
            otherSide = matchOfInterrest.getLeft();
        }
        String changeText = ReferenceChangeItemProviderSpec.changeText(feature, sourceSide, otherSide);
        return changeText;
    }

    private static String changeText(EStructuralFeature eStructuralFeature, EObject sourceSide, EObject otherSide) {
        Object otherValue;
        Object leftValue;
        String changeText = sourceSide != null ? ((leftValue = ReferenceUtil.safeEGet((EObject)sourceSide, (EStructuralFeature)eStructuralFeature)) == null || ReferenceChangeItemProviderSpec.isStringAndNullOrEmpty(leftValue) ? "unset" : (otherSide != null ? ((otherValue = ReferenceUtil.safeEGet((EObject)otherSide, (EStructuralFeature)eStructuralFeature)) == null || ReferenceChangeItemProviderSpec.isStringAndNullOrEmpty(otherValue) ? "set" : "changed") : "set")) : "unset";
        return changeText;
    }

    private static boolean isStringAndNullOrEmpty(Object s) {
        if (s instanceof String) {
            return com.google.common.base.Strings.isNullOrEmpty((String)((String)s));
        }
        return false;
    }

    protected String getReferenceText(ReferenceChange refChange) {
        return refChange.getReference().getName();
    }

    protected String getValueText(ReferenceChange refChange) {
        String value = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), refChange.getValue());
        value = value == null ? "<null>" : Strings.elide(value, 50, "...");
        return value;
    }

    @Override
    public Object getImage(Object object) {
        ReferenceChange refChange = (ReferenceChange)object;
        Object refChangeValueImage = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), refChange.getValue());
        Object diffImage = this.overlayProvider.getComposedImage((Diff)refChange, refChangeValueImage);
        Object ret = this.overlayImage(object, diffImage);
        return ret;
    }

    public Collection<?> getChildren(Object object) {
        Match matchOfValue;
        Collection superChildren = super.getChildren(object);
        ArrayList ret = Lists.newArrayList((Iterable)superChildren);
        ReferenceChange referenceChange = (ReferenceChange)object;
        EReference reference = referenceChange.getReference();
        if (reference.isContainment() && (matchOfValue = referenceChange.getMatch().getComparison().getMatch(referenceChange.getValue())) != null) {
            Collection<?> children = this.getChildren(matchOfValue);
            children.remove(referenceChange);
            ret.addAll(children);
        }
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)ret, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(ResourceAttachmentChange.class))));
    }

    private Collection<?> getChildren(Match matchOfValue) {
        Object children;
        ITreeItemContentProvider matchItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt((Notifier)matchOfValue, ITreeItemContentProvider.class);
        if (matchItemContentProvider != null) {
            Collection itemProviderChildren = matchItemContentProvider.getChildren((Object)matchOfValue);
            children = itemProviderChildren instanceof ImmutableCollection ? Lists.newArrayList((Iterable)itemProviderChildren) : itemProviderChildren;
            Iterator childrenIterator = children.iterator();
            while (childrenIterator.hasNext()) {
                Object child = childrenIterator.next();
                if (!(child instanceof Match) || matchItemContentProvider.hasChildren(child)) continue;
                childrenIterator.remove();
            }
        } else {
            children = ImmutableList.of();
        }
        return children;
    }

    public Object getForeground(Object object) {
        ReferenceChange referenceChange = (ReferenceChange)object;
        switch (referenceChange.getState()) {
            case MERGED: 
            case DISCARDED: {
                return URI.createURI((String)"color://rgb/156/156/156");
            }
        }
        return super.getForeground(object);
    }

    @Override
    public IStyledString.IComposedStyledString getStyledText(Object object) {
        ReferenceChange refChange = (ReferenceChange)object;
        String valueText = this.getValueText(refChange);
        String referenceText = this.getReferenceText(refChange);
        ComposedStyledString ret = new ComposedStyledString(valueText);
        ret.append(" [" + referenceText, IStyledString.Style.DECORATIONS_STYLER);
        switch (refChange.getKind()) {
            case ADD: {
                ret.append(" add", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case DELETE: {
                ret.append(" delete", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case CHANGE: {
                ret.append(" " + ReferenceChangeItemProviderSpec.changeText((Diff)refChange, (EStructuralFeature)refChange.getReference()), IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case MOVE: {
                ret.append(" move", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + refChange.getKind());
            }
        }
        ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
        return ret;
    }

    @Override
    public String getDescription(Object object) {
        ReferenceChange refChange = (ReferenceChange)object;
        String valueText = this.getValueText(refChange);
        String referenceText = this.getReferenceText(refChange);
        String remotely = "";
        if (refChange.getSource() == DifferenceSource.RIGHT) {
            remotely = "remotely ";
        }
        String ret = "";
        switch (refChange.getKind()) {
            case ADD: {
                ret = String.valueOf(valueText) + " has been " + remotely + "added to " + referenceText;
                break;
            }
            case DELETE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "deleted from " + referenceText;
                break;
            }
            case CHANGE: {
                String changeText = ReferenceChangeItemProviderSpec.changeText((Diff)refChange, (EStructuralFeature)refChange.getReference());
                ret = String.valueOf(referenceText) + " " + valueText + " has been " + remotely + changeText;
                break;
            }
            case MOVE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "moved in " + referenceText;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + refChange.getKind());
            }
        }
        return ret;
    }
}

