/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreeWayComparisonGroupProvider
implements IDifferenceGroupProvider {
    private String label;
    private boolean activeByDefault;

    @Override
    public Iterable<? extends IDifferenceGroup> getGroups(Comparison comparison) {
        EList diffs = comparison.getDifferences();
        BasicDifferenceGroupImpl leftSide = new BasicDifferenceGroupImpl(comparison, (Iterable<? extends Diff>)diffs, (Predicate<? super Diff>)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}))), "Left side");
        BasicDifferenceGroupImpl rightSide = new BasicDifferenceGroupImpl(comparison, (Iterable<? extends Diff>)diffs, (Predicate<? super Diff>)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}))), "Right side");
        BasicDifferenceGroupImpl conflicts = new BasicDifferenceGroupImpl(comparison, (Iterable<? extends Diff>)diffs, (Predicate<? super Diff>)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}), "Conflicts");
        return ImmutableList.of((Object)leftSide, (Object)rightSide, (Object)conflicts);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean defaultSelected() {
        return this.activeByDefault;
    }

    @Override
    public void setDefaultSelected(boolean active) {
        this.activeByDefault = active;
    }

    @Override
    public boolean isEnabled(IComparisonScope scope, Comparison comparison) {
        return comparison != null && comparison.isThreeWay();
    }
}

